/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.job;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import io.moewe.confluence.addons.awards.KarmaUserProfile;
import io.moewe.confluence.addons.awards.TimeFrame;
import io.moewe.confluence.addons.awards.rest.pojo.parameter.ProcessorParameter;
import io.moewe.confluence.addons.awards.services.KarmaScoreManager;
import io.moewe.confluence.addons.awards.services.ProcessorRunner;
import java.util.Arrays;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class AwardsScoreCalculationJob
implements JobRunner {
    private final KarmaScoreManager karmaScoreManager;
    private final TransactionTemplate transactionTemplate;
    private final ProcessorRunner processorRunner;

    @Inject
    public AwardsScoreCalculationJob(KarmaScoreManager karmaScoreManager, @ComponentImport TransactionTemplate transactionTemplate, ProcessorRunner processorRunner) {
        this.karmaScoreManager = karmaScoreManager;
        this.transactionTemplate = transactionTemplate;
        this.processorRunner = processorRunner;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        if (jobRunnerRequest.isCancellationRequested()) {
            return JobRunnerResponse.aborted((String)"Job cancelled.");
        }
        this.transactionTemplate.execute(() -> {
            HashMap karmaLeadersBeforeCalculation = new HashMap();
            Arrays.stream(TimeFrame.values()).forEach(timeFrame -> karmaLeadersBeforeCalculation.put(timeFrame, this.karmaScoreManager.getKarmaLeader((TimeFrame)((Object)((Object)timeFrame)))));
            boolean calculateUserScore = this.karmaScoreManager.calculateUserScore();
            if (calculateUserScore) {
                Arrays.stream(TimeFrame.values()).forEach(timeFrame -> {
                    KarmaUserProfile karmaLeader = this.karmaScoreManager.getKarmaLeader((TimeFrame)((Object)((Object)timeFrame)));
                    if (karmaLeader != null) {
                        if (karmaLeadersBeforeCalculation.containsKey(timeFrame)) {
                            KarmaUserProfile karmaLeaderBeforeCalculation = (KarmaUserProfile)karmaLeadersBeforeCalculation.get(timeFrame);
                            if (karmaLeaderBeforeCalculation != null && !karmaLeader.getUserKey().equals(karmaLeaderBeforeCalculation.getUserKey())) {
                                this.processorRunner.run(new ProcessorParameter(timeFrame.getAwardsEvent()), karmaLeader);
                            }
                        } else {
                            this.processorRunner.run(new ProcessorParameter(timeFrame.getAwardsEvent()), karmaLeader);
                        }
                    }
                });
            }
            return null;
        });
        return JobRunnerResponse.success((String)"Successfully executed Job named AwardsScoreCalculationJob");
    }
}

