/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards;

public enum AwardsEvent {
    ATTACHMENT_CREATED(PermissionType.PAGE),
    ATTACHMENT_REMOVED(PermissionType.PAGE),
    ATTACHMENT_RESTORED(PermissionType.PAGE),
    ATTACHMENT_TRASHED(PermissionType.PAGE),
    ATTACHMENT_UPDATED(PermissionType.PAGE),
    BLOG_CREATED(PermissionType.PAGE),
    BLOG_REMOVED(PermissionType.PAGE),
    BLOG_RESTORED(PermissionType.PAGE),
    BLOG_TRASHED(PermissionType.PAGE),
    BLOG_UPDATED(PermissionType.PAGE),
    BLOG_FOLLOWED(PermissionType.PAGE),
    COMMENT_CREATED(PermissionType.PAGE),
    COMMENT_REMOVED(PermissionType.PAGE),
    COMMENT_UPDATED(PermissionType.PAGE),
    USER_CONTENT_IS_LIKED(PermissionType.PAGE),
    LABEL_ADDED(PermissionType.PAGE),
    LABEL_CREATED(PermissionType.PAGE),
    LABEL_DELETED(PermissionType.PAGE),
    LABEL_REMOVED(PermissionType.PAGE),
    LIKE_CREATED(PermissionType.PAGE),
    LIKE_REMOVED(PermissionType.PAGE),
    PAGE_INTERNAL_LINK_ADDED(PermissionType.PAGE),
    PAGE_CREATED(PermissionType.PAGE),
    PAGE_REMOVED(PermissionType.PAGE),
    PAGE_RESTORED(PermissionType.PAGE),
    PAGE_TRASHED(PermissionType.PAGE),
    PAGE_UPDATED(PermissionType.PAGE),
    PAGE_FOLLOWED(PermissionType.PAGE),
    SPACE_CREATED(PermissionType.SPACE),
    SPACE_REMOVED(PermissionType.SPACE),
    SPACE_UPDATED(PermissionType.SPACE),
    SPACE_FOLLOWED(PermissionType.SPACE),
    PERSONAL_SPACE_CREATED(PermissionType.SPACE),
    SEARCHED,
    USER_FOLLOWED,
    USER_BE_FOLLOWED,
    USER_PROFILE_UPDATED,
    USER_PROFILE_PICTURE_UPDATED,
    SCORE_LEADER_DAY_CHANGED,
    SCORE_LEADER_WEEK_CHANGED,
    SCORE_LEADER_MONTH_CHANGED,
    SCORE_LEADER_YEAR_CHANGED,
    SCORE_LEADER_OVERALL_CHANGED,
    ACHIEVEMENT_ADDED,
    DECREASE,
    LOGIN,
    LOGOUT;

    public static final String AWARDS_EVENT_PREFIX = "io.moewe.confluence.addons.awards.event.";
    private PermissionType permissionType = PermissionType.NONE;

    private AwardsEvent() {
    }

    private AwardsEvent(PermissionType permissionType) {
        this.permissionType = permissionType;
    }

    public PermissionType getPermissionType() {
        return this.permissionType;
    }

    public String getLabelI18nKey() {
        return AWARDS_EVENT_PREFIX + this.name() + ".label";
    }

    public String getDescriptionI18nKey() {
        return AWARDS_EVENT_PREFIX + this.name() + ".description";
    }

    public static enum PermissionType {
        SPACE,
        PAGE,
        NONE;

    }
}

