/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.atlassian.sdk.internal.service;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.moewe.atlassian.sdk.internal.license.MoeweLicenseService;
import io.moewe.atlassian.sdk.internal.service.MoeweMetadata;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
public class MoeweMetadataService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoeweLicenseService.class);
    public static final String MOEWE_METADATA_KEY = "moewemetadata";
    private final ContentPropertyService contentPropertyService;
    private final ContentService contentService;
    private final Cache<Long, MoeweMetadata> moeweMetadataCache;

    @Inject
    public MoeweMetadataService(@ComponentImport ContentPropertyService contentPropertyService, @ComponentImport @Qualifier(value="contentService") ContentService contentService, @ComponentImport CacheManager cacheManager) {
        this.contentService = contentService;
        CacheSettings cacheSettings = new CacheSettingsBuilder().expireAfterAccess(24L, TimeUnit.HOURS).local().build();
        this.contentPropertyService = contentPropertyService;
        this.moeweMetadataCache = cacheManager.getCache(MoeweMetadataService.class.getName() + ".cache", (CacheLoader)new MoeweMetadataCacheLoader(), cacheSettings);
    }

    public MoeweMetadata getContentMetadata(Content content) {
        return (MoeweMetadata)this.moeweMetadataCache.get((Object)content.getId().asLong());
    }

    private class MoeweMetadataCacheLoader
    implements CacheLoader<Long, MoeweMetadata> {
        private MoeweMetadataCacheLoader() {
        }

        @Nonnull
        public MoeweMetadata load(@Nonnull Long contentId) {
            JsonContentProperty contentProperty = (JsonContentProperty)MoeweMetadataService.this.contentPropertyService.find(new Expansion[0]).withContentId(ContentId.of((long)contentId)).withPropertyKey(MoeweMetadataService.MOEWE_METADATA_KEY).fetchOrNull();
            ObjectMapper mapper = new ObjectMapper();
            try {
                Content content;
                if (contentProperty != null) {
                    JsonString value = contentProperty.getValue();
                    try {
                        return (MoeweMetadata)mapper.readValue(value.getValue(), MoeweMetadata.class);
                    }
                    catch (Exception e) {
                        LOGGER.error("Json exception while processing content property \"moewemetadata\" ", (Throwable)e);
                    }
                }
                if ((content = (Content)MoeweMetadataService.this.contentService.find(new Expansion[0]).withId(ContentId.of((long)contentId)).fetchOrNull()) == null) {
                    return null;
                }
                MoeweMetadata moeweMetadata = new MoeweMetadata();
                moeweMetadata.setUuid(UUID.randomUUID().toString());
                contentProperty = JsonContentProperty.builder().content(content).key(MoeweMetadataService.MOEWE_METADATA_KEY).value(new JsonString(mapper.writeValueAsString((Object)moeweMetadata))).build();
                MoeweMetadataService.this.contentPropertyService.create(contentProperty);
                return moeweMetadata;
            }
            catch (Exception e) {
                LOGGER.error("Json exception while processing content property \"moewemetadata\" ", (Throwable)e);
                return null;
            }
        }
    }
}

