/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.atlassian.sdk.auiforms.rest.entities.filters;

import com.atlassian.sal.api.message.I18nResolver;
import io.moewe.atlassian.sdk.auiforms.annotation.SchemeConfig;
import io.moewe.atlassian.sdk.auiforms.rest.entities.FieldOptionScheme;
import io.moewe.atlassian.sdk.auiforms.rest.entities.FieldScheme;
import io.moewe.atlassian.sdk.auiforms.rest.entities.filters.FieldSchemeFilter;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class EnumFieldSchemeFilter
implements FieldSchemeFilter {
    @Override
    public void filter(FieldScheme fieldScheme, Field field, Object entity, I18nResolver i18nResolver, String i18nPrefix) {
        if (field.getType().isEnum()) {
            this.addEnumValues(fieldScheme, i18nResolver, i18nPrefix, (Enum[])field.getType().getEnumConstants());
            if (SchemeConfig.Variant.TEXT.name().toLowerCase().equals(fieldScheme.getVariant()) || SchemeConfig.Variant.TYPE.name().toLowerCase().equals(fieldScheme.getVariant())) {
                fieldScheme.setVariant(SchemeConfig.Variant.RADIO.name().toLowerCase());
            }
        } else if (field.getType().isArray() && field.getType().getComponentType().isEnum()) {
            this.addEnumValues(fieldScheme, i18nResolver, i18nPrefix, (Enum[])field.getType().getComponentType().getEnumConstants());
            fieldScheme.addFieldDataAttribute("multiple", "");
            if (SchemeConfig.Variant.TEXT.name().toLowerCase().equals(fieldScheme.getVariant()) || SchemeConfig.Variant.TYPE.name().toLowerCase().equals(fieldScheme.getVariant())) {
                fieldScheme.setVariant(SchemeConfig.Variant.CHECKBOX.name().toLowerCase());
            }
        }
    }

    private void addEnumValues(FieldScheme fieldScheme, I18nResolver i18nResolver, String i18nPrefix, Enum[] enumConstants) {
        ArrayList<FieldOptionScheme> options = new ArrayList<FieldOptionScheme>();
        for (Enum enumConstant : enumConstants) {
            FieldOptionScheme value = new FieldOptionScheme(i18nResolver.getText(i18nPrefix + ".fields." + fieldScheme.getName() + ".option." + enumConstant.name() + ".label"), enumConstant.name());
            options.add(value);
        }
        fieldScheme.addFieldParameters("options", options);
    }
}

