/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.atlassian.sdk.auiforms.rest.entities;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;

public abstract class Scheme
implements Serializable {
    public static final String PARAMETER_KEY_OPTIONS = "options";
    @XmlElement
    protected Type type;
    @XmlElement
    protected String name;
    @XmlElement
    protected String label;
    @XmlElement
    protected String description;
    @XmlElement
    protected int order = 100;
    @XmlElement
    protected boolean required = false;
    @XmlElement
    protected boolean readonly = false;
    @XmlElement
    protected String fieldCSSClasses = "";
    @XmlElement
    protected Map<String, String> fieldDataAttributes = new HashMap<String, String>();
    @XmlElement
    protected Map<String, Object> fieldParameters = new HashMap<String, Object>();

    public Scheme(Type type, String name, String label, String description) {
        this.type = type;
        this.name = name;
        this.label = label;
        this.description = description;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public String getFieldCSSClasses() {
        return this.fieldCSSClasses;
    }

    public void addFieldCSSClasses(String cssClass) {
        if (this.fieldCSSClasses == null) {
            this.fieldCSSClasses = "";
        }
        this.fieldCSSClasses = this.fieldCSSClasses + " " + cssClass;
    }

    public void setFieldCSSClasses(String fieldCSSClasses) {
        this.fieldCSSClasses = fieldCSSClasses;
    }

    public Map<String, String> getFieldDataAttributes() {
        return this.fieldDataAttributes;
    }

    public void addFieldDataAttribute(String key, String value) {
        if (value == null || value.equals("")) {
            return;
        }
        value = value.replace("\\", "\\\\");
        value = value.replace("\"", "\\\"");
        this.fieldDataAttributes.put(key, value);
    }

    public void setFieldDataAttributes(Map<String, String> fieldDataAttributes) {
        this.fieldDataAttributes = fieldDataAttributes;
    }

    public void addFieldParameters(String key, Object value) {
        if (value == null || value.equals("")) {
            return;
        }
        this.fieldParameters.put(key, value);
    }

    public void setFieldParameters(Map<String, Object> fieldParameters) {
        this.fieldParameters = fieldParameters;
    }

    public static enum Type {
        FIELD,
        ENTITY,
        REPEATABLE;

    }
}

