var KarmaRanking = {
     initialize: function() {
         jQuery(".karma-ranking-macro:not(.initialized)").each(function() {
             var self = jQuery(this);
             self.addClass("initialized");
             var form = self.find("form");
             loadRanking();
                          
             self.on( "click", ".karmapagerprevious, .karmapagernext", function(e) {
                 e.preventDefault();
                 loadRanking(jQuery(this).attr("pageindex"));
                 return false;
             });
             
             self.on( "click", ".karmarankingtimeframeselector", function(e) {
                 e.preventDefault();
                 self.find("form input[name=timeframe]").val(jQuery(this).attr("timeframe"));
                 jQuery(this).parent().find("span").attr("class","");
                 jQuery(this).find("span").attr("class", "aui-lozenge aui-lozenge-current");
                 loadRanking();
                 return false;
             });
             
             
             
             function loadRanking(index) {
                 var rankingResultContainer =  self.find(".karma-ranking-result");
                 rankingResultContainer.html('<div class="button-spinner"></div>');
                 if(self.find('.button-spinner').spin) {
                    self.find('.button-spinner').spin();
                 }

                 var actionUrl = form.attr("action");
                 if(index) {
                     actionUrl+="?pageindex="+index;
                 }
                 jQuery.post(actionUrl, form.serializeArray(), function(data) {
                     rankingResultContainer.html(data);
                     Confluence.Binder.userHover(); // user hover bindings
                     self.trigger("karma.ranking.refreshed")
                 });
             }
             
             
         });
     }   
};


