/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.util;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.HijrahDate;
import java.time.chrono.JapaneseDate;
import java.time.chrono.MinguoDate;
import java.time.chrono.ThaiBuddhistDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor8;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.lang.model.util.TypeKindVisitor8;
import javax.lang.model.util.Types;
import org.hibernate.validator.ap.internal.util.AnnotationApiHelper;
import org.hibernate.validator.ap.internal.util.CollectionHelper;

public class ConstraintHelper {
    private static final Class<?>[] JAVA_TIME_TYPES_SUPPORTED_BY_FUTURE_AND_PAST_ANNOTATIONS = new Class[]{HijrahDate.class, Instant.class, JapaneseDate.class, LocalDate.class, LocalDateTime.class, LocalTime.class, MinguoDate.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, ThaiBuddhistDate.class, Year.class, YearMonth.class, ZonedDateTime.class};
    private static final Class<?>[] TYPES_SUPPORTED_BY_SIZE_AND_NOT_EMPTY_ANNOTATIONS = new Class[]{Object[].class, boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class, Collection.class, Map.class, CharSequence.class};
    private final Map<Name, Set<TypeMirror>> supportedTypesByConstraint;
    private final Map<Name, AnnotationType> annotationTypeCache;
    private final Map<Name, TypeMirror> supportedTypesUnwrappedByDefault;
    private final Map<Name, Set<AnnotationMirror>> composingConstraintsByConstraints;
    private final Types typeUtils;
    private final AnnotationApiHelper annotationApiHelper;

    public ConstraintHelper(Types typeUtils, AnnotationApiHelper annotationApiHelper) {
        this.typeUtils = typeUtils;
        this.annotationApiHelper = annotationApiHelper;
        this.annotationTypeCache = CollectionHelper.newHashMap();
        this.supportedTypesByConstraint = CollectionHelper.newHashMap();
        this.composingConstraintsByConstraints = CollectionHelper.newHashMap();
        this.supportedTypesUnwrappedByDefault = CollectionHelper.newHashMap();
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.AssertFalse", Boolean.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.AssertTrue", Boolean.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.DecimalMax", Number.class, String.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.DecimalMax", "javax.money.MonetaryAmount");
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.DecimalMin", Number.class, String.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.DecimalMin", "javax.money.MonetaryAmount");
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Digits", Number.class, String.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Digits", "javax.money.MonetaryAmount");
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Email", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Future", Calendar.class, Date.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Future", "org.joda.time.ReadablePartial", "org.joda.time.ReadableInstant");
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Future", JAVA_TIME_TYPES_SUPPORTED_BY_FUTURE_AND_PAST_ANNOTATIONS);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.FutureOrPresent", Calendar.class, Date.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.FutureOrPresent", "org.joda.time.ReadablePartial", "org.joda.time.ReadableInstant");
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.FutureOrPresent", JAVA_TIME_TYPES_SUPPORTED_BY_FUTURE_AND_PAST_ANNOTATIONS);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Max", Number.class, String.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Max", "javax.money.MonetaryAmount");
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Min", Number.class, String.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Min", "javax.money.MonetaryAmount");
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Negative", Number.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Negative", "javax.money.MonetaryAmount");
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.NegativeOrZero", Number.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.NegativeOrZero", "javax.money.MonetaryAmount");
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.NotBlank", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.NotEmpty", TYPES_SUPPORTED_BY_SIZE_AND_NOT_EMPTY_ANNOTATIONS);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.NotNull", Object.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Null", Object.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Past", Calendar.class, Date.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Past", "org.joda.time.ReadablePartial", "org.joda.time.ReadableInstant");
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Past", JAVA_TIME_TYPES_SUPPORTED_BY_FUTURE_AND_PAST_ANNOTATIONS);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.PastOrPresent", Calendar.class, Date.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.PastOrPresent", "org.joda.time.ReadablePartial", "org.joda.time.ReadableInstant");
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.PastOrPresent", JAVA_TIME_TYPES_SUPPORTED_BY_FUTURE_AND_PAST_ANNOTATIONS);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Pattern", String.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Positive", Number.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Positive", "javax.money.MonetaryAmount");
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.PositiveOrZero", Number.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.PositiveOrZero", "javax.money.MonetaryAmount");
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Size", TYPES_SUPPORTED_BY_SIZE_AND_NOT_EMPTY_ANNOTATIONS);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.CodePointLength", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.Currency", "javax.money.MonetaryAmount");
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.time.DurationMax", Duration.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.time.DurationMin", Duration.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.Email", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.ISBN", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.Length", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.ModCheck", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.LuhnCheck", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.Mod10Check", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.Mod11Check", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.pl.REGON", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.pl.NIP", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.pl.PESEL", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.ru.INN", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.NotBlank", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.NotEmpty", TYPES_SUPPORTED_BY_SIZE_AND_NOT_EMPTY_ANNOTATIONS);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.Normalized", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.ScriptAssert", Object.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.UniqueElements", Collection.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.URL", CharSequence.class);
        this.registerSupportedTypesUnwrappedByDefault("java.util.OptionalInt", Integer.class.getName());
        this.registerSupportedTypesUnwrappedByDefault("java.util.OptionalLong", Long.class.getName());
        this.registerSupportedTypesUnwrappedByDefault("java.util.OptionalDouble", Double.class.getName());
    }

    public boolean isConstraintAnnotation(Element element) {
        return this.annotationApiHelper.getMirror(element.getAnnotationMirrors(), "javax.validation.Constraint") != null;
    }

    public AnnotationType getAnnotationType(AnnotationMirror annotationMirror) {
        Name key = this.getName(annotationMirror.getAnnotationType());
        AnnotationType annotationType = this.annotationTypeCache.get(key);
        if (annotationType != null) {
            return annotationType;
        }
        annotationType = this.isConstraintAnnotation(annotationMirror) ? AnnotationType.CONSTRAINT_ANNOTATION : (this.isMultiValuedConstraint(annotationMirror) ? AnnotationType.MULTI_VALUED_CONSTRAINT_ANNOTATION : (this.isGraphValidationAnnotation(annotationMirror) ? AnnotationType.GRAPH_VALIDATION_ANNOTATION : (this.isConstraintMetaAnnotation(annotationMirror) ? AnnotationType.CONSTRAINT_META_ANNOTATION : (this.isGroupSequenceAnnotation(annotationMirror) ? AnnotationType.GROUP_SEQUENCE_ANNOTATION : (this.isGroupSequenceProviderAnnotation(annotationMirror) ? AnnotationType.GROUP_SEQUENCE_PROVIDER_ANNOTATION : AnnotationType.NO_CONSTRAINT_ANNOTATION)))));
        this.annotationTypeCache.put(key, annotationType);
        return annotationType;
    }

    public List<AnnotationMirror> getPartsOfMultiValuedConstraint(AnnotationMirror annotationMirror) {
        final ArrayList<AnnotationMirror> theValue = CollectionHelper.newArrayList();
        for (AnnotationValue annotationValue : this.annotationApiHelper.getAnnotationArrayValue(annotationMirror, "value")) {
            annotationValue.accept(new SimpleAnnotationValueVisitor8<Void, Void>(){

                @Override
                public Void visitAnnotation(AnnotationMirror a, Void p) {
                    if (ConstraintHelper.this.isConstraintAnnotation(a.getAnnotationType().asElement())) {
                        theValue.add(a);
                    }
                    return null;
                }
            }, null);
        }
        return theValue;
    }

    public ConstraintCheckResult checkConstraint(DeclaredType constraintAnnotationType, TypeMirror typeOfAnnotatedElement) {
        ConstraintCheckResult composingConstraintsCheck = this.checkComposingConstraints(constraintAnnotationType, typeOfAnnotatedElement);
        if (composingConstraintsCheck != ConstraintCheckResult.ALLOWED) {
            return composingConstraintsCheck;
        }
        return this.checkSupportedTypes(constraintAnnotationType, typeOfAnnotatedElement);
    }

    public boolean isComposedConstraint(TypeElement element) {
        return Boolean.TRUE.equals(element.asType().accept(new TypeKindVisitor8<Boolean, Void>(){

            @Override
            public Boolean visitDeclared(DeclaredType constraintValidatorImplementation, Void p) {
                return !ConstraintHelper.this.getComposingConstraints(constraintValidatorImplementation).isEmpty();
            }
        }, null));
    }

    public AnnotationProcessorValidationTarget resolveValidationTarget(ExecutableElement element, AnnotationMirror annotation) {
        Set<AnnotationProcessorValidationTarget> allowedTargets = this.getSupportedValidationTargets(annotation.getAnnotationType());
        if (allowedTargets.size() == 1) {
            return allowedTargets.toArray(new AnnotationProcessorValidationTarget[1])[0];
        }
        AnnotationProcessorConstraintTarget constrTarget = this.getConstraintTarget(annotation);
        if (constrTarget == null) {
            return null;
        }
        switch (constrTarget) {
            case PARAMETERS: {
                return AnnotationProcessorValidationTarget.PARAMETERS;
            }
            case RETURN_VALUE: {
                return AnnotationProcessorValidationTarget.ANNOTATED_ELEMENT;
            }
        }
        return this.resolveImplicitValidationTarget(element);
    }

    public Set<AnnotationProcessorValidationTarget> getSupportedValidationTargets(DeclaredType constraintAnnotationType) {
        AnnotationMirror constraintMetaAnnotation = this.getConstraintMetaAnnotation(constraintAnnotationType);
        List<? extends AnnotationValue> validatorClassReferences = this.getValidatorClassesFromConstraintMetaAnnotation(constraintMetaAnnotation);
        EnumSet<AnnotationProcessorValidationTarget> supported = EnumSet.noneOf(AnnotationProcessorValidationTarget.class);
        for (AnnotationValue annotationValue : validatorClassReferences) {
            supported.addAll(this.getSupportedValidationTargets(annotationValue));
        }
        if (supported.isEmpty()) {
            supported.add(AnnotationProcessorValidationTarget.ANNOTATED_ELEMENT);
        }
        return supported;
    }

    public ConstraintCheckResult checkCrossParameterTypes(DeclaredType constraintAnnotationType) {
        AnnotationMirror constraintMetaAnnotation = this.getConstraintMetaAnnotation(constraintAnnotationType);
        List<? extends AnnotationValue> validatorClassReferences = this.getValidatorClassesFromConstraintMetaAnnotation(constraintMetaAnnotation);
        AnnotationValue crossParameterValidator = null;
        for (AnnotationValue annotationValue : validatorClassReferences) {
            Set<AnnotationProcessorValidationTarget> targets = this.getSupportedValidationTargets(annotationValue);
            if (!targets.contains((Object)AnnotationProcessorValidationTarget.PARAMETERS)) continue;
            if (crossParameterValidator != null) {
                return ConstraintCheckResult.MULTIPLE_VALIDATORS_FOUND;
            }
            crossParameterValidator = annotationValue;
        }
        if (crossParameterValidator != null) {
            final TypeMirror objectMirror = this.annotationApiHelper.getMirrorForType(Object.class);
            TypeMirror typeMirror = this.determineSupportedType(crossParameterValidator);
            Boolean supported = typeMirror.accept(new TypeKindVisitor8<Boolean, Void>(){

                @Override
                public Boolean visitArray(ArrayType t, Void p) {
                    return ConstraintHelper.this.typeUtils.isSameType(t.getComponentType(), objectMirror);
                }

                @Override
                public Boolean visitDeclared(DeclaredType t, Void p) {
                    return ConstraintHelper.this.typeUtils.isSameType(t, objectMirror);
                }
            }, null);
            if (!supported.booleanValue()) {
                return ConstraintCheckResult.DISALLOWED;
            }
        }
        return ConstraintCheckResult.ALLOWED;
    }

    public Types getTypeUtils() {
        return this.typeUtils;
    }

    public boolean isSupportedForUnwrappingByDefault(Name typeName) {
        return this.supportedTypesUnwrappedByDefault.containsKey(typeName);
    }

    public Optional<TypeMirror> getUnwrappedToByDefault(Name typeName) {
        return Optional.ofNullable(this.supportedTypesUnwrappedByDefault.get(typeName));
    }

    private boolean isConstraintAnnotation(AnnotationMirror annotationMirror) {
        return this.isConstraintAnnotation(annotationMirror.getAnnotationType().asElement());
    }

    private boolean isConstraintMetaAnnotation(AnnotationMirror annotationMirror) {
        return this.getName(annotationMirror.getAnnotationType()).contentEquals("javax.validation.Constraint");
    }

    private boolean isMultiValuedConstraint(AnnotationMirror annotationMirror) {
        List<? extends AnnotationValue> annotationArrayValue = this.annotationApiHelper.getAnnotationArrayValue(annotationMirror, "value");
        if (annotationArrayValue.isEmpty()) {
            return false;
        }
        for (AnnotationValue annotationValue : annotationArrayValue) {
            Boolean isConstraintAnnotation = annotationValue.accept(new SimpleAnnotationValueVisitor8<Boolean, Void>(){

                @Override
                public Boolean visitAnnotation(AnnotationMirror a, Void p) {
                    return ConstraintHelper.this.isConstraintAnnotation(a.getAnnotationType().asElement());
                }
            }, null);
            if (Boolean.TRUE == isConstraintAnnotation) continue;
            return false;
        }
        return true;
    }

    private boolean isGraphValidationAnnotation(AnnotationMirror annotationMirror) {
        return this.getName(annotationMirror.getAnnotationType()).contentEquals("javax.validation.Valid");
    }

    private boolean isGroupSequenceAnnotation(AnnotationMirror annotationMirror) {
        return this.getName(annotationMirror.getAnnotationType()).contentEquals("javax.validation.GroupSequence");
    }

    private boolean isGroupSequenceProviderAnnotation(AnnotationMirror annotationMirror) {
        return this.getName(annotationMirror.getAnnotationType()).contentEquals("org.hibernate.validator.group.GroupSequenceProvider");
    }

    private ConstraintCheckResult checkComposingConstraints(DeclaredType constraintAnnotationType, TypeMirror typeOfAnnotatedElement) {
        for (AnnotationMirror oneComposingConstraint : this.getComposingConstraints(constraintAnnotationType)) {
            ConstraintCheckResult annotationCheckResult = this.checkConstraint(oneComposingConstraint.getAnnotationType(), typeOfAnnotatedElement);
            if (annotationCheckResult == ConstraintCheckResult.ALLOWED) continue;
            return annotationCheckResult;
        }
        return ConstraintCheckResult.ALLOWED;
    }

    private ConstraintCheckResult checkSupportedTypes(DeclaredType constraintAnnotationType, TypeMirror typeOfAnnotatedElement) {
        Set<TypeMirror> supportedTypes = this.getSupportedTypes(constraintAnnotationType);
        Set<TypeMirror> assignableTypes = this.getAssignableTypes(supportedTypes, typeOfAnnotatedElement);
        if (assignableTypes.size() > 1) {
            return ConstraintCheckResult.MULTIPLE_VALIDATORS_FOUND;
        }
        if (assignableTypes.size() == 1 || supportedTypes.size() == 0 && !this.getComposingConstraints(constraintAnnotationType).isEmpty()) {
            return ConstraintCheckResult.ALLOWED;
        }
        return ConstraintCheckResult.DISALLOWED;
    }

    private Set<TypeMirror> getSupportedTypes(DeclaredType constraintAnnotationType) {
        Name key = this.getName(constraintAnnotationType);
        Set<TypeMirror> supportedTypes = this.supportedTypesByConstraint.get(key);
        if (supportedTypes == null) {
            supportedTypes = this.determineSupportedTypes(constraintAnnotationType);
            this.supportedTypesByConstraint.put(key, supportedTypes);
        }
        return supportedTypes;
    }

    private AnnotationProcessorValidationTarget resolveImplicitValidationTarget(ExecutableElement e) {
        if (e.getParameters().isEmpty()) {
            return AnnotationProcessorValidationTarget.ANNOTATED_ELEMENT;
        }
        if (e.getReturnType().getKind() == TypeKind.VOID) {
            return AnnotationProcessorValidationTarget.PARAMETERS;
        }
        return null;
    }

    private AnnotationProcessorConstraintTarget getConstraintTarget(AnnotationMirror annotation) {
        AnnotationValue validationAppliesTo = this.annotationApiHelper.getAnnotationValue(annotation, "validationAppliesTo");
        if (validationAppliesTo == null) {
            for (Element element : annotation.getAnnotationType().asElement().getEnclosedElements()) {
                Boolean isValidationAppliesToMethod = element.accept(new ElementKindVisitor8<Boolean, Void>(){

                    @Override
                    public Boolean visitExecutableAsMethod(ExecutableElement e, Void p) {
                        if (e.getSimpleName().contentEquals("validationAppliesTo")) {
                            return true;
                        }
                        return false;
                    }
                }, null);
                if (!Boolean.TRUE.equals(isValidationAppliesToMethod)) continue;
                return AnnotationProcessorConstraintTarget.IMPLICIT;
            }
            return null;
        }
        return validationAppliesTo.accept(new SimpleAnnotationValueVisitor8<AnnotationProcessorConstraintTarget, Void>(){
            private final TypeMirror constraintTargetMirror;
            {
                this.constraintTargetMirror = ConstraintHelper.this.annotationApiHelper.getDeclaredTypeByName("javax.validation.ConstraintTarget");
            }

            @Override
            public AnnotationProcessorConstraintTarget visitEnumConstant(VariableElement c, Void p) {
                if (ConstraintHelper.this.typeUtils.isSameType(c.asType(), this.constraintTargetMirror)) {
                    return AnnotationProcessorConstraintTarget.valueOf(c.getSimpleName().toString());
                }
                return null;
            }
        }, null);
    }

    private Set<TypeMirror> determineSupportedTypes(DeclaredType constraintAnnotationType) {
        return this.determineSupportedTypes(constraintAnnotationType, AnnotationProcessorValidationTarget.ANNOTATED_ELEMENT);
    }

    private Set<TypeMirror> determineSupportedTypes(DeclaredType constraintAnnotationType, AnnotationProcessorValidationTarget target) {
        AnnotationMirror constraintMetaAnnotation = this.getConstraintMetaAnnotation(constraintAnnotationType);
        List<? extends AnnotationValue> validatorClassReferences = this.getValidatorClassesFromConstraintMetaAnnotation(constraintMetaAnnotation);
        HashSet<TypeMirror> supportedTypes = CollectionHelper.newHashSet();
        for (AnnotationValue annotationValue : validatorClassReferences) {
            if (!this.isValidationTargetSupported(annotationValue, target)) continue;
            TypeMirror supportedType = this.determineSupportedType(annotationValue);
            supportedTypes.add(supportedType);
        }
        return supportedTypes;
    }

    private TypeMirror determineSupportedType(AnnotationValue validatorClassReference) {
        TypeMirror constraintValidatorImplementation = this.getConstraintValidatorSuperType(validatorClassReference);
        return constraintValidatorImplementation.accept(new TypeKindVisitor8<TypeMirror, Void>(){

            @Override
            public TypeMirror visitDeclared(DeclaredType constraintValidatorImplementation, Void p) {
                return constraintValidatorImplementation.getTypeArguments().get(1);
            }
        }, null);
    }

    private boolean isValidationTargetSupported(AnnotationValue oneValidatorClassReference, AnnotationProcessorValidationTarget target) {
        return this.getSupportedValidationTargets(oneValidatorClassReference).contains((Object)target);
    }

    private Set<AnnotationProcessorValidationTarget> getSupportedValidationTargets(AnnotationValue oneValidatorClassReference) {
        TypeMirror validatorClass = oneValidatorClassReference.accept(new SimpleAnnotationValueVisitor8<TypeMirror, Void>(){

            @Override
            public TypeMirror visitType(TypeMirror t, Void p) {
                return t;
            }
        }, null);
        DeclaredType validatorType = validatorClass.accept(new TypeKindVisitor8<DeclaredType, Void>(){

            @Override
            public DeclaredType visitDeclared(DeclaredType t, Void p) {
                return t;
            }
        }, null);
        DeclaredType supportedValidationTargetType = this.annotationApiHelper.getDeclaredTypeByName("javax.validation.constraintvalidation.SupportedValidationTarget");
        AnnotationMirror supportedTargetDecl = null;
        for (AnnotationMirror annotationMirror : validatorType.asElement().getAnnotationMirrors()) {
            if (!this.typeUtils.isSameType(annotationMirror.getAnnotationType(), supportedValidationTargetType)) continue;
            supportedTargetDecl = annotationMirror;
            break;
        }
        EnumSet<AnnotationProcessorValidationTarget> allowedTargets = EnumSet.noneOf(AnnotationProcessorValidationTarget.class);
        if (supportedTargetDecl == null) {
            allowedTargets.add(AnnotationProcessorValidationTarget.ANNOTATED_ELEMENT);
        } else {
            List<? extends AnnotationValue> list = this.annotationApiHelper.getAnnotationArrayValue(supportedTargetDecl, "value");
            for (AnnotationValue annotationValue : list) {
                AnnotationProcessorValidationTarget target = annotationValue.accept(new SimpleAnnotationValueVisitor8<AnnotationProcessorValidationTarget, Void>(){

                    @Override
                    public AnnotationProcessorValidationTarget visitEnumConstant(VariableElement c, Void p) {
                        return AnnotationProcessorValidationTarget.valueOf(c.getSimpleName().toString());
                    }
                }, null);
                allowedTargets.add(target);
            }
        }
        return allowedTargets;
    }

    private TypeMirror getConstraintValidatorSuperType(AnnotationValue oneValidatorClassReference) {
        TypeMirror type = oneValidatorClassReference.accept(new SimpleAnnotationValueVisitor8<TypeMirror, Void>(){

            @Override
            public TypeMirror visitType(TypeMirror t, Void p) {
                return t;
            }
        }, null);
        List<? extends TypeMirror> superTypes = this.typeUtils.directSupertypes(type);
        ArrayList nextSuperTypes = CollectionHelper.newArrayList();
        while (!superTypes.isEmpty()) {
            for (TypeMirror typeMirror : superTypes) {
                if (this.getName(this.typeUtils.asElement(typeMirror)).contentEquals("javax.validation.ConstraintValidator")) {
                    return typeMirror;
                }
                nextSuperTypes.addAll(this.typeUtils.directSupertypes(typeMirror));
            }
            superTypes = nextSuperTypes;
            nextSuperTypes = CollectionHelper.newArrayList();
        }
        throw new IllegalStateException("Expected type " + type + " to implement javax.validation.ConstraintValidator, but it doesn't.");
    }

    private AnnotationMirror getConstraintMetaAnnotation(DeclaredType annotationType) {
        List<? extends AnnotationMirror> annotationMirrors = annotationType.asElement().getAnnotationMirrors();
        AnnotationMirror constraintMetaAnnotation = this.annotationApiHelper.getMirror(annotationMirrors, "javax.validation.Constraint");
        if (constraintMetaAnnotation == null) {
            throw new IllegalArgumentException("Given type " + annotationType + " isn't a constraint annotation type.");
        }
        return constraintMetaAnnotation;
    }

    private List<? extends AnnotationValue> getValidatorClassesFromConstraintMetaAnnotation(AnnotationMirror constraintMetaAnnotation) {
        AnnotationValue validatedBy = this.annotationApiHelper.getAnnotationValue(constraintMetaAnnotation, "validatedBy");
        return validatedBy.accept(new SimpleAnnotationValueVisitor8<List<? extends AnnotationValue>, Void>(){

            @Override
            public List<? extends AnnotationValue> visitArray(List<? extends AnnotationValue> values, Void p) {
                return values;
            }
        }, null);
    }

    private Set<TypeMirror> getAssignableTypes(Set<TypeMirror> types, TypeMirror type) {
        HashSet<TypeMirror> theValue = CollectionHelper.newHashSet();
        for (TypeMirror supportedType : types) {
            if (!this.typeUtils.isAssignable(type, supportedType)) continue;
            theValue.add(supportedType);
        }
        return this.annotationApiHelper.keepLowestTypePerHierarchy(theValue);
    }

    private void registerAllowedTypesForBuiltInConstraint(String annotationType, Class<?> ... types) {
        this.registerAllowedTypesForBuiltInConstraint(annotationType, this.asMirrors(types));
    }

    private void registerAllowedTypesForBuiltInConstraint(String annotationType, String ... typeNames) {
        this.registerAllowedTypesForBuiltInConstraint(annotationType, this.asMirrors(typeNames));
    }

    private void registerAllowedTypesForBuiltInConstraint(String annotationType, List<TypeMirror> supportedTypes) {
        DeclaredType annotation = this.annotationApiHelper.getDeclaredTypeByName(annotationType);
        if (annotation == null) {
            return;
        }
        Name key = this.getName(annotation);
        Set<TypeMirror> types = this.supportedTypesByConstraint.get(key);
        if (types == null) {
            this.supportedTypesByConstraint.put(key, new HashSet<TypeMirror>(supportedTypes));
        } else {
            types.addAll(supportedTypes);
        }
    }

    private void registerSupportedTypesUnwrappedByDefault(String typeName, String unwrappedToTypeName) {
        DeclaredType typeToUnwrap = this.annotationApiHelper.getDeclaredTypeByName(typeName);
        if (typeToUnwrap == null) {
            return;
        }
        this.supportedTypesUnwrappedByDefault.put(this.getName(typeToUnwrap), this.annotationApiHelper.getDeclaredTypeByName(unwrappedToTypeName));
    }

    private Name getName(DeclaredType type) {
        return this.getName(type.asElement());
    }

    private Name getName(Element element) {
        if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ANNOTATION_TYPE) {
            return ((TypeElement)element).getQualifiedName();
        }
        return element.getSimpleName();
    }

    private Set<AnnotationMirror> getComposingConstraints(DeclaredType constraintAnnotationType) {
        Name key = this.getName(constraintAnnotationType);
        Set<AnnotationMirror> composingConstraints = this.composingConstraintsByConstraints.get(key);
        if (composingConstraints != null) {
            return composingConstraints;
        }
        composingConstraints = CollectionHelper.newHashSet();
        List<? extends AnnotationMirror> annotationMirrors = constraintAnnotationType.asElement().getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            AnnotationType annotationType = this.getAnnotationType(annotationMirror);
            if (annotationType == AnnotationType.CONSTRAINT_ANNOTATION) {
                composingConstraints.add(annotationMirror);
                continue;
            }
            if (annotationType != AnnotationType.MULTI_VALUED_CONSTRAINT_ANNOTATION) continue;
            List<? extends AnnotationValue> value = this.annotationApiHelper.getAnnotationArrayValue(annotationMirror, "value");
            for (AnnotationValue annotationValue : value) {
                composingConstraints.add((AnnotationMirror)((Object)annotationValue));
            }
        }
        this.composingConstraintsByConstraints.put(key, composingConstraints);
        return composingConstraints;
    }

    private List<TypeMirror> asMirrors(Class<?> ... types) {
        ArrayList<TypeMirror> mirrors = new ArrayList<TypeMirror>(types.length);
        for (Class<?> oneType : types) {
            TypeMirror oneMirror = this.annotationApiHelper.getMirrorForType(oneType);
            if (oneMirror == null) continue;
            mirrors.add(oneMirror);
        }
        return mirrors;
    }

    private List<TypeMirror> asMirrors(String ... typeNames) {
        ArrayList<TypeMirror> mirrors = new ArrayList<TypeMirror>(typeNames.length);
        for (String oneTypeName : typeNames) {
            DeclaredType oneMirror = this.annotationApiHelper.getDeclaredTypeByName(oneTypeName);
            if (oneMirror == null) continue;
            mirrors.add(oneMirror);
        }
        return mirrors;
    }

    public static enum AnnotationType {
        CONSTRAINT_ANNOTATION,
        MULTI_VALUED_CONSTRAINT_ANNOTATION,
        GRAPH_VALIDATION_ANNOTATION,
        CONSTRAINT_META_ANNOTATION,
        GROUP_SEQUENCE_ANNOTATION,
        GROUP_SEQUENCE_PROVIDER_ANNOTATION,
        NO_CONSTRAINT_ANNOTATION;

    }

    public static enum ConstraintCheckResult {
        ALLOWED,
        DISALLOWED,
        MULTIPLE_VALIDATORS_FOUND;

    }

    public static enum AnnotationProcessorValidationTarget {
        PARAMETERS,
        ANNOTATED_ELEMENT;

    }

    public static enum AnnotationProcessorConstraintTarget {
        PARAMETERS,
        RETURN_VALUE,
        IMPLICIT;

    }
}

