/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.checks;

import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;
import org.hibernate.validator.ap.internal.checks.AbstractConstraintCheck;
import org.hibernate.validator.ap.internal.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.internal.util.CollectionHelper;
import org.hibernate.validator.ap.internal.util.ConstraintHelper;

public class MixDirectAndListAnnotationCheck
extends AbstractConstraintCheck {
    private final ConstraintHelper constraintHelper;

    public MixDirectAndListAnnotationCheck(ConstraintHelper constraintHelper) {
        this.constraintHelper = constraintHelper;
    }

    @Override
    public Set<ConstraintCheckIssue> checkAnnotationType(TypeElement element, AnnotationMirror annotation) {
        if (this.constraintHelper.isComposedConstraint(element) && this.containsDirectAnnotation(element, annotation)) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(element, annotation, "MIXED_LIST_AND_DIRECT_ANNOTATION_DECLARATION", this.getAnnotationQualifiedName(annotation)));
        }
        return Collections.emptySet();
    }

    private boolean containsDirectAnnotation(TypeElement element, AnnotationMirror elementOfMultiValuedAnnotation) {
        Types typeUtils = this.constraintHelper.getTypeUtils();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!typeUtils.isSameType(annotationMirror.getAnnotationType(), elementOfMultiValuedAnnotation.getAnnotationType())) continue;
            return true;
        }
        return false;
    }

    private Name getAnnotationQualifiedName(AnnotationMirror annotationMirror) {
        return ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
    }
}

