/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.servlet;

import com.atlassian.confluence.themes.GlobalHelper;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import io.moewe.atlassian.sdk.auiforms.FormService;
import io.moewe.atlassian.sdk.internal.license.MoeweLicenseService;
import io.moewe.confluence.addons.awards.AchievementType;
import io.moewe.confluence.addons.awards.AwardsEvent;
import io.moewe.confluence.addons.awards.KarmaUserProfile;
import io.moewe.confluence.addons.awards.forms.GeneralConfiguration;
import io.moewe.confluence.addons.awards.rest.pojo.Processor;
import io.moewe.confluence.addons.awards.rest.pojo.input.AwardsEventInput;
import io.moewe.confluence.addons.awards.rest.pojo.input.Input;
import io.moewe.confluence.addons.awards.rest.pojo.output.Output;
import io.moewe.confluence.addons.awards.rest.pojo.output.PointOutput;
import io.moewe.confluence.addons.awards.services.AchievementService;
import io.moewe.confluence.addons.awards.services.BadgeManager;
import io.moewe.confluence.addons.awards.services.KarmaEventManager;
import io.moewe.confluence.addons.awards.services.KarmaHistoryManager;
import io.moewe.confluence.addons.awards.services.KarmaPropertyManager;
import io.moewe.confluence.addons.awards.services.KarmaScoreManager;
import io.moewe.confluence.addons.awards.services.KarmaUserManager;
import io.moewe.confluence.addons.awards.services.MedalManager;
import io.moewe.confluence.addons.awards.services.ProcessorService;
import io.moewe.confluence.addons.awards.services.UserAwardsService;
import io.moewe.confluence.addons.awards.servlet.AwardsServlet;
import io.moewe.confluence.addons.awards.util.AwardsApplicationManager;
import io.moewe.confluence.addons.awards.util.AwardsHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AwardsOverviewServlet
extends AwardsServlet {
    public static final int KARMAHISTORY_ELEMENTCOUNT = 20;
    private static final long serialVersionUID = 2848344320853727153L;
    private final AwardsApplicationManager applicationManager;
    private final AchievementService achievementService;
    private final ProcessorService processorService;

    public AwardsOverviewServlet(@ComponentImport TemplateRenderer templateRenderer, @ComponentImport PageBuilderService pageBuilderService, @ComponentImport I18nResolver i18nResolver, KarmaEventManager karmaEventManager, @ComponentImport UserManager userManager, BadgeManager badgeManager, MedalManager medalManager, KarmaUserManager karmaUserManager, KarmaPropertyManager karmaPropertyManager, KarmaHistoryManager karmaHistoryManager, KarmaScoreManager karmaScoreManager, @ComponentImport PluginAccessor pluginAccessor, UserAwardsService userAwardsService, MoeweLicenseService licenseService, FormService formService, AwardsApplicationManager applicationManager, AchievementService achievementService, ProcessorService processorService) {
        super(templateRenderer, pageBuilderService, i18nResolver, karmaEventManager, userManager, badgeManager, medalManager, karmaUserManager, karmaPropertyManager, karmaHistoryManager, karmaScoreManager, pluginAccessor, userAwardsService, licenseService, formService);
        this.applicationManager = applicationManager;
        this.achievementService = achievementService;
        this.processorService = processorService;
    }

    public void show(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("title", this.i18nResolver.getText("communardo.culegendLabelte.admin.item.project.configuration.title"));
        String username = request.getParameter("username");
        UserProfile confluenceUserFromUsername = this.userManager.getUserProfile(username);
        GeneralConfiguration generalConfiguration = this.getGeneralConfiguration();
        UserProfile remoteUser = this.userManager.getRemoteUser();
        if (remoteUser == null || remoteUser.getUsername() == null || remoteUser.getUsername().isBlank() || confluenceUserFromUsername == null || generalConfiguration.isHideOverview()) {
            this.renderVelocity(request, response, "vm/karmaoverview.empty.vm", velocityContext);
            return;
        }
        String remoteUsername = remoteUser.getUsername();
        KarmaUserProfile karmaUserFromUsername = this.karmaUserManager.getKarmaUserFromUsername(username);
        velocityContext.put("isAdmin", this.userManager.isAdmin(remoteUser.getUserKey()));
        velocityContext.put("confluenceUserFromUsername", confluenceUserFromUsername);
        if (karmaUserFromUsername != null) {
            velocityContext.put("loggedInKarmaUser", this.karmaUserManager.getKarmaUserFromUsername(remoteUsername));
            velocityContext.put("selectedKarmaUser", karmaUserFromUsername);
            velocityContext.put("karmaUser", this.userAwardsService.getUser(karmaUserFromUsername.getKarmaUserDao()));
            velocityContext.put("lastKarmaEntries", this.karmaEventManager.getLastKarmaEntries(karmaUserFromUsername, 20));
            velocityContext.put("userBadgeEntries", this.badgeManager.getUserBadges(karmaUserFromUsername));
            velocityContext.put("userMedalGroups", this.medalManager.getGroupedUserMedals(karmaUserFromUsername));
        }
        boolean isAllParticipation = generalConfiguration.getParticipation().equals((Object)GeneralConfiguration.Participation.ALL);
        velocityContext.put("isAllParticipation", isAllParticipation);
        velocityContext.put("unit", generalConfiguration.getUnit());
        velocityContext.put("isCustomConfiguration", !isAllParticipation || generalConfiguration.getNotificationMailRecipient().equals((Object)GeneralConfiguration.NotificationMailRecipient.CUSTOM));
        velocityContext.put("medalAchievements", this.achievementService.getActiveAchievements(AchievementType.MEDAL));
        velocityContext.put("badgeAchievements", this.achievementService.getActiveAchievements(AchievementType.BADGE));
        velocityContext.put("pointOutputEvents", this.getPointOutputEvents());
        velocityContext.put("dateFormatter", this.applicationManager.getDateFormatter());
        velocityContext.put("karmaHelper", new AwardsHelper());
        velocityContext.put("karmaEventManager", this.karmaEventManager);
        velocityContext.put("karmaUserManager", this.karmaUserManager);
        velocityContext.put("userManager", this.userManager);
        velocityContext.put("karmaApplicationManager", this.applicationManager);
        velocityContext.put("moeweLicenseService", this.licenseService);
        velocityContext.put("badgeManager", this.badgeManager);
        velocityContext.put("globalHelper", new GlobalHelper());
        this.pageBuilderService.assembler().resources().requireContext("karma.overview");
        this.renderVelocity(request, response, "vm/karmaoverview.vm", velocityContext);
    }

    private Map<List<PointOutput>, List<AwardsEvent[]>> getPointOutputEvents() {
        LinkedHashMap<List<PointOutput>, List<AwardsEvent[]>> pointOutputEvents = new LinkedHashMap<List<PointOutput>, List<AwardsEvent[]>>();
        List<Processor> processors = this.processorService.getActiveProcessor();
        processors.forEach(processor -> {
            if (processor.getMetaData() != null) {
                List<Output> outputs = processor.getMetaData().getOutputs();
                ArrayList pointOutputs = new ArrayList();
                outputs.forEach(output -> {
                    if (output instanceof PointOutput) {
                        pointOutputs.add((PointOutput)output);
                    }
                });
                if (!pointOutputs.isEmpty()) {
                    List<Input> inputs = processor.getMetaData().getInputs();
                    ArrayList awardsEvents = new ArrayList();
                    inputs.forEach(input -> {
                        if (input instanceof AwardsEventInput) {
                            AwardsEventInput awardsEventInput = (AwardsEventInput)input;
                            awardsEvents.add(awardsEventInput.getEvents());
                        }
                    });
                    if (!awardsEvents.isEmpty()) {
                        pointOutputEvents.put(pointOutputs, awardsEvents);
                    }
                }
            }
        });
        return pointOutputEvents;
    }

    public void loadkarmauserconfiguration(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String remoteUsername = this.userManager.getRemoteUser().getUsername();
        String user = request.getParameter("username");
        if (remoteUsername != null && remoteUsername.equalsIgnoreCase(user)) {
            HashMap<String, Object> velocityContext = new HashMap<String, Object>();
            velocityContext.put("user", this.karmaUserManager.getKarmaUserFromUsername(remoteUsername));
            velocityContext.put("currentUsername", remoteUsername);
            velocityContext.put("karmaUserManager", this.karmaUserManager);
            velocityContext.put("isCustomParticipation", this.getGeneralConfiguration().getParticipation().equals((Object)GeneralConfiguration.Participation.CUSTOM));
            velocityContext.put("isCustomNotificationMailRecipient", this.getGeneralConfiguration().getNotificationMailRecipient().equals((Object)GeneralConfiguration.NotificationMailRecipient.CUSTOM));
            this.renderVelocity(request, response, "vm/userkarmaconfiguration.vm", velocityContext);
        } else {
            response.sendError(401);
        }
    }

    public void savekarmauserconfiguration(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String user = request.getParameter("username");
        String remoteUsername = this.userManager.getRemoteUser().getUsername();
        KarmaUserProfile karmaUserFromUsername = this.karmaUserManager.getKarmaUserFromUsername(remoteUsername);
        if (karmaUserFromUsername != null && remoteUsername.equalsIgnoreCase(user)) {
            String[] parameterValues = request.getParameterValues("participateinkarma");
            if (parameterValues != null && parameterValues.length > 0) {
                this.karmaUserManager.setParticipateInKarma(karmaUserFromUsername, Boolean.parseBoolean(parameterValues[0]));
            } else {
                this.karmaUserManager.setParticipateInKarma(karmaUserFromUsername, false);
            }
            String[] recieveMailParameters = request.getParameterValues("recievemail");
            if (recieveMailParameters != null && recieveMailParameters.length > 0) {
                this.karmaUserManager.setRecieveMails(karmaUserFromUsername, Boolean.parseBoolean(recieveMailParameters[0]));
            } else {
                this.karmaUserManager.setRecieveMails(karmaUserFromUsername, false);
            }
            this.loadkarmauserconfiguration(request, response);
        } else {
            response.sendError(401);
        }
    }
}

