/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.tx.Transactional;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.moewe.confluence.addons.awards.KarmaScore;
import io.moewe.confluence.addons.awards.KarmaUserProfile;
import io.moewe.confluence.addons.awards.TimeFrame;
import io.moewe.confluence.addons.awards.ao.KarmaHistoryEntry;
import io.moewe.confluence.addons.awards.ao.KarmaUser;
import io.moewe.confluence.addons.awards.services.KarmaScoreManager;
import io.moewe.confluence.addons.awards.services.KarmaUserManager;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;

@Named
public class KarmaHistoryManager {
    private final ActiveObjects ao;
    private final KarmaScoreManager karmaScoreManager;
    private final KarmaUserManager karmaUserManager;

    @Inject
    public KarmaHistoryManager(@ComponentImport ActiveObjects ao, KarmaScoreManager karmaScoreManager, KarmaUserManager karmaUserManager) {
        this.ao = ao;
        this.karmaScoreManager = karmaScoreManager;
        this.karmaUserManager = karmaUserManager;
    }

    public void storeKarmaToHistory(String ... userKeys) {
        this.ao.executeInTransaction(() -> {
            for (KarmaUserProfile karmaUser : this.karmaUserManager.getKarmaUsers(userKeys)) {
                Query query = Query.select().from(KarmaHistoryEntry.class).where("KARMA_USER_ID = ?", new Object[]{karmaUser.getKarmaUserDao().getID()}).order("HISTORY_TIME DESC").limit(1);
                KarmaScore totalUserScore = this.karmaScoreManager.getScore(karmaUser, TimeFrame.OVERALL);
                KarmaHistoryEntry[] karmaHistoryEntries = (KarmaHistoryEntry[])this.ao.find(KarmaHistoryEntry.class, query);
                if (karmaHistoryEntries.length != 0 && karmaHistoryEntries[0].getKarma() == totalUserScore.getScore()) continue;
                KarmaHistoryEntry historyEntry = (KarmaHistoryEntry)this.ao.create(KarmaHistoryEntry.class, new DBParam[0]);
                historyEntry.setKarmaUser(karmaUser.getKarmaUserDao());
                historyEntry.setKarma(totalUserScore.getScore());
                historyEntry.setHistoryTime(System.currentTimeMillis());
                historyEntry.save();
            }
            return null;
        });
    }

    @Transactional
    public KarmaHistoryEntry[] loadKarmaHistoryForUser(KarmaUserProfile karmaUserProfile) {
        Query query = Query.select().from(KarmaHistoryEntry.class).join(KarmaUser.class, "KARMA_USER_ID=KU.ID").alias(KarmaHistoryEntry.class, "KHE").alias(KarmaUser.class, "KU").where("USER_KEY = ?", new Object[]{karmaUserProfile.getUserKey()}).order("HISTORY_TIME DESC");
        return (KarmaHistoryEntry[])this.ao.find(KarmaHistoryEntry.class, query);
    }
}

