/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import io.moewe.atlassian.sdk.internal.license.MoeweLicenseService;
import io.moewe.confluence.addons.awards.AwardsEvent;
import io.moewe.confluence.addons.awards.KarmaEvent;
import io.moewe.confluence.addons.awards.KarmaUserProfile;
import io.moewe.confluence.addons.awards.ao.KarmaEntry;
import io.moewe.confluence.addons.awards.ao.KarmaEntryMetadata;
import io.moewe.confluence.addons.awards.ao.KarmaScoreDao;
import io.moewe.confluence.addons.awards.ao.KarmaUser;
import io.moewe.confluence.addons.awards.rest.pojo.output.PointOutput;
import io.moewe.confluence.addons.awards.rest.pojo.parameter.ProcessorParameter;
import io.moewe.confluence.addons.awards.services.KarmaScoreManager;
import io.moewe.confluence.addons.awards.services.KarmaUserManager;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Entity;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class KarmaEventManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(KarmaEventManager.class);
    private final PermissionManager permissionManager;
    private final ActiveObjects activeObjects;
    private final I18nResolver i18nResolver;
    private final MoeweLicenseService licenseService;
    private final TransactionTemplate transactionTemplate;
    private final KarmaScoreManager karmaScoreManager;
    private final KarmaUserManager karmaUserManager;
    private final SpaceManager spaceManager;
    private final ContentEntityManager contentEntityManager;

    @Inject
    public KarmaEventManager(@ComponentImport PermissionManager permissionManager, @ComponentImport ActiveObjects ao, @ComponentImport I18nResolver i18nResolver, KarmaUserManager karmaUserManager, MoeweLicenseService licenseService, @ComponentImport TransactionTemplate transactionTemplate, KarmaScoreManager karmaScoreManager, @ComponentImport SpaceManager spaceManager, @ConfluenceImport(value="contentEntityManager") ContentEntityManager contentEntityManager) {
        this.permissionManager = permissionManager;
        this.activeObjects = ao;
        this.i18nResolver = i18nResolver;
        this.licenseService = licenseService;
        this.transactionTemplate = transactionTemplate;
        this.karmaScoreManager = karmaScoreManager;
        this.karmaUserManager = karmaUserManager;
        this.spaceManager = spaceManager;
        this.contentEntityManager = contentEntityManager;
    }

    public boolean addPointsOutput(KarmaUserProfile karmaUserProfile, PointOutput pointOutput, ProcessorParameter processorParameter) {
        return (Boolean)this.activeObjects.executeInTransaction(() -> {
            if (!this.licenseService.isValid()) {
                LOGGER.warn("License is invalid.");
                return false;
            }
            if (pointOutput == null) {
                LOGGER.warn("Can not set point cause points output is null.");
                return false;
            }
            if (processorParameter == null) {
                LOGGER.warn("Can not set point cause processorParameter is null.");
                return false;
            }
            if (karmaUserProfile == null) {
                LOGGER.warn("Unable to run awards event for event key {} because of null user", (Object)processorParameter.getAwardsEvent().name());
                return false;
            }
            if (!this.karmaUserManager.isKarmaParticipant(karmaUserProfile)) {
                LOGGER.warn("User is no awards participant.");
                return false;
            }
            if (pointOutput.getPoints() == 0 || this.hasKarmaEventAlreadyHappened(karmaUserProfile, processorParameter)) {
                LOGGER.debug("Awards event with key {} already exists for user", (Object)processorParameter.getAwardsEvent().name());
                return false;
            }
            KarmaEntry karmaEntry = (KarmaEntry)this.activeObjects.create(KarmaEntry.class, new DBParam[0]);
            karmaEntry.setCreationTime(System.currentTimeMillis());
            karmaEntry.setKarma(pointOutput.getPoints());
            karmaEntry.setKarmaUser(karmaUserProfile.getKarmaUserDao());
            karmaEntry.setEventhash(processorParameter.getEventHash());
            karmaEntry.setEventKey(processorParameter.getAwardsEvent().name());
            if (processorParameter.getContextId() != null && !processorParameter.getContextId().isEmpty()) {
                karmaEntry.setContextId(processorParameter.getContextId());
            }
            karmaEntry.save();
            for (String parameter : processorParameter.getParameters()) {
                this.setEntryMetaData(karmaEntry, parameter);
            }
            this.markUserForRescore(karmaUserProfile);
            return true;
        });
    }

    private void setEntryMetaData(KarmaEntry karmaEntry, String metaData) {
        KarmaEntryMetadata karmaEntryMetadata = (KarmaEntryMetadata)this.activeObjects.create(KarmaEntryMetadata.class, new DBParam[0]);
        karmaEntryMetadata.setMetadata(metaData);
        karmaEntryMetadata.setKarmaEntry(karmaEntry);
        karmaEntryMetadata.save();
    }

    private void markUserForRescore(KarmaUserProfile userProfile) {
        this.transactionTemplate.execute(() -> {
            KarmaScoreDao karmaScoreDao = this.karmaScoreManager.getOrCreateKarmaScoreDao(userProfile.getKarmaUserDao());
            if (karmaScoreDao != null) {
                karmaScoreDao.setRescore(true);
                karmaScoreDao.save();
            }
            return null;
        });
    }

    private boolean hasKarmaEventAlreadyHappened(KarmaUserProfile karmaUser, ProcessorParameter processorParameter) {
        if (processorParameter.getEventHash() == 0) {
            return false;
        }
        Query query = Query.select().from(KarmaEntry.class).join(KarmaUser.class, "KARMA_USER_ID=KU.ID").alias(KarmaEntry.class, "KE").alias(KarmaUser.class, "KU").where("KE.KARMA_USER_ID = ? AND KE.EVENT_KEY = ? AND KE.EVENTHASH = ?", new Object[]{karmaUser.getKarmaUserDao().getID(), processorParameter.getAwardsEvent().name(), processorParameter.getEventHash()}).limit(1);
        KarmaEntry[] karmaEntries = (KarmaEntry[])this.activeObjects.find(KarmaEntry.class, query);
        return karmaEntries.length > 0;
    }

    public List<KarmaEvent> getLastKarmaEntries(KarmaUserProfile userprofile, int count) {
        if (userprofile == null) {
            LOGGER.warn("Unable to get last karma entries for NULL user");
            return new ArrayList<KarmaEvent>();
        }
        Query query = Query.select().from(KarmaEntry.class).join(KarmaUser.class, "KARMA_USER_ID=KU.ID").alias(KarmaEntry.class, "KE").alias(KarmaUser.class, "KU").where("USER_KEY = ?", new Object[]{userprofile.getUserKey()}).order("CREATION_TIME DESC").limit(count);
        KarmaEntry[] karmaDaos = (KarmaEntry[])this.activeObjects.find(KarmaEntry.class, query);
        ArrayList<KarmaEvent> events = new ArrayList<KarmaEvent>();
        for (KarmaEntry karmaDao : karmaDaos) {
            events.add(this.convertDaoToViewObject(karmaDao));
        }
        return events;
    }

    public KarmaEntry[] getKarmaEntries(int offset, int limit, Long millisStart, Long millisEnd) {
        ArrayList<Long> parameters = new ArrayList<Long>();
        Object clause = "";
        if (millisStart != null && millisEnd != null) {
            clause = (String)clause + "CREATION_TIME BETWEEN ? ";
            parameters.add(millisStart);
            clause = (String)clause + " AND ? ";
            parameters.add(millisEnd);
        }
        return (KarmaEntry[])this.activeObjects.find(KarmaEntry.class, Query.select().where((String)clause, parameters.toArray()).order("CREATION_TIME DESC").limit(limit).offset(offset));
    }

    public void deleteKarmaEntries(String startDate, String endDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date start = sdf.parse(startDate);
        long millisStart = start.getTime();
        Date end = sdf.parse(endDate);
        long millisEnd = end.getTime() + 86400000L;
        this.activeObjects.executeInTransaction(() -> {
            KarmaEntry[] karmaEntries = (KarmaEntry[])this.activeObjects.find(KarmaEntry.class, "CREATION_TIME BETWEEN ? AND ?", new Object[]{millisStart, millisEnd});
            if (karmaEntries.length > 0) {
                Supplier<Stream> streamSupplier = () -> (Stream)Arrays.stream(karmaEntries).parallel();
                String in = streamSupplier.get().map(entity -> "?").collect(Collectors.joining(","));
                Object[] karmaIds = streamSupplier.get().map(Entity::getID).toArray();
                this.activeObjects.deleteWithSQL(KarmaEntryMetadata.class, "KARMA_ENTRY_ID IN (" + in + ")", karmaIds);
            }
            this.activeObjects.delete((RawEntity[])karmaEntries);
            return null;
        });
    }

    private KarmaEvent convertDaoToViewObject(KarmaEntry dao) {
        KarmaEvent event = new KarmaEvent();
        event.setKey(dao.getEventKey());
        event.setCreationDate(new Date(dao.getCreationTime()));
        event.setKarma(dao.getKarma());
        if (this.hasUserKarmaEntryPermission(AuthenticatedUserThreadLocal.get(), dao)) {
            event.setDescription(this.i18nResolver.getText("io.moewe.confluence.addons.awards.event." + dao.getEventKey() + ".message", this.getKarmaEntryMetadataAsSimpleArray(dao)));
        } else {
            event.setDescription(this.i18nResolver.getText("communardo.karmaevent.message.no.permission"));
        }
        return event;
    }

    public boolean hasUserKarmaEntryPermission(ConfluenceUser user, KarmaEntry karmaEntry) {
        try {
            AwardsEvent event = AwardsEvent.valueOf(karmaEntry.getEventKey());
            if (event.getPermissionType().equals((Object)AwardsEvent.PermissionType.NONE) || karmaEntry.getContextId() == null) {
                return true;
            }
            long contentId = Long.parseLong(karmaEntry.getContextId());
            ContentEntityObject confluenceObject = null;
            if (event.getPermissionType().equals((Object)AwardsEvent.PermissionType.PAGE)) {
                confluenceObject = this.contentEntityManager.getById(contentId);
            } else if (event.getPermissionType().equals((Object)AwardsEvent.PermissionType.SPACE)) {
                confluenceObject = this.spaceManager.getSpace(contentId);
            }
            return confluenceObject != null && this.permissionManager.hasPermissionNoExemptions((User)user, Permission.VIEW, (Object)confluenceObject);
        }
        catch (Exception e) {
            LOGGER.error("Error during karma event permission check", (Throwable)e);
            return false;
        }
    }

    private Serializable[] getKarmaEntryMetadataAsSimpleArray(KarmaEntry karmaEntry) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (KarmaEntryMetadata karmaEntryMetadata : karmaEntry.getKarmaEntryMetadata()) {
            resultList.add(StringEscapeUtils.escapeHtml4((String)karmaEntryMetadata.getMetadata()));
        }
        return (Serializable[])resultList.toArray(new String[0]);
    }
}

