/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.migration;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import io.moewe.confluence.addons.awards.ao.KarmaProperty;
import io.moewe.confluence.addons.awards.ao.KarmaScoreDao;
import io.moewe.confluence.addons.awards.ao.KarmaUser;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@ExportAsService
public class CreateInitialUserRankingTask
implements PluginUpgradeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateInitialUserRankingTask.class);
    private final ActiveObjects ao;

    @Inject
    public CreateInitialUserRankingTask(@ComponentImport ActiveObjects ao) {
        this.ao = ao;
    }

    public Collection<Message> doUpgrade() {
        this.ao.executeInTransaction(() -> {
            KarmaProperty[] karmaProperties = (KarmaProperty[])this.ao.find(KarmaProperty.class, Query.select().where("KEY = ?", new Object[]{"migration.userranking.initialization"}));
            boolean userMigrationDone = false;
            if (karmaProperties != null && karmaProperties.length > 0 && "true".equals(karmaProperties[0].getValue())) {
                userMigrationDone = true;
            }
            if (!userMigrationDone) {
                KarmaUser[] allKarmaUsers;
                LOGGER.warn("Running userranking migration..");
                for (KarmaUser karmaUser : allKarmaUsers = (KarmaUser[])this.ao.find(KarmaUser.class)) {
                    if (karmaUser == null) continue;
                    LOGGER.warn("user " + karmaUser.getUserKey() + " marked for rescore");
                    KarmaScoreDao create = (KarmaScoreDao)this.ao.create(KarmaScoreDao.class, new DBParam[]{new DBParam("KARMA_USER_ID", (Object)karmaUser.getID())});
                    create.setRescore(true);
                    create.save();
                }
                assert (karmaProperties != null);
                KarmaProperty karmaProperty = karmaProperties.length > 0 ? karmaProperties[0] : (KarmaProperty)this.ao.create(KarmaProperty.class, new DBParam[0]);
                karmaProperty.setKey("migration.userranking.initialization");
                karmaProperty.setValue("true");
                karmaProperty.save();
            }
            return null;
        });
        return new ArrayList<Message>();
    }

    public int getBuildNumber() {
        return 5984;
    }

    public String getPluginKey() {
        return "de.communardo.confluence.plugins.karma";
    }

    public String getShortDescription() {
        return "Initially create the ranking for each user.";
    }

    public ActiveObjects getAo() {
        return this.ao;
    }
}

