/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.migration;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import io.moewe.atlassian.sdk.auiforms.FormService;
import io.moewe.atlassian.sdk.auiforms.exceptions.FormException;
import io.moewe.confluence.addons.awards.ao.KarmaProperty;
import io.moewe.confluence.addons.awards.forms.GeneralConfiguration;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@ExportAsService
public class AwardsGeneralConfigurationUpgradeTask
implements PluginUpgradeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AwardsGeneralConfigurationUpgradeTask.class);
    private static final String KARMA_PROPERTY_LINKED_USERNAME_KARMA_ACTIVE = "linked.username.karma.active";
    private static final String KARMA_PROPERTY_SEND_NOTIFICATION_TO = "karma.notifications.setting";
    private static final String KARMA_PROPERTY_SEND_NOTIFICATION_FOLLOWERS = "FOLLOWERS";
    private final FormService formService;
    private final ActiveObjects ao;

    @Inject
    public AwardsGeneralConfigurationUpgradeTask(FormService formService, @ComponentImport ActiveObjects activeObjects) {
        this.formService = formService;
        this.ao = activeObjects;
    }

    public int getBuildNumber() {
        return 2019072200;
    }

    public String getShortDescription() {
        return "Migrates general configuration properties to general configuration form.";
    }

    public Collection<Message> doUpgrade() throws Exception {
        GeneralConfiguration generalConfiguration = this.formService.getForm(GeneralConfiguration.class);
        this.ao.executeInTransaction(() -> {
            KarmaProperty[] karmaProperties;
            LOGGER.warn("Running general configuration migration...");
            for (KarmaProperty karmaProperty : karmaProperties = (KarmaProperty[])this.ao.find(KarmaProperty.class, Query.select().where("KEY = ? OR KEY = ? ", new Object[]{KARMA_PROPERTY_LINKED_USERNAME_KARMA_ACTIVE, KARMA_PROPERTY_SEND_NOTIFICATION_TO}))) {
                if (karmaProperty.getKey().equals(KARMA_PROPERTY_LINKED_USERNAME_KARMA_ACTIVE)) {
                    generalConfiguration.setLinkedUsernameKarma(karmaProperty.getValue().equals("true"));
                }
                if (!karmaProperty.getKey().equals(KARMA_PROPERTY_SEND_NOTIFICATION_TO)) continue;
                if (karmaProperty.getValue().equals(KARMA_PROPERTY_SEND_NOTIFICATION_FOLLOWERS)) {
                    generalConfiguration.setNotificationRecipient(GeneralConfiguration.NotificationRecipient.FOLLOWER);
                    continue;
                }
                generalConfiguration.setNotificationRecipient(GeneralConfiguration.NotificationRecipient.ALL);
            }
            generalConfiguration.setUnit("Karma");
            generalConfiguration.setParticipation(GeneralConfiguration.Participation.CUSTOM);
            generalConfiguration.setNotificationMailRecipient(GeneralConfiguration.NotificationMailRecipient.CUSTOM);
            try {
                this.formService.saveForm(generalConfiguration, true);
            }
            catch (FormException e) {
                LOGGER.error("Exception while saving general configuration form", (Throwable)e);
            }
            LOGGER.warn("General configuration migration done.");
            return Collections.emptySet();
        });
        return Collections.emptySet();
    }

    public String getPluginKey() {
        return "de.communardo.confluence.plugins.karma";
    }
}

