/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.job;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import io.moewe.confluence.addons.awards.KarmaUserProfile;
import io.moewe.confluence.addons.awards.services.KarmaUserManager;
import io.moewe.confluence.addons.awards.services.UserAwardsService;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class AwardsUserActiveStateJob
implements JobRunner {
    private final KarmaUserManager karmaUserManager;
    private final UserAccessor userAccessor;
    private final UserAwardsService userAwardsService;

    @Inject
    public AwardsUserActiveStateJob(KarmaUserManager karmaUserManager, @ComponentImport UserAccessor userAccessor, UserAwardsService userAwardsService) {
        this.karmaUserManager = karmaUserManager;
        this.userAccessor = userAccessor;
        this.userAwardsService = userAwardsService;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        List<KarmaUserProfile> karmaUsers = this.karmaUserManager.getKarmaUsers(new String[0]);
        List usernamesWithConfluenceAccess = this.userAccessor.getUserNamesWithConfluenceAccess();
        Iterator<KarmaUserProfile> iterator = karmaUsers.iterator();
        while (iterator.hasNext()) {
            KarmaUserProfile karmaUser;
            ConfluenceUser user = this.userAwardsService.getUser((karmaUser = iterator.next()).getKarmaUserDao());
            this.karmaUserManager.setUserActive(karmaUser, user != null && usernamesWithConfluenceAccess.contains(user.getName()));
        }
        return JobRunnerResponse.success((String)"Successfully executed Job named AwardsUserActiveStateJob");
    }
}

