/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.atlassian.sdk.auiforms.rest.entities.filters;

import com.atlassian.sal.api.message.I18nResolver;
import io.moewe.atlassian.sdk.auiforms.annotation.Autocomplete;
import io.moewe.atlassian.sdk.auiforms.rest.entities.FieldScheme;
import io.moewe.atlassian.sdk.auiforms.rest.entities.filters.FieldSchemeFilter;
import java.lang.reflect.Field;

public class AutocompleteFieldSchemeFilter
implements FieldSchemeFilter {
    @Override
    public void filter(FieldScheme fieldDescription, Field field, Object entity, I18nResolver i18nResolver, String i18nPrefix) {
        Autocomplete autocomplete = field.getAnnotation(Autocomplete.class);
        if (autocomplete == null) {
            return;
        }
        fieldDescription.setVariant("autocomplete");
        fieldDescription.addFieldDataAttribute("rest-path", autocomplete.restPath());
        fieldDescription.addFieldDataAttribute("placeholder", i18nResolver.getText(autocomplete.placeholderI18n()));
        fieldDescription.addFieldDataAttribute("allow-clear", String.valueOf(autocomplete.allowClear()));
        fieldDescription.addFieldDataAttribute("close-on-select", String.valueOf(autocomplete.closeOnSelect()));
        fieldDescription.addFieldDataAttribute("maximum-input-length", String.valueOf(autocomplete.maximumInputLength()));
        fieldDescription.addFieldDataAttribute("minimum-input-length", String.valueOf(autocomplete.minimumInputLength()));
        fieldDescription.addFieldDataAttribute("maximum-selection-length", String.valueOf(autocomplete.maximumSelectionLength()));
        fieldDescription.addFieldDataAttribute("minimum-results-for-search", String.valueOf(autocomplete.minimumResultsForSearch()));
        fieldDescription.addFieldDataAttribute("multiple", String.valueOf(autocomplete.multiple()));
        fieldDescription.addFieldDataAttribute("tags", String.valueOf(autocomplete.tags()));
        fieldDescription.addFieldDataAttribute("type", autocomplete.type().name());
    }
}

