/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.atlassian.sdk.auiforms;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.moewe.atlassian.sdk.auiforms.Form;
import io.moewe.atlassian.sdk.auiforms.exceptions.FormException;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.collections4.map.LRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Named
public class FormService
implements DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormService.class);
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    private final BandanaManager bandanaManager;
    private final BandanaContext context = ConfluenceBandanaContext.GLOBAL_CONTEXT;
    private final UserManager userManager;
    private final LRUMap<String, Form> formCache = new LRUMap(Integer.getInteger("moewe-aui-forms-sdk-cache-size", 100).intValue());

    @Inject
    public FormService(@ComponentImport BandanaManager bandanaManager, @ComponentImport UserManager userManager) {
        this.bandanaManager = bandanaManager;
        this.userManager = userManager;
    }

    public Form saveForm(Form form) throws FormException {
        return this.saveForm(form, false);
    }

    public Form saveForm(Form form, boolean forceSave) throws FormException {
        UserKey user;
        if (!(forceSave || (user = this.userManager.getRemoteUserKey()) != null && this.userManager.isSystemAdmin(user))) {
            throw new FormException("You are not allowed to do this.");
        }
        try {
            this.bandanaManager.setValue(this.context, form.getKey(), (Object)MAPPER.writeValueAsString(form));
        }
        catch (JsonProcessingException e) {
            throw new FormException("There was an error saving the form.", e);
        }
        this.formCache.put((Object)form.getKey(), (Object)form);
        return form;
    }

    public Form getForm(String formClass) throws FormException {
        return this.getForm(this.getFormClass(formClass));
    }

    public Class<Form> getFormClass(String formClass) throws FormException {
        try {
            return Class.forName(formClass);
        }
        catch (Exception e) {
            throw new FormException("Invalid form", e);
        }
    }

    public <T extends Form> T getForm(Class<T> formClass) throws FormException {
        try {
            String key = this.getKey(formClass);
            Form form = (Form)this.formCache.get((Object)key);
            if (form != null) {
                return (T)form;
            }
            Object possibleOldFormValue = this.bandanaManager.getValue(this.context, key);
            if (possibleOldFormValue != null) {
                if (possibleOldFormValue instanceof String) {
                    form = MAPPER.readValue((String)possibleOldFormValue, Form.class);
                } else {
                    try {
                        form = (Form)possibleOldFormValue;
                        this.saveForm(form, true);
                    }
                    catch (ClassCastException e) {
                        LOGGER.error("Please restart Confluence to clear classloader caches. Thank you.");
                        throw new FormException("Please restart Confluence to clear classloader caches. Thank you.");
                    }
                }
            }
            if (form == null) {
                form = (Form)formClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            this.formCache.put((Object)key, (Object)form);
            return (T)form;
        }
        catch (FormException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormException("Error getting form", e);
        }
    }

    private <T extends Form> String getKey(Class<T> formClass) throws Exception {
        Form form = (Form)formClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (!form.getKey().isEmpty()) {
            return form.getKey();
        }
        throw new FormException("Key is missing");
    }

    public void destroy() throws Exception {
        this.formCache.clear();
    }
}

