jQuery(function (jQuery) {
    document.querySelectorAll('.moewe-sdk-auiform:not([data-form-loaded])').forEach(form => moewe_aui_load_form(form))
});

function moewe_aui_rest_context(formContainer) {
    let container = jQuery(formContainer);
    let fieldControllerPath = container.data('field-controller');
    let restPath = container.data('rest-path');
    let rest_controller = '/moewe-sdk/auiforms/default-controller';

    if (fieldControllerPath) {
        switch (fieldControllerPath) {
            case "bandana":
                rest_controller = '/moewe-sdk/auiforms/bandana-controller';
                break;
            default:
                rest_controller = fieldControllerPath;
        }
    }

    return AJS.Data.get('base-url') + '/rest' + restPath + '/latest' + rest_controller;
}

function moewe_aui_load_form(formContainer, fieldControllerPath = null, restPath = null, formEntityId = null) {

    formContainer.dataset.formLoaded = "true";

    // @deprecated Use formContainer and pure JS directly
    let container = jQuery(formContainer);

    if (!formContainer.classList.contains("moewe-sdk-auiform")) {
        formContainer.classList.add("moewe-sdk-auiform");
    }

    if (fieldControllerPath != null) {
        formContainer.dataset.fieldController = fieldControllerPath;
    } else {
        fieldControllerPath = formContainer.dataset.fieldController;
    }

    if (restPath != null) {
        formContainer.dataset.restPath = restPath;
    }

    if (formEntityId != null) {
        formContainer.dataset.fieldClass = formEntityId;
    } else {
        formEntityId = formContainer.dataset.fieldClass;
    }

    let storable = true;
    if (!fieldControllerPath) {
        storable = false;
    }

    let rest_controller_path = moewe_aui_rest_context(formContainer);
    let request = jQuery.getJSON(rest_controller_path + '/form-response', {
        id: formEntityId,
        atl_token: AJS.Data.get('atl-token')
    });

    let settings = {
        form: {
            id: (container.data('settings-form-id')) ? container.data('settings-form-id') : MOEWE.SDK.Utils.Uuid()
        }
    };

    container.append('<aui-spinner size="medium" class="loading-spinner"></aui-spinner>');

    // TODO Extract method
    request.done(function (json) {
        let template = MOEWE.Templates.AUI.forms.renderFormResponse({
            settings: settings,
            formClass: json.formClass,
            fields: json.fields
        });
        container.find('.loading-spinner').remove();
        container.append(template);

        // Deprecated, use plain JavaScript event on document instead
        jQuery(container).trigger("moewe-sdk-auiform:afterRender");

        moewe_aui_dispatch("afterRender", {
            container: jQuery(formContainer), // @Deprecated Use domElement and pure JS instead
            domElement: formContainer,
            settings: settings,
            fields: json.fields
        })

        // TODO Extract method
        container.find('form').submit(function (event) {
            event.preventDefault();
            if (storable) {
                let form_data = jQuery(this).serializeJSON({
                        customTypes: {
                            inputArray: function (str) {
                                return str.split(',').map(value => value.trim());
                            }
                        }
                    }
                );
                moewe_aui_save_form(container, rest_controller_path + '/form', formEntityId, form_data, settings);
            }
            return false;
        });

        /*
                // Load select2 on String[] fields
                container.find('input.select2-tags').auiSelect2({
                    tags: [],
                    tokenSeparators: [',']
                });

                // Load autocompletes
                if (typeof Confluence !== 'undefined') {
                    Confluence.Binder.autocompleteAttachment(container);
                    Confluence.Binder.autocompleteBlogpost(container);
                    Confluence.Binder.autocompleteConfluenceContent(container);
                    Confluence.Binder.autocompletePage(container);
                    Confluence.Binder.autocompleteSearch(container);
                    Confluence.Binder.autocompleteSpace(container);
                    Confluence.Binder.autocompleteUserOrGroup(container);
                }
        */
        // functionality in list
        /*
        const repeatable = container[0].querySelectorAll(".repeatable")
        repeatable.forEach(repeatable => {
            const belongingToField = json.fields.find(field => field.name === repeatable.dataset.auiformName)
            const elements = repeatable.querySelector(".repeatable-fields")

            const enableDelete = element => {
                const deleteButton = element.querySelector(".deleteButton")
                deleteButton.addEventListener("click", (event) => {
                    elements.removeChild(element)
                })
            }

            const addButton = repeatable.querySelector(".addButton")
            if (addButton && !belongingToField.readOnly) {
                addButton.addEventListener("click", (event) => {
                    const htmlString = MOEWE.Templates.AUI.forms.renderStringListElement({
                        field: belongingToField,
                        value: ""
                    })

                    const htmlNode = document.createRange().createContextualFragment(htmlString);
                    elements.appendChild(htmlNode);
                    enableDelete(elements.lastChild)
                })
            }

            if (!belongingToField.readOnly) {
                elements.childNodes.forEach(enableDelete)
            }
        })


         */
    });

    request.fail(function (jqXHR) {
        let response = JSON.parse(jqXHR.responseText);
        AJS.messages.error(container, {
            title: AJS.I18n.getText("io.moewe.atlassian.sdk.auiforms.submit.error.title"),
            body: '<p>' + response.message + '</p>'
        });
        AJS.flag({
            type: 'error',
            title: AJS.I18n.getText("io.moewe.atlassian.sdk.auiforms.submit.error.title"),
            body: '<p>' + response.message + '</p>',
            close: 'auto'
        });
    })
}

function moewe_aui_save_form(container, rest_url, form, form_data, settings) {
    container.find('.buttons .aui-icon-wait').removeClass("hidden");
    container.find(".error").remove();
    let message_container = container.find('.aui-message-bar');
    let request = jQuery.post(rest_url, {
        atl_token: AJS.Data.get('atl-token'),
        id: form,
        content: JSON.stringify(form_data)
    });

    request.done(function (response) {
        message_container.text('');
        AJS.flag({
            type: 'success',
            title: AJS.I18n.getText("io.moewe.atlassian.sdk.auiforms.submit.success.title"),
            body: '<p>' + AJS.I18n.getText("io.moewe.atlassian.sdk.auiforms.submit.success.desc") + '</p>',
            close: 'auto'
        });
        container.find('.buttons .aui-icon-wait').addClass("hidden");

        moewe_aui_dispatch("afterSaveForm", {
            container: container, // @Deprecated Use domElement and pure JS instead
            domElement: container[0],
            settings: settings,
            response: response
        })

    });

    request.fail(function (jqXHR) {
        let response = JSON.parse(jqXHR.responseText);
        message_container.text('');
        if (response.type === 'ValidationFailureResponse') {
            AJS.messages.error(message_container, {
                title: AJS.I18n.getText("io.moewe.atlassian.sdk.auiforms.submit.error.validation.title"),
                body: '<p>' + AJS.I18n.getText("io.moewe.atlassian.sdk.auiforms.submit.error.validation.desc") + '</p>'
            });
            AJS.flag({
                type: 'error',
                title: AJS.I18n.getText("io.moewe.atlassian.sdk.auiforms.submit.error.validation.title"),
                body: '<p>' + AJS.I18n.getText("io.moewe.atlassian.sdk.auiforms.submit.error.validation.desc") + '</p>',
                close: 'auto'
            });

            jQuery.each(response.fieldErrors, function (fieldName, errorMessage) {
                jQuery('<div class="error">' + AJS.I18n.getText(errorMessage) + ' </div>').insertAfter(container.find("[name='" + fieldName + "']"));
            });


            container.find('.buttons .aui-icon-wait').addClass("hidden");
            return;
        }

        AJS.messages.error(message_container, {
            title: AJS.I18n.getText("io.moewe.atlassian.sdk.auiforms.submit.error.title"),
            body: '<p>' + AJS.I18n.getText("io.moewe.atlassian.sdk.auiforms.submit.error.error.desc") + '</p>'
        });
        AJS.flag({
            type: 'error',
            title: AJS.I18n.getText("io.moewe.atlassian.sdk.auiforms.submit.error.title"),
            body: '<p>' + AJS.I18n.getText("io.moewe.atlassian.sdk.auiforms.submit.error.error.desc") + '</p>',
            close: 'auto'
        });
        container.find('.buttons .aui-icon-wait').addClass("hidden");
    });
}

function moewe_aui_dispatch(auiEventName, data) {
    let context = 'moewe-sdk-auiform';

    document.dispatchEvent(new CustomEvent(context + ':' + auiEventName, {
        detail: data
    }));
}


document.addEventListener("moewe-sdk-auiform:addRepeatableItem", moewe_aui_add_repeatable_item);

function moewe_aui_add_repeatable_item(event) {
    let button = event.detail;
    let formContainer = button.closest(".moewe-sdk-auiform");
    if (formContainer) {
        let repeatableContainerFooter = button.closest(".moewe-aui-forms-repeatable-footer");
        let typeSelect = repeatableContainerFooter.getElementsByTagName("select")[0];
        if (typeSelect.value != "") {
            let request = jQuery.getJSON(moewe_aui_rest_context(formContainer) + '/scheme', {
                className: typeSelect.value,
                i18nPrefix: typeSelect.dataset.i18nPrefix,
                namePrefix: typeSelect.dataset.namePrefix,
                atl_token: AJS.Data.get('atl-token')
            });
            request.done(function (json) {
                let item = document.createElement('div');
                item.innerHTML = MOEWE.Templates.AUI.forms.renderRepeatableItem({field: json});
                repeatableContainerFooter.previousSibling.appendChild(item.firstChild);

                let autocompleteElements = repeatableContainerFooter.previousSibling.lastChild.getElementsByClassName("moewe-auiform-autocomplete");
                if (autocompleteElements) {
                    jQuery.each(autocompleteElements, function (key, value) {
                        moewe_aui_init_autocomplete(value);
                    });
                }
            });
        }
    }
}

document.addEventListener("moewe-sdk-auiform:removeRepeatableItem", moewe_aui_remove_repeatable_item);

function moewe_aui_remove_repeatable_item(event) {
    if (window.confirm(AJS.I18n.getText("io.moewe.atlassian.sdk.auiforms.response.field.repeatable.confirm"))) {
        let button = event.detail;
        button.closest(".moewe-aui-forms-repeatable-item").remove();
    }
}

document.addEventListener("moewe-sdk-auiform:afterRender", moewe_aui_init_autocompletes);

function moewe_aui_init_autocomplete(element) {
    let type = element.dataset.type;
    let restPath = element.dataset.restPath;

    let settings = {};
    settings.placeholder = element.dataset.placeholder;
    settings.allowClear = element.dataset.allowClear;
    settings.closeOnSelect = element.dataset.closeOnSelect;
    settings.maximumInputLength = (element.dataset.maximumInputLength == -1) ? null : element.dataset.maximumInputLength;
    settings.minimumInputLength = (element.dataset.minimumInputLength == -1) ? null : element.dataset.minimumInputLength;
    settings.maximumSelectionLength = (element.dataset.minimumSelectionLength == -1) ? null : element.dataset.minimumSelectionLength;
    settings.minimumResultsForSearch = (element.dataset.minimumResultsForSearch == -1) ? null : element.dataset.minimumResultsForSearch;
    settings.multiple = (element.dataset.multiple == "true") ? true : false;

    if (settings.multiple) {
        element.setAttribute("multiple", "multiple");
    }

    if (element.dataset.tags != "false") {
        settings.tags = '' + element.dataset.tags; // wtf select2 need this as string
    }

    if (restPath !== "") {
        settings.initSelection = function (element, callback) {
            let resourceRestPath = restPath;
            let data = {};
            let value = jQuery.trim(element.val());

            if (type == "CUSTOM") {
                resourceRestPath = resourceRestPath + '/' + value;
            } else {
                let cql = "";

                switch (type) {
                    case "SPACE":
                        cql = 'type=space AND space.key IN (' + value + ')';
                        break;
                    case "ATTACHMENT":
                    case "BLOGPOST":
                    case "PAGE":
                        cql = 'type=' + type.toLowerCase() + ' AND content IN (' + value + ')';
                        break;
                    case "CONTENT":
                        cql = '( type=page OR type = blogpost ) AND content IN (' + value + ')';
                        break;
                }

                data = {cql: cql};
            }

            if (value != "") {
                jQuery.ajax({
                    dataType: "json",
                    url: AJS.Data.get('base-url') + '/rest/' + resourceRestPath,
                    data: data
                }).done(function (json) {
                    if (type == "CUSTOM") {
                        callback(json);
                    } else if (json.results && json.results.length > 0) {
                        let data = [];
                        jQuery.each(json.results, function (index, value) {
                            switch (type) {
                                case "SPACE":
                                    data.push({
                                        id: value.space.key,
                                        text: value.space.name,
                                        iconCssClass: value.iconCssClass
                                    });
                                    break;
                                case "ATTACHMENT":
                                case "BLOGPOST":
                                case "PAGE":
                                case "CONTENT":
                                    data.push({
                                        id: value.content.id,
                                        text: value.content.title,
                                        iconCssClass: value.iconCssClass
                                    });
                                    break;
                            }
                        });

                        if (settings.multiple) {
                            callback(data);
                        } else {
                            if (data.length > 0) {
                                callback(data[0]);
                            }
                        }
                    }
                });
            }
        };

        settings.ajax = {
            url: AJS.Data.get('base-url') + '/rest/' + restPath,
            dataType: 'json',
            data: function (term) {
                if (type == "CUSTOM") {
                    return {
                        term: term
                    }
                }

                let cql = "";

                if (term !== "") {
                    switch (type) {
                        case "SPACE":
                            cql = 'type=space AND space.title ~ "' + term + '*"';
                            break;
                        case "ATTACHMENT":
                        case "BLOGPOST":
                        case "PAGE":
                            cql = 'type=' + type.toLowerCase() + ' AND title ~ "' + term + '*"';
                            break;
                        case "CONTENT":
                            cql = '( type=page OR type = blogpost ) AND title ~ "' + term + '*"';
                            break;
                    }
                }

                return {
                    cql: cql,
                }
            },
            results: function (data, page) {
                let items = [];

                jQuery.each(data.results, function (index, value) {
                    switch (type) {
                        case "SPACE":
                            items.push({
                                id: value.space.key,
                                text: value.space.name,
                                iconCssClass: value.iconCssClass
                            })
                            break;
                        case "ATTACHMENT":
                        case "CONTENT":
                        case "BLOGPOST":
                        case "PAGE":
                            items.push({
                                id: value.content.id,
                                text: value.content.title,
                                iconCssClass: value.iconCssClass
                            })
                            break;
                        case "CUSTOM":
                            items.push({id: value.id, text: value.text, iconCssClass: ""})
                            break;
                    }

                });

                return {
                    results: items
                };
            }
        }

        settings.formatResult = function (element) {
            let icon = '';
            if (element.iconCssClass) {
                icon = '<i class="' + element.iconCssClass + '"></i>';
            }
            return '<div class="moewe-auiform-autocomplete-item">' + icon + element.text + '</div>';
        };

        settings.formatSelection = function (element) {
            let icon = '';
            if (element.iconCssClass) {
                icon = '<i class="' + element.iconCssClass + '"></i>';
            }
            return '<div class="moewe-auiform-autocomplete-item">' + icon + element.text + '</div>';
        };

    }
    AJS.$(element).auiSelect2(settings);
}

function moewe_aui_init_autocompletes(event) {
    event.detail.container.find('.moewe-auiform-autocomplete').each(function (index) {
        moewe_aui_init_autocomplete(this);
    });
}
