var KarmaOverview = function () {

    this.init = function () {
        doContainerEqualHeight();
        KarmaDialog.registerKarmaDialog(jQuery("#badgelist-link"), "#badge-list-dialog-content");
        KarmaDialog.registerKarmaDialog(jQuery("#karmalist-link"), "#karmaevent-dialog-content");
        loadKarmaHistoryPlot();
        registerSelectedTimeframeHandling();

        jQuery("#user-karma-ranking-container").on("karma.ranking.refreshed", function () {
            doContainerEqualHeight();
        });

        $(window).resize(function () {
            doContainerEqualHeight();
        });
    };

    function registerSelectedTimeframeHandling() {

        jQuery("#user-karma-ranking-container .karmarankingtimeframeselector").click(function () {
            jQuery.cookie("karma.overview.ranking.timeframe", jQuery(this).attr("timeframe"), {expires: 365});
        });


        var userOverviewTimeframe = jQuery.cookie("karma.overview.ranking.timeframe");
        if (userOverviewTimeframe != "") {
            jQuery("#user-karma-ranking-container").one("karma.ranking.refreshed", function () {
                jQuery("#user-karma-ranking-container .karmarankingtimeframeselector[timeframe=" + userOverviewTimeframe + "]").trigger("click");
            });
        }
    }

    function doContainerEqualHeight() {
        var heightArray = jQuery(".overview-content-container").map(function () {
            return jQuery(this).height();
        }).get();

        var maxHeight = Math.max.apply(Math, heightArray);
        jQuery(".overview-content-container").css("min-height", maxHeight);
    }

    function loadKarmaHistoryPlot() {
        let historyChart = jQuery("#karma-history-chart");
        if (historyChart.length === 0) {
            return
        }

        let username = jQuery("#karmausername").val();
        jQuery.get(contextPath + "/rest/moewe-awards/1.0/user/" + username + "/history/points", function (data) {
            var karmaPlot = jQuery.plot(historyChart, [{
                data: data,
                lines: {show: true},
                points: {show: true},
                color: "#00BF06",
                label: historyChart.data("unit")
            }], {xaxis: {mode: "time"}, legend: {position: "nw"}});
            jQuery(window).resize(function () {
                karmaPlot.resize();
                karmaPlot.setupGrid();
                karmaPlot.draw();
            });
        });
    }
};

jQuery(document).ready(function () {

    const karmaOverview = new KarmaOverview();
    karmaOverview.init()

    jQuery("#karma-user-configuration-button").click(openKarmaUserConfigurationDialog);
    jQuery("#karma-configuration-button").click(openKarmaConfiguration);

    function openKarmaUserConfigurationDialog() {

        var dialog = new AJS.Dialog({
            width: 400,
            height: 300,
            id: "user-configuration-dialog",
            closeOnOutsideClick: true
        });

        dialog.addHeader(jQuery("#user-configuration-title").val(), "karma-dialog");
        dialog.addButton(jQuery("#user-configuration-save").val(), saveKarmaUserConfiguration, "karmauser-save-button");
        dialog.addCancel(jQuery("#user-configuration-close").val(), function () {
            dialog.remove()
        });

        jQuery.post(contextPath + "/plugins/servlet/karma/overview/loadkarmauserconfiguration?username=" + jQuery("#karmausername").val(), function (result) {
            dialog.addPanel(jQuery("#user-configuration-title").val(), jQuery(result), "karma-dialog-panel", 1);
            initConfigurationForm();
        });
        dialog.show();

        function initConfigurationForm() {
            jQuery("#karma-userconfiguration-form input").change(function () {
                jQuery("#user-configuration-dialog .karmauser-save-button").removeAttr("aria-disabled");
                jQuery("#user-configuration-dialog .karmauser-save-button").removeAttr("disabled");
            });
            jQuery("#user-configuration-dialog .karmauser-save-button").attr("aria-disabled", "true");
            jQuery("#user-configuration-dialog .karmauser-save-button").attr("disabled", "disabled");
        }

        function saveKarmaUserConfiguration() {
            jQuery.post(contextPath + "/plugins/servlet/karma/overview/savekarmauserconfiguration?" + jQuery("#karma-userconfiguration-form").serialize(), function (result) {
                jQuery("#user-configuration-dialog .karma-dialog-panel").html(jQuery(result));
                initConfigurationForm();
                jQuery("#karma-user-configuration-button").addClass("changedsettings");
                if (jQuery("#karma-user-configuration-button").hasClass("changedsettings")) {
                    window.location.reload()
                }
            });
        }
    }

    function openKarmaConfiguration() {
        window.location = AJS.Meta.get("base-url") + '/plugins/servlet/karma/administration/show';
    }
});
