AJS.toInit(function () {

    jQuery("#karma-reset-karmapoints").click(function (event) {
        event.preventDefault();
        jQuery("#karmaevent-container .karmaeventvalue").each(function () {

            jQuery(this).val(jQuery(this).attr("defaultvalue"));
        });
    });

    jQuery(".reset-badge-values").click(function () {
        var badgeElement = jQuery(this).closest(".badge-element");
        badgeElement.find(".defaultvalue").each(function () {
            badgeElement.find("input[name='" + jQuery(this).attr("target") + "']").val(jQuery(this).val());
            badgeElement.find("textarea[name='" + jQuery(this).attr("target") + "']").val(jQuery(this).val());
            badgeElement.find("img[name='" + jQuery(this).attr("target") + "']").attr("src", jQuery(this).val());
            badgeElement.find("input.checkbox[name='badgestatus'").attr("checked", "checked");
        });
        return false;
    });

});

document.addEventListener("DOMContentLoaded", function () {

    new MOEWE.SDK.Components.EntityManagement({
        containerId: "medals-achievement-management",
        fieldControllerPath: "/achievements",
        restPath: "/moewe-awards",
        itemViewHeader : '<tr><th>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.medal.entityName") + '</th><th>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.medal.status") + '</th><th>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.medal.actions") + '</th></tr>',
        itemViewFooter : '<tr><td>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.medal.entityName") + '</td><td>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.medal.status") + '</td><td>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.medal.actions") + '</td></tr>',
        itemViewSettings: {
            params: {
                includeDisabled: true,
                type: "MEDAL"
            },
            callback: {
                renderItem: function (result) {
                    let attributeClass = '';
                    let status = '<span class="aui-lozenge aui-lozenge-success">Active</span>';

                    if (!result.enabled) {
                        attributeClass = 'class="aui-row-subtle"';
                        status = '<span class="aui-lozenge aui-lozenge-subtle">Disabled</span>';
                    }

                    let icon = '';
                    if (result.metaData && result.metaData.iconUrl) {
                        icon = '<span class="aui-avatar aui-avatar-medium"><span class="aui-avatar-inner"><img src="' + result.metaData.iconUrl + '" alt="" role="presentation" /></span></span>';
                    }

                    return '<tr ' + attributeClass + ' ><td>' + icon + result.name + '</td><td>' + status + '</td><td><ul class="menu"><li><a href="#" class="aui-button edit-dialog-trigger" data-entity-id="' + result.uuid + '" >' + AJS.I18n.getText("moewe-sdk.components.entity-management.edit") + '</a></li><li><a href="#" class="aui-button aui-button-link delete-dialog-trigger" data-entity-id="' + result.uuid + '" >'+ AJS.I18n.getText("moewe-sdk.components.entity-management.delete") + '</a></li></ul></td></tr>';
                }
            },
            text : {
                noResults : AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.medal.noResults")
            }
        },
        text : {
            entityName : AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.medal.entityName"),
            deleteConfirmMessage : AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.medal.deleteConfirmMessage")
        }
    });

    new MOEWE.SDK.Components.EntityManagement({
        containerId: "badges-achievement-management",
        fieldControllerPath: "/achievements",
        restPath: "/moewe-awards",
        itemViewHeader : '<tr><th>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.badge.entityName") + '</th><th>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.badge.description") + '</th><th>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.badge.status") + '</th><th>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.badge.actions") + '</th></tr>',
        itemViewFooter : '<tr><td>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.badge.entityName") + '</td><td>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.badge.description") + '</td><td>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.badge.status") + '</td><td>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.badge.actions") + '</td></tr>',
        itemViewSettings: {
            params: {
                includeDisabled: true,
                type: "BADGE"
            },
            callback: {
                renderItem: function (result) {
                    let attributeClass = '';
                    let status = '<span class="aui-lozenge aui-lozenge-success">Active</span>';

                    if (!result.enabled) {
                        attributeClass = 'class="aui-row-subtle"';
                        status = '<span class="aui-lozenge aui-lozenge-subtle">Disabled</span>';
                    }


                    let icon = '';
                    if (result.metaData && result.metaData.iconUrl) {
                        icon = '<span class="aui-avatar aui-avatar-medium"><span class="aui-avatar-inner"><img src="' + result.metaData.iconUrl + '" alt="" role="presentation" /></span></span>';
                    }

                    return '<tr ' + attributeClass + ' ><td>' + icon + result.name + '</td><td>' + result.description + '</td><td>' + status + '</td><td><ul class="menu"><li><a href="#" class="aui-button edit-dialog-trigger" data-entity-id="' + result.uuid + '" >' + AJS.I18n.getText("moewe-sdk.components.entity-management.edit") + '</a></li><li><a href="#" class="aui-button aui-button-link delete-dialog-trigger" data-entity-id="' + result.uuid + '" >'+ AJS.I18n.getText("moewe-sdk.components.entity-management.delete") + '</a></li></ul></td></tr>';
                }
            },
            text : {
                noResults : AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.badge.noResults")
            }
        },
        text : {
            entityName : AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.badge.entityName"),
            deleteConfirmMessage : AJS.I18n.getText("io.moewe.confluence.addons.awards.management.achievement.badge.deleteConfirmMessage")
        }
    });

    new MOEWE.SDK.Components.EntityManagement({
        containerId: "processor-management",
        fieldControllerPath: "/processor",
        restPath: "/moewe-awards",
        itemViewHeader : '<tr><th>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.processor.entityName") + '</th><th>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.processor.description") + '</th><th>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.processor.status") + '</th><th>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.processor.actions") + '</th></tr>',
        itemViewFooter : '<tr><td>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.processor.entityName") + '</td><td>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.processor.description") + '</td><td>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.processor.status") + '</td><td>' + AJS.I18n.getText("io.moewe.confluence.addons.awards.management.processor.actions") + '</td></tr>',
        itemViewSettings: {
            params: {
                includeDisabled: true
            },
            callback: {
                renderItem: function (result) {
                    let attributeClass = '';
                    let status = '<span class="aui-lozenge aui-lozenge-success">Active</span>';

                    if (!result.enabled) {
                        attributeClass = 'class="aui-row-subtle"';
                        status = '<span class="aui-lozenge aui-lozenge-subtle">Disabled</span>';
                    }

                    return '<tr ' + attributeClass + ' ><td>' + result.name + '</td><td>' + result.description + '</td><td>' + status + '</td><td><ul class="menu"><li><a href="#" class="aui-button edit-dialog-trigger" data-entity-id="' + result.uuid + '" >' + AJS.I18n.getText("moewe-sdk.components.entity-management.edit") + '</a></li><li><a href="#" class="aui-button aui-button-link delete-dialog-trigger" data-entity-id="' + result.uuid + '" >'+ AJS.I18n.getText("moewe-sdk.components.entity-management.delete") + '</a></li></ul></td></tr>';
                }
             },
            text : {
                noResults : AJS.I18n.getText("io.moewe.confluence.addons.awards.management.processor.noResults")
            }
        },
        text : {
            entityName : AJS.I18n.getText("io.moewe.confluence.addons.awards.management.processor.entityName"),
            deleteConfirmMessage : AJS.I18n.getText("io.moewe.confluence.addons.awards.management.processor.deleteConfirmMessage")
        }
    });

    document.addEventListener("moewe-sdk-auiform:afterRender", function (e) {
        if (e.detail.container.hasClass("aui-dialog2-content")) {
            if(document.getElementById("tabs-medals").classList.contains("active-pane")) {
                jQuery("#" + e.detail.settings.form.id + ' input[name="type"]').val("MEDAL");
                jQuery("#" + e.detail.settings.form.id + ' [name="description"]').closest(".field-group").hide();
                jQuery("#" + e.detail.settings.form.id + ' [name="metaData[unique]"]').closest(".field-group").hide();
                jQuery("#" + e.detail.settings.form.id + ' [name="metaData[steps]"]').closest(".field-group").hide();
            }

            // visualize icon when input is changed
            let iconUrlElement = jQuery("#" + e.detail.settings.form.id + ' input[name="metaData[iconUrl]"]');
            if(iconUrlElement.val() !== "") {
                iconUrlElement.before('<img id="achievement-meta-data-icon" src="' + iconUrlElement.val() + '" width="60px" />');
            }

            iconUrlElement.bind("change paste keyup", function() {
                jQuery("#achievement-meta-data-icon").attr("src", iconUrlElement.val());
            });
        }
    });

});
