/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.validation.Payload;
import javax.validation.ValidationException;
import javax.xml.bind.JAXBElement;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationFactory;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetMethod;
import org.hibernate.validator.internal.xml.AnnotationType;
import org.hibernate.validator.internal.xml.ClassLoadingHelper;
import org.hibernate.validator.internal.xml.ConstraintType;
import org.hibernate.validator.internal.xml.ElementType;
import org.hibernate.validator.internal.xml.GroupsType;
import org.hibernate.validator.internal.xml.PayloadType;

class MetaConstraintBuilder {
    private static final Log log = LoggerFactory.make();
    private static final String MESSAGE_PARAM = "message";
    private static final String GROUPS_PARAM = "groups";
    private static final String PAYLOAD_PARAM = "payload";
    private final ClassLoadingHelper classLoadingHelper;
    private final ConstraintHelper constraintHelper;

    MetaConstraintBuilder(ClassLoadingHelper classLoadingHelper, ConstraintHelper constraintHelper) {
        this.classLoadingHelper = classLoadingHelper;
        this.constraintHelper = constraintHelper;
    }

    <A extends Annotation> MetaConstraint<A> buildMetaConstraint(ConstraintLocation constraintLocation, ConstraintType constraint, java.lang.annotation.ElementType type, String defaultPackage, ConstraintDescriptorImpl.ConstraintType constraintType) {
        Object annotation;
        Class<?> annotationClass;
        try {
            annotationClass = this.classLoadingHelper.loadClass(constraint.getAnnotation(), defaultPackage);
        }
        catch (ValidationException e) {
            throw log.getUnableToLoadConstraintAnnotationClassException(constraint.getAnnotation(), (Exception)((Object)e));
        }
        AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(annotationClass);
        if (constraint.getMessage() != null) {
            annotationDescriptor.setValue(MESSAGE_PARAM, constraint.getMessage());
        }
        annotationDescriptor.setValue(GROUPS_PARAM, this.getGroups(constraint.getGroups(), defaultPackage));
        annotationDescriptor.setValue(PAYLOAD_PARAM, this.getPayload(constraint.getPayload(), defaultPackage));
        for (ElementType elementType : constraint.getElement()) {
            String name = elementType.getName();
            MetaConstraintBuilder.checkNameIsValid(name);
            Class<?> returnType = MetaConstraintBuilder.getAnnotationParameterType(annotationClass, name);
            Object elementValue = this.getElementValue(elementType, returnType, defaultPackage);
            annotationDescriptor.setValue(name, elementValue);
        }
        try {
            annotation = AnnotationFactory.create(annotationDescriptor);
        }
        catch (RuntimeException e) {
            throw log.getUnableToCreateAnnotationForConfiguredConstraintException(e);
        }
        ConstraintDescriptorImpl constraintDescriptor = new ConstraintDescriptorImpl(this.constraintHelper, constraintLocation.getMember(), annotation, type, constraintType);
        return new MetaConstraint(constraintDescriptor, constraintLocation);
    }

    private <A extends Annotation> Annotation buildAnnotation(AnnotationType annotationType, Class<A> returnType, String defaultPackage) {
        AnnotationDescriptor<A> annotationDescriptor = new AnnotationDescriptor<A>(returnType);
        for (ElementType elementType : annotationType.getElement()) {
            String name = elementType.getName();
            Class<?> parameterType = MetaConstraintBuilder.getAnnotationParameterType(returnType, name);
            Object elementValue = this.getElementValue(elementType, parameterType, defaultPackage);
            annotationDescriptor.setValue(name, elementValue);
        }
        return AnnotationFactory.create(annotationDescriptor);
    }

    private static void checkNameIsValid(String name) {
        if (MESSAGE_PARAM.equals(name) || GROUPS_PARAM.equals(name)) {
            throw log.getReservedParameterNamesException(MESSAGE_PARAM, GROUPS_PARAM, PAYLOAD_PARAM);
        }
    }

    private static <A extends Annotation> Class<?> getAnnotationParameterType(Class<A> annotationClass, String name) {
        Method m = MetaConstraintBuilder.run(GetMethod.action(annotationClass, name));
        if (m == null) {
            throw log.getAnnotationDoesNotContainAParameterException(annotationClass.getName(), name);
        }
        return m.getReturnType();
    }

    private Object getElementValue(ElementType elementType, Class<?> returnType, String defaultPackage) {
        MetaConstraintBuilder.removeEmptyContentElements(elementType);
        boolean isArray = returnType.isArray();
        if (!isArray) {
            if (elementType.getContent().size() != 1) {
                throw log.getAttemptToSpecifyAnArrayWhereSingleValueIsExpectedException();
            }
            return this.getSingleValue(elementType.getContent().get(0), returnType, defaultPackage);
        }
        ArrayList<Object> values2 = CollectionHelper.newArrayList();
        for (Serializable s : elementType.getContent()) {
            values2.add(this.getSingleValue(s, returnType.getComponentType(), defaultPackage));
        }
        return values2.toArray((Object[])Array.newInstance(returnType.getComponentType(), values2.size()));
    }

    private static void removeEmptyContentElements(ElementType elementType) {
        ArrayList contentToDelete = CollectionHelper.newArrayList();
        for (Serializable content : elementType.getContent()) {
            if (!(content instanceof String) || !((String)((Object)content)).matches("[\\n ].*")) continue;
            contentToDelete.add(content);
        }
        elementType.getContent().removeAll(contentToDelete);
    }

    private Object getSingleValue(Serializable serializable, Class<?> returnType, String defaultPackage) {
        Object returnValue;
        if (serializable instanceof String) {
            String value = (String)((Object)serializable);
            returnValue = this.convertStringToReturnType(returnType, value, defaultPackage);
        } else if (serializable instanceof JAXBElement && ((JAXBElement)serializable).getDeclaredType().equals(String.class)) {
            JAXBElement elem = (JAXBElement)serializable;
            String value = (String)elem.getValue();
            returnValue = this.convertStringToReturnType(returnType, value, defaultPackage);
        } else if (serializable instanceof JAXBElement && ((JAXBElement)serializable).getDeclaredType().equals(AnnotationType.class)) {
            JAXBElement elem = (JAXBElement)serializable;
            AnnotationType annotationType = (AnnotationType)elem.getValue();
            try {
                Class<?> annotationClass = returnType;
                returnValue = this.buildAnnotation(annotationType, annotationClass, defaultPackage);
            }
            catch (ClassCastException e) {
                throw log.getUnexpectedParameterValueException(e);
            }
        } else {
            throw log.getUnexpectedParameterValueException();
        }
        return returnValue;
    }

    private Object convertStringToReturnType(Class<?> returnType, String value, String defaultPackage) {
        Class<?> returnValue;
        if (returnType.getName().equals(Byte.TYPE.getName())) {
            try {
                returnValue = Byte.parseByte(value);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("byte", e);
            }
        }
        if (returnType.getName().equals(Short.TYPE.getName())) {
            try {
                returnValue = Short.parseShort(value);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("short", e);
            }
        }
        if (returnType.getName().equals(Integer.TYPE.getName())) {
            try {
                returnValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("int", e);
            }
        }
        if (returnType.getName().equals(Long.TYPE.getName())) {
            try {
                returnValue = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("long", e);
            }
        }
        if (returnType.getName().equals(Float.TYPE.getName())) {
            try {
                returnValue = Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("float", e);
            }
        }
        if (returnType.getName().equals(Double.TYPE.getName())) {
            try {
                returnValue = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("double", e);
            }
        }
        if (returnType.getName().equals(Boolean.TYPE.getName())) {
            returnValue = Boolean.parseBoolean(value);
        } else if (returnType.getName().equals(Character.TYPE.getName())) {
            if (value.length() != 1) {
                throw log.getInvalidCharValueException(value);
            }
            returnValue = Character.valueOf(value.charAt(0));
        } else if (returnType.getName().equals(String.class.getName())) {
            returnValue = value;
        } else if (returnType.getName().equals(Class.class.getName())) {
            returnValue = this.classLoadingHelper.loadClass(value, defaultPackage);
        } else {
            try {
                Class<?> enumClass = returnType;
                returnValue = Enum.valueOf(enumClass, value);
            }
            catch (ClassCastException e) {
                throw log.getInvalidReturnTypeException(returnType, e);
            }
        }
        return returnValue;
    }

    private Class<?>[] getGroups(GroupsType groupsType, String defaultPackage) {
        if (groupsType == null) {
            return new Class[0];
        }
        ArrayList<Class> groupList = CollectionHelper.newArrayList();
        for (String groupClass : groupsType.getValue()) {
            groupList.add(this.classLoadingHelper.loadClass(groupClass, defaultPackage));
        }
        return groupList.toArray(new Class[groupList.size()]);
    }

    private Class<? extends Payload>[] getPayload(PayloadType payloadType, String defaultPackage) {
        if (payloadType == null) {
            return new Class[0];
        }
        ArrayList<Class> payloadList = CollectionHelper.newArrayList();
        for (String groupClass : payloadType.getValue()) {
            Class<?> payload = this.classLoadingHelper.loadClass(groupClass, defaultPackage);
            if (!Payload.class.isAssignableFrom(payload)) {
                throw log.getWrongPayloadClassException(payload.getName());
            }
            payloadList.add(payload);
        }
        return payloadList.toArray(new Class[payloadList.size()]);
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

