/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.util;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.mail.template.ConfluenceMailQueueItem;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import io.moewe.atlassian.sdk.auiforms.FormService;
import io.moewe.atlassian.sdk.auiforms.exceptions.FormException;
import io.moewe.confluence.addons.awards.forms.GeneralConfiguration;
import io.moewe.confluence.addons.awards.services.KarmaUserManager;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
public class AwardsApplicationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AwardsApplicationManager.class);
    private final LocaleManager localeManager;
    private final FormatSettingsManager formatSettingsManager;
    private final ApplicationProperties applicationProperties;
    private final LocalNotificationService localNotificationService;
    private final I18nResolver i18nResolver;
    private final UserManager userManager;
    private final SettingsManager settingsManager;
    private final BootstrapManager bootstrapManager;
    private final MultiQueueTaskManager taskManager;
    public static final int CF_53_BUILDNUMER = 4527;
    public static final int CF_52_BUILDNUMER = 4396;
    public static final int CF_58_BUILDNUMER = 5983;
    private final UserAccessor userAccessor;
    private final KarmaUserManager karmaUserManager;
    private final FormService formService;

    @Inject
    public AwardsApplicationManager(@ComponentImport LocaleManager localeManager, @ComponentImport FormatSettingsManager formatSettingsManager, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport LocalNotificationService localNotificationService, @ComponentImport I18nResolver i18nResolver, @ComponentImport UserManager userManager, @ComponentImport SettingsManager settingsManager, @ComponentImport BootstrapManager bootstrapManager, @ComponentImport @Qualifier(value="multiQueueTaskManager") MultiQueueTaskManager taskManager, @ComponentImport UserAccessor userAccessor, KarmaUserManager karmaUserManager, FormService formService) {
        this.localeManager = localeManager;
        this.formatSettingsManager = formatSettingsManager;
        this.applicationProperties = applicationProperties;
        this.localNotificationService = localNotificationService;
        this.i18nResolver = i18nResolver;
        this.userManager = userManager;
        this.settingsManager = settingsManager;
        this.bootstrapManager = bootstrapManager;
        this.taskManager = taskManager;
        this.userAccessor = userAccessor;
        this.karmaUserManager = karmaUserManager;
        this.formService = formService;
    }

    public String getContextPath() {
        return this.applicationProperties.getBaseUrl();
    }

    protected GeneralConfiguration getGeneralConfiguration() {
        try {
            return this.formService.getForm(GeneralConfiguration.class);
        }
        catch (FormException e) {
            LOGGER.error("Error while retrieving general configuration form", (Throwable)e);
            return null;
        }
    }

    public DateFormatter getDateFormatter() {
        return new DateFormatter(this.getUserTimeZone(), this.formatSettingsManager, this.localeManager);
    }

    public void sendNotification(ConfluenceUser messageUser, User targetUser, String groupkey, String title, String messagetitle, String message) {
        try {
            if (messageUser != null && this.karmaUserManager.isKarmaParticipant(this.karmaUserManager.getKarmaUser(messageUser))) {
                User userProfile;
                NotificationBuilder notificationBuilder = new NotificationBuilder().application("de.communardo.confluence.plugins.karma").user(messageUser.getName()).title(title != null ? title : this.i18nResolver.getText("communardo.karma.notification.title")).itemTitle(messagetitle).description(message).groupingId("de.communardo.confluence.plugins.karma.notification" + groupkey).itemIconUrl(this.getContextPath() + "/download/resources/de.communardo.confluence.plugins.karma:karma-overview-ressources/images/marketing/karma-icon.svg");
                Object object = userProfile = targetUser != null ? targetUser : messageUser;
                if (userProfile != null) {
                    ProfilePictureInfo profilePictureInfo = this.userAccessor.getUserProfilePicture(targetUser);
                    notificationBuilder.iconUrl(this.getContextPath() + profilePictureInfo.getDownloadPath());
                    notificationBuilder.itemUrl(this.getContextPath() + "/plugins/servlet/karma/overview/show?username=" + userProfile.getName());
                }
                this.localNotificationService.createOrUpdate(messageUser.getName(), notificationBuilder.createNotification()).get();
                GeneralConfiguration.NotificationMailRecipient notificationMailRecipient = this.getGeneralConfiguration().getNotificationMailRecipient();
                if (GeneralConfiguration.NotificationMailRecipient.ALL.equals((Object)notificationMailRecipient) || GeneralConfiguration.NotificationMailRecipient.CUSTOM.equals((Object)notificationMailRecipient) && this.karmaUserManager.isKarmaMailReciever(this.karmaUserManager.getKarmaUser(messageUser))) {
                    ConfluenceMailQueueItem mailQueueItem = new ConfluenceMailQueueItem(messageUser.getEmail(), messagetitle, message, "text/html");
                    this.taskManager.addTask("mail", () -> AwardsApplicationManager.lambda$sendNotification$37df2578$1((MailQueueItem)mailQueueItem));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to sent a notification because of: " + e.getMessage(), (Throwable)e);
        }
    }

    public TimeZone getUserTimeZone() {
        return this.getUserTimeZone(this.userManager.getRemoteUser().getUserKey());
    }

    public TimeZone getUserTimeZone(UserKey userKey) {
        ConfluenceUser user = this.userAccessor.getUserByKey(userKey);
        if (this.bootstrapManager.isSetupComplete() && user != null) {
            return this.userAccessor.getConfluenceUserPreferences((User)user).getTimeZone();
        }
        return TimeZone.getInstance((String)this.settingsManager.getGlobalSettings().getDefaultTimezoneId());
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public String getStandardProfilePictureUrl() {
        return "/images/icons/profilepics/default.png";
    }

    public boolean isAfterAtlassianUserkeyChange() {
        int buildNumber = Integer.parseInt(GeneralUtil.getBuildNumber());
        return buildNumber >= 4527;
    }

    private static /* synthetic */ void lambda$sendNotification$37df2578$1(MailQueueItem mailQueueItem) throws Exception {
        mailQueueItem.send();
    }
}

