/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.servlet;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import io.moewe.atlassian.sdk.auiforms.FormService;
import io.moewe.atlassian.sdk.internal.license.MoeweLicenseService;
import io.moewe.confluence.addons.awards.KarmaScore;
import io.moewe.confluence.addons.awards.KarmaUserProfile;
import io.moewe.confluence.addons.awards.TimeFrame;
import io.moewe.confluence.addons.awards.services.BadgeManager;
import io.moewe.confluence.addons.awards.services.KarmaEventManager;
import io.moewe.confluence.addons.awards.services.KarmaHistoryManager;
import io.moewe.confluence.addons.awards.services.KarmaPropertyManager;
import io.moewe.confluence.addons.awards.services.KarmaScoreManager;
import io.moewe.confluence.addons.awards.services.KarmaUserManager;
import io.moewe.confluence.addons.awards.services.MedalManager;
import io.moewe.confluence.addons.awards.services.UserAwardsService;
import io.moewe.confluence.addons.awards.servlet.AwardsServlet;
import io.moewe.confluence.addons.awards.util.Pager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class AwardsRankingServlet
extends AwardsServlet {
    private static final long serialVersionUID = 1L;

    public AwardsRankingServlet(@ComponentImport TemplateRenderer templateRenderer, @ComponentImport PageBuilderService pageBuilderService, @ComponentImport I18nResolver i18nResolver, KarmaEventManager karmaEventManager, @ComponentImport UserManager userManager, BadgeManager badgeManager, MedalManager medalManager, KarmaUserManager karmaUserManager, KarmaPropertyManager karmaPropertyManager, KarmaHistoryManager karmaHistoryManager, KarmaScoreManager karmaScoreManager, @ComponentImport PluginAccessor pluginAccessor, UserAwardsService userAwardsService, MoeweLicenseService licenseService, FormService formService) {
        super(templateRenderer, pageBuilderService, i18nResolver, karmaEventManager, userManager, badgeManager, medalManager, karmaUserManager, karmaPropertyManager, karmaHistoryManager, karmaScoreManager, pluginAccessor, userAwardsService, licenseService, formService);
    }

    public void initialize(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String users = request.getParameter("users");
        String pagesize = request.getParameter("pagesize");
        String timeFrameString = request.getParameter("timeframe");
        TimeFrame timeframe = TimeFrame.valueOf(timeFrameString);
        int pageSizeInteger = Integer.parseInt(pagesize);
        ArrayList<KarmaUserProfile> userFilterList = new ArrayList<KarmaUserProfile>();
        if (!StringUtils.isBlank((String)users)) {
            String[] userSplit;
            for (String currentUser : userSplit = users.split(",")) {
                KarmaUserProfile karmaUserFromUsername = this.karmaUserManager.getKarmaUserFromUsername(currentUser);
                if (karmaUserFromUsername == null) continue;
                userFilterList.add(karmaUserFromUsername);
            }
        }
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        String remoteUsername = this.userManager.getRemoteUsername();
        KarmaUserProfile karmaUserFromUsername = this.karmaUserManager.getKarmaUserFromUsername(remoteUsername);
        String contextUserName = request.getParameter("contextUsername");
        if (!StringUtils.isBlank((String)contextUserName)) {
            karmaUserFromUsername = this.karmaUserManager.getKarmaUserFromUsername(contextUserName);
        }
        velocityContext.put("userManager", this.userManager);
        velocityContext.put("currentKarmaUser", karmaUserFromUsername);
        velocityContext.put("userProfile", karmaUserFromUsername);
        velocityContext.put("userAwardsService", this.userAwardsService);
        velocityContext.put("unit", this.getGeneralConfiguration().getUnit());
        String pageindexString = request.getParameter("pageindex");
        if (!StringUtils.isBlank((String)pageindexString)) {
            velocityContext.put("pager", this.karmaScoreManager.getKarmaUserRanking(Integer.parseInt(pageindexString), pageSizeInteger, userFilterList, timeframe));
        } else {
            Pager<KarmaScore> karmaUserRanking = this.karmaScoreManager.getKarmaUserRanking(karmaUserFromUsername, pageSizeInteger, userFilterList, timeframe);
            if (karmaUserRanking.getPageElements() == null) {
                karmaUserRanking = this.karmaScoreManager.getKarmaUserRanking(1, pageSizeInteger, userFilterList, timeframe);
            }
            velocityContext.put("pager", karmaUserRanking);
        }
        this.renderVelocity(request, response, "vm/karmaranking.vm", velocityContext);
    }
}

