/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.tx.Transactional;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import io.moewe.atlassian.sdk.auiforms.FormService;
import io.moewe.atlassian.sdk.auiforms.exceptions.FormException;
import io.moewe.atlassian.sdk.internal.license.MoeweLicenseService;
import io.moewe.confluence.addons.awards.AwardsEvent;
import io.moewe.confluence.addons.awards.KarmaUserProfile;
import io.moewe.confluence.addons.awards.Medal;
import io.moewe.confluence.addons.awards.ao.AchievementEntity;
import io.moewe.confluence.addons.awards.ao.KarmaUser;
import io.moewe.confluence.addons.awards.ao.MedalDao;
import io.moewe.confluence.addons.awards.forms.AchievementSettings;
import io.moewe.confluence.addons.awards.notifications.MedalNotification;
import io.moewe.confluence.addons.awards.rest.pojo.Achievement;
import io.moewe.confluence.addons.awards.rest.pojo.parameter.AchievementProcessorParameter;
import io.moewe.confluence.addons.awards.rest.pojo.parameter.ProcessorParameter;
import io.moewe.confluence.addons.awards.services.AchievementService;
import io.moewe.confluence.addons.awards.services.KarmaNotificationManager;
import io.moewe.confluence.addons.awards.services.KarmaUserManager;
import io.moewe.confluence.addons.awards.services.ProcessorRunner;
import io.moewe.confluence.addons.awards.services.UserAwardsService;
import io.moewe.confluence.addons.awards.util.AwardsApplicationManager;
import io.moewe.confluence.addons.awards.util.AwardsHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@Named
public class MedalManager {
    private static final Logger LOGGER = Logger.getLogger(MedalManager.class);
    private final KarmaUserManager karmaUserManager;
    private final UserAwardsService userAwardsService;
    private final MoeweLicenseService licenseService;
    private final AchievementService achievementService;
    private final ActiveObjects activeObjects;
    private final AwardsApplicationManager awardsApplicationService;
    private final KarmaNotificationManager karmaNotificationManager;
    private final FormService formService;
    private final ProcessorRunner processorRunner;

    @Inject
    public MedalManager(KarmaUserManager karmaUserManager, @ComponentImport ActiveObjects activeObjects, AwardsApplicationManager awardsApplicationService, KarmaNotificationManager karmaNotificationManager, UserAwardsService userAwardsService, MoeweLicenseService licenseService, AchievementService achievementService, FormService formService, ProcessorRunner processorRunner) {
        this.userAwardsService = userAwardsService;
        this.licenseService = licenseService;
        this.achievementService = achievementService;
        this.karmaUserManager = karmaUserManager;
        this.activeObjects = activeObjects;
        this.awardsApplicationService = awardsApplicationService;
        this.karmaNotificationManager = karmaNotificationManager;
        this.formService = formService;
        this.processorRunner = processorRunner;
    }

    public boolean giveMedal(String achievementUuid, KarmaUserProfile givingKarmaUser, KarmaUserProfile recievingKarmaUser, String medalcomment) {
        if (givingKarmaUser == null || recievingKarmaUser == null) {
            LOGGER.error((Object)"Unable to award a medal because reciever or giver is not present");
            return false;
        }
        if (recievingKarmaUser.getKarmaUserDao().getID() == givingKarmaUser.getKarmaUserDao().getID() || !this.karmaUserManager.isKarmaParticipant(recievingKarmaUser) || !this.licenseService.isValid()) {
            return false;
        }
        Achievement achievement = this.achievementService.getAchievement(achievementUuid, false);
        if (achievement != null && this.getRemainingMedals(givingKarmaUser) > 0) {
            return (Boolean)this.activeObjects.executeInTransaction(() -> {
                Query query = Query.select().where("UUID = ? ", new Object[]{achievement.getUuid()});
                AchievementEntity[] achievementEntities = (AchievementEntity[])this.activeObjects.find(AchievementEntity.class, query);
                if (achievementEntities.length != 0) {
                    MedalDao medalDao = (MedalDao)this.activeObjects.create(MedalDao.class, new DBParam[0]);
                    medalDao.setAwardTime(System.currentTimeMillis());
                    medalDao.setDescription(medalcomment);
                    medalDao.setGivingKarmaUser(givingKarmaUser.getKarmaUserDao());
                    medalDao.setKarmaUser(recievingKarmaUser.getKarmaUserDao());
                    medalDao.setAchievement(achievementEntities[0]);
                    medalDao.save();
                    this.processorRunner.run((ProcessorParameter)new AchievementProcessorParameter(AwardsEvent.ACHIEVEMENT_ADDED, achievement, AwardsHelper.getUsername((User)this.userAwardsService.getUser(givingKarmaUser.getKarmaUserDao())), achievement.getName()), recievingKarmaUser);
                    this.karmaNotificationManager.addAchievementNotification(new MedalNotification(this.userAwardsService.getUser(recievingKarmaUser.getKarmaUserDao()), this.userAwardsService.getUser(givingKarmaUser.getKarmaUserDao()), achievement.getName(), achievement.getMetaData().getIconUrl(), medalcomment));
                    return true;
                }
                return false;
            });
        }
        return false;
    }

    public Integer getNumberOfMedalsPerDay() {
        try {
            AchievementSettings achievementSettings = this.formService.getForm(AchievementSettings.class);
            return achievementSettings.getMedalQuotaPerDay();
        }
        catch (FormException e) {
            LOGGER.error((Object)"Exception while saving general configuration form", (Throwable)e);
            return 2;
        }
    }

    @Transactional
    public int getRemainingMedals(KarmaUserProfile karmaUser) {
        List<Medal> userMedals = this.getMedalsGivenByUser(karmaUser);
        TimeZone wrappedTimeZone = this.awardsApplicationService.getUserTimeZone(this.userAwardsService.getUser(karmaUser.getKarmaUserDao()).getKey()).getWrappedTimeZone();
        Calendar calendar = Calendar.getInstance(wrappedTimeZone);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date beginningOfCurrentDay = calendar.getTime();
        SimpleDateFormat dateformat = new SimpleDateFormat("yyMMddHHmm");
        dateformat.setTimeZone(wrappedTimeZone);
        long beginningOfTheDay = Long.parseLong(dateformat.format(beginningOfCurrentDay));
        calendar.add(5, 1);
        Date beginningofNextDay = calendar.getTime();
        long beginningOfTheNextDay = Long.parseLong(dateformat.format(beginningofNextDay));
        int currentDayMedalCount = 0;
        Calendar medalEntryCalendar = Calendar.getInstance(wrappedTimeZone);
        for (int i = userMedals.size() - 1; i >= 0; --i) {
            medalEntryCalendar.setTimeInMillis(userMedals.get(i).getCreationDate().getTime());
            long medalCreationStamp = Long.parseLong(dateformat.format(medalEntryCalendar.getTime()));
            if (medalCreationStamp <= beginningOfTheDay || medalCreationStamp >= beginningOfTheNextDay) continue;
            ++currentDayMedalCount;
        }
        return this.getNumberOfMedalsPerDay() - currentDayMedalCount;
    }

    public List<Medal> getMedalsGivenByUser(KarmaUserProfile karmaUser) {
        ArrayList<Medal> medals = new ArrayList<Medal>();
        Query query = Query.select().from(MedalDao.class).join(KarmaUser.class, "GIVING_KARMA_USER_ID=KU.ID").alias(MedalDao.class, "ME").alias(KarmaUser.class, "KU").where("USER_KEY = ?", new Object[]{karmaUser.getUserKey()});
        for (MedalDao medalDao : (MedalDao[])this.activeObjects.find(MedalDao.class, query)) {
            Medal medal = this.convertDaoToViewObject(medalDao);
            if (medal == null) continue;
            medals.add(medal);
        }
        return medals;
    }

    private Medal convertDaoToViewObject(MedalDao dao) {
        Medal medal = null;
        Achievement achievement = AchievementService.convert(dao.getAchievement());
        if (achievement != null && achievement.isEnabled()) {
            KarmaUserProfile karmaUserProfile;
            medal = new Medal();
            medal.setAchievement(achievement);
            medal.setCreationDate(new Date(dao.getAwardTime()));
            medal.setDescription(dao.getDescription());
            if (dao.getGivingKarmaUser() != null && (karmaUserProfile = KarmaUserProfile.createKarmaUserProfile(dao.getGivingKarmaUser())) != null) {
                medal.setGiver(karmaUserProfile);
            }
            if (dao.getKarmaUser() != null && (karmaUserProfile = KarmaUserProfile.createKarmaUserProfile(dao.getKarmaUser())) != null) {
                medal.setUser(karmaUserProfile);
            }
        }
        return medal;
    }

    @Transactional
    public List<Medal> getUserMedals(KarmaUserProfile ... karmaUsers) {
        return this.getUserMedals(0, karmaUsers);
    }

    @Transactional
    public List<Medal> getUserMedals(int limit, KarmaUserProfile ... karmaUsers) {
        ArrayList<Medal> medals = new ArrayList<Medal>();
        Query query = Query.select().from(MedalDao.class).join(KarmaUser.class, "KARMA_USER_ID=KU.ID").alias(MedalDao.class, "ME").alias(KarmaUser.class, "KU");
        Object[] userKeys = new String[]{};
        if (karmaUsers != null) {
            for (KarmaUserProfile karmaUser : karmaUsers) {
                if (karmaUser == null) continue;
                userKeys = (String[])ArrayUtils.add((Object[])userKeys, (Object)karmaUser.getUserKey());
            }
        }
        if (userKeys.length > 0) {
            query = query.where("USER_KEY IN(?)", new Object[]{StringUtils.join((Object[])userKeys, (String)",")});
        }
        if (limit > 0) {
            query = query.limit(limit);
        }
        query = query.order("AWARD_TIME DESC");
        for (MedalDao medalDao : (MedalDao[])this.activeObjects.find(MedalDao.class, query)) {
            Medal medal = this.convertDaoToViewObject(medalDao);
            if (medal == null) continue;
            medals.add(medal);
        }
        return medals;
    }

    public Map<String, List<Medal>> getGroupedUserMedals(KarmaUserProfile ... karmaUser) {
        TreeMap<String, List<Medal>> resultMap = new TreeMap<String, List<Medal>>();
        for (Medal medal : this.getUserMedals(karmaUser)) {
            if (!medal.getAchievement().isEnabled()) continue;
            List currentMedalList = resultMap.computeIfAbsent(medal.getAchievement().getUuid(), k -> new ArrayList());
            currentMedalList.add(medal);
        }
        return resultMap;
    }
}

