/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import io.moewe.atlassian.sdk.auiforms.FormService;
import io.moewe.atlassian.sdk.auiforms.exceptions.FormException;
import io.moewe.confluence.addons.awards.KarmaUserProfile;
import io.moewe.confluence.addons.awards.ao.BadgeEntry;
import io.moewe.confluence.addons.awards.ao.KarmaEntry;
import io.moewe.confluence.addons.awards.ao.KarmaEntryMetadata;
import io.moewe.confluence.addons.awards.ao.KarmaHistoryEntry;
import io.moewe.confluence.addons.awards.ao.KarmaScoreDao;
import io.moewe.confluence.addons.awards.ao.KarmaUser;
import io.moewe.confluence.addons.awards.ao.MedalDao;
import io.moewe.confluence.addons.awards.forms.GeneralConfiguration;
import io.moewe.confluence.addons.awards.services.KarmaPropertyManager;
import io.moewe.confluence.addons.awards.services.UserAwardsService;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class KarmaUserManager {
    private static final String KARMAPROPERTY_KARMA_MAILS = "karma.mails.";
    private final ActiveObjects activeObjects;
    private final KarmaPropertyManager karmaPropertyManager;
    private final UserAccessor userAccessor;
    private final UserAwardsService userAwardsService;
    private final FormService formService;
    private final TransactionTemplate transactionTemplate;
    private static final Logger LOGGER = LoggerFactory.getLogger(KarmaUserManager.class);

    @Inject
    public KarmaUserManager(@ComponentImport ActiveObjects ao, KarmaPropertyManager karmaPropertyManager, @ComponentImport UserAccessor userAccessor, UserAwardsService userAwardsService, FormService formService, @ComponentImport TransactionTemplate transactionTemplate) {
        this.activeObjects = ao;
        this.karmaPropertyManager = karmaPropertyManager;
        this.userAccessor = userAccessor;
        this.userAwardsService = userAwardsService;
        this.formService = formService;
        this.transactionTemplate = transactionTemplate;
    }

    protected GeneralConfiguration getGeneralConfiguration() {
        try {
            return this.formService.getForm(GeneralConfiguration.class);
        }
        catch (FormException e) {
            LOGGER.error("Error while retrieving general configuration form", (Throwable)e);
            return null;
        }
    }

    private KarmaUserProfile createKarmaUser(ConfluenceUser confluenceUser) {
        if (confluenceUser == null) {
            return null;
        }
        UserKey keyForUsername = confluenceUser.getKey();
        String userKeyString = keyForUsername.getStringValue();
        KarmaUser karmaUser = (KarmaUser)this.activeObjects.create(KarmaUser.class, new DBParam[]{new DBParam("USER_KEY", (Object)userKeyString)});
        karmaUser.setParticipant(true);
        karmaUser.setActive(true);
        karmaUser.save();
        return KarmaUserProfile.createKarmaUserProfile(karmaUser);
    }

    public KarmaUserProfile getKarmaUser(ConfluenceUser confluenceUser) {
        if (confluenceUser == null) {
            return null;
        }
        UserKey keyForUsername = confluenceUser.getKey();
        String userKeyString = keyForUsername.getStringValue();
        if (StringUtils.isNotBlank((String)userKeyString)) {
            return (KarmaUserProfile)this.transactionTemplate.execute(() -> {
                KarmaUser[] karmaUsersFromDB = (KarmaUser[])this.activeObjects.find(KarmaUser.class, Query.select().where("USER_KEY = ?", new Object[]{userKeyString}).order("ID ASC"));
                if (karmaUsersFromDB.length > 0) {
                    KarmaUserProfile karmaUserProfile = KarmaUserProfile.createKarmaUserProfile(karmaUsersFromDB[0]);
                    if (karmaUsersFromDB.length > 1) {
                        LOGGER.debug("Duplicate user found... cleaning up.");
                        for (int i = 1; i < karmaUsersFromDB.length; ++i) {
                            this.deleteUser(karmaUsersFromDB[i]);
                        }
                    }
                    return karmaUserProfile;
                }
                return this.createKarmaUser(confluenceUser);
            });
        }
        return null;
    }

    public void deleteUser(KarmaUserProfile karmaUserProfile) {
        this.deleteUser(karmaUserProfile.getKarmaUserDao());
    }

    public void deleteUser(KarmaUser karmaUser) {
        KarmaEntry[] karmaEntries;
        LOGGER.debug("Deleting user: " + karmaUser.getUserKey());
        this.activeObjects.deleteWithSQL(BadgeEntry.class, "KARMA_USER_ID = ?", new Object[]{karmaUser.getID()});
        for (KarmaEntry karmaEntry : karmaEntries = (KarmaEntry[])this.activeObjects.find(KarmaEntry.class, Query.select().where("KARMA_USER_ID = ?", new Object[]{karmaUser.getID()}))) {
            for (KarmaEntryMetadata karmaEntryMetadata : karmaEntry.getKarmaEntryMetadata()) {
                this.activeObjects.delete(new RawEntity[]{karmaEntryMetadata});
            }
            this.activeObjects.delete(new RawEntity[]{karmaEntry});
        }
        this.activeObjects.deleteWithSQL(KarmaHistoryEntry.class, "KARMA_USER_ID = ?", new Object[]{karmaUser.getID()});
        this.activeObjects.deleteWithSQL(MedalDao.class, "KARMA_USER_ID = ? OR GIVING_KARMA_USER_ID = ?", new Object[]{karmaUser.getID(), karmaUser.getID()});
        this.activeObjects.deleteWithSQL(KarmaScoreDao.class, "KARMA_USER_ID = ?", new Object[]{karmaUser.getID()});
        this.activeObjects.delete(new RawEntity[]{karmaUser});
    }

    public void setRecieveMails(KarmaUserProfile karmaUser, boolean flag) {
        if (karmaUser != null) {
            if (karmaUser.getKarmaUserDao() == null) {
                karmaUser = this.createKarmaUser(this.userAwardsService.getUser(karmaUser.getKarmaUserDao()));
            }
            this.karmaPropertyManager.setKarmaProperty(KARMAPROPERTY_KARMA_MAILS + karmaUser.getKarmaUserDao().getID(), flag + "");
        }
    }

    public boolean isKarmaMailReciever(KarmaUserProfile karmaUser) {
        if (karmaUser != null) {
            if (karmaUser.getKarmaUserDao() != null) {
                String karmaProperty = this.karmaPropertyManager.getKarmaProperty(KARMAPROPERTY_KARMA_MAILS + karmaUser.getKarmaUserDao().getID());
                return karmaProperty == null || "true".equals(karmaProperty);
            }
            return true;
        }
        return false;
    }

    public boolean isKarmaParticipant(KarmaUserProfile karmaUser) {
        GeneralConfiguration generalConfiguration = this.getGeneralConfiguration();
        if (generalConfiguration != null && generalConfiguration.getParticipation().equals((Object)GeneralConfiguration.Participation.CUSTOM)) {
            return karmaUser.isKarmaParticipant();
        }
        return true;
    }

    public List<KarmaUserProfile> getKarmaUsers(String ... userKeys) {
        KarmaUser[] karmaUsersFromDB;
        ArrayList<KarmaUserProfile> resultList = new ArrayList<KarmaUserProfile>();
        Query query = Query.select();
        if (userKeys != null && userKeys.length > 0) {
            query.where("PARTICIPANT = ? AND USERKEY IN ?", new Object[]{Boolean.TRUE, userKeys});
        } else {
            query = query.where("PARTICIPANT = ?", new Object[]{Boolean.TRUE});
        }
        for (KarmaUser karmaUser : karmaUsersFromDB = (KarmaUser[])this.activeObjects.find(KarmaUser.class, query)) {
            KarmaUserProfile karmaUserProfile = KarmaUserProfile.createKarmaUserProfile(karmaUser);
            if (karmaUserProfile == null) continue;
            resultList.add(karmaUserProfile);
        }
        return resultList;
    }

    public void setParticipateInKarma(KarmaUserProfile karmaUser, boolean flag) {
        karmaUser.getKarmaUserDao().setParticipant(flag);
        karmaUser.getKarmaUserDao().save();
    }

    public KarmaUserProfile getKarmaUserFromUsername(String username) {
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(username);
        return confluenceUser != null ? this.getKarmaUser(confluenceUser) : null;
    }

    public void setUserActive(KarmaUserProfile karmaUser, boolean flag) {
        karmaUser.getKarmaUserDao().setActive(flag);
        karmaUser.getKarmaUserDao().save();
    }
}

