/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import io.moewe.confluence.addons.awards.KarmaScore;
import io.moewe.confluence.addons.awards.KarmaUserProfile;
import io.moewe.confluence.addons.awards.TimeFrame;
import io.moewe.confluence.addons.awards.ao.KarmaEntry;
import io.moewe.confluence.addons.awards.ao.KarmaScoreDao;
import io.moewe.confluence.addons.awards.ao.KarmaUser;
import io.moewe.confluence.addons.awards.util.AwardsHelper;
import io.moewe.confluence.addons.awards.util.Pager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class KarmaScoreManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AwardsHelper.class);
    private final ActiveObjects ao;
    private final TransactionTemplate transactionTemplate;

    @Inject
    public KarmaScoreManager(@ComponentImport ActiveObjects ao, @ComponentImport TransactionTemplate transactionTemplate) {
        this.ao = ao;
        this.transactionTemplate = transactionTemplate;
    }

    public boolean calculateUserScore() {
        return (Boolean)this.transactionTemplate.execute(() -> {
            KarmaScoreDao[] result;
            Query query = Query.select().where("RESCORE = ?", new Object[]{Boolean.TRUE});
            for (KarmaScoreDao karmaScoreDao : result = (KarmaScoreDao[])this.ao.find(KarmaScoreDao.class, query)) {
                this.calculateUserScore(karmaScoreDao);
            }
            return result.length > 0;
        });
    }

    private void calculateUserScore(KarmaScoreDao karmaScoreDao) {
        if (karmaScoreDao == null) {
            return;
        }
        long yearStamp = this.getTimeFrameFromstamp(TimeFrame.YEAR);
        long monthStamp = this.getTimeFrameFromstamp(TimeFrame.MONTH);
        long weekStamp = this.getTimeFrameFromstamp(TimeFrame.WEEK);
        long dayStamp = this.getTimeFrameFromstamp(TimeFrame.DAY);
        KarmaUser karmaUser = karmaScoreDao.getKarmaUser();
        Query query = Query.select().where("KARMA_USER_ID = ? AND CREATION_TIME > ?", new Object[]{karmaUser.getID(), karmaScoreDao.getLastEventDate()}).order("CREATION_TIME ASC");
        KarmaEntry[] result = (KarmaEntry[])this.ao.find(KarmaEntry.class, query);
        long lastEventStamp = karmaScoreDao.getLastEventDate();
        int totalScore = karmaScoreDao.getOverallScore();
        int karmaYearScore = lastEventStamp > yearStamp ? karmaScoreDao.getYearScore() : 0;
        int karmaMonthScore = lastEventStamp > monthStamp ? karmaScoreDao.getMonthScore() : 0;
        int karmaWeekScore = lastEventStamp > weekStamp ? karmaScoreDao.getWeekScore() : 0;
        int karmaDayScore = lastEventStamp > dayStamp ? karmaScoreDao.getDayScore() : 0;
        for (KarmaEntry karmaEntry : result) {
            long creationTime = karmaEntry.getCreationTime();
            int karma = karmaEntry.getKarma();
            lastEventStamp = karmaEntry.getCreationTime();
            totalScore += karma;
            if (creationTime >= yearStamp) {
                karmaYearScore += karma;
            }
            if (creationTime >= monthStamp) {
                karmaMonthScore += karma;
            }
            if (creationTime >= weekStamp) {
                karmaWeekScore += karma;
            }
            if (creationTime < dayStamp) continue;
            karmaDayScore += karma;
        }
        karmaScoreDao.setDayScore(Math.max(karmaDayScore, 0));
        karmaScoreDao.setWeekScore(Math.max(karmaWeekScore, 0));
        karmaScoreDao.setMonthScore(Math.max(karmaMonthScore, 0));
        karmaScoreDao.setYearScore(Math.max(karmaYearScore, 0));
        karmaScoreDao.setOverallScore(Math.max(totalScore, 0));
        karmaScoreDao.setLastUpdated(System.currentTimeMillis());
        karmaScoreDao.setLastEventDate(lastEventStamp);
        karmaScoreDao.setRescore(false);
        karmaScoreDao.save();
    }

    public KarmaUserProfile getKarmaLeader(TimeFrame timeframe) {
        return (KarmaUserProfile)this.transactionTemplate.execute(() -> {
            KarmaScoreDao[] karmaScoresFromDB = (KarmaScoreDao[])this.ao.find(KarmaScoreDao.class, Query.select().from(KarmaScoreDao.class).alias(KarmaScoreDao.class, "SC").join(KarmaUser.class, "KARMA_USER_ID=KU.ID").alias(KarmaUser.class, "KU").where("ACTIVE = ? AND PARTICIPANT = ? AND LAST_UPDATED >= ? " + (timeframe != TimeFrame.OVERALL ? "AND " + (Object)((Object)timeframe) + "_SCORE > 0 " : ""), new Object[]{Boolean.TRUE, Boolean.TRUE, this.getTimeFrameFromstamp(timeframe)}).order((Object)((Object)timeframe) + "_SCORE DESC").limit(1));
            List<KarmaScore> convertedList = this.internalDaoToTransferObject(timeframe, karmaScoresFromDB);
            return convertedList.size() > 0 ? convertedList.get(0).getKarmaUserProfile() : null;
        });
    }

    public KarmaScoreDao getOrCreateKarmaScoreDao(KarmaUser karmaUserDao) {
        try {
            KarmaScoreDao scoreResult = null;
            if (karmaUserDao != null) {
                KarmaScoreDao[] karmaScoresFromDB = (KarmaScoreDao[])this.ao.find(KarmaScoreDao.class, Query.select().where("KARMA_USER_ID = ?", new Object[]{karmaUserDao.getID()}).order("ID ASC"));
                if (karmaScoresFromDB.length == 0) {
                    KarmaScoreDao create = (KarmaScoreDao)this.ao.create(KarmaScoreDao.class, new DBParam[]{new DBParam("KARMA_USER_ID", (Object)karmaUserDao.getID())});
                    create.setRescore(true);
                    create.save();
                    scoreResult = create;
                } else {
                    scoreResult = karmaScoresFromDB[0];
                    if (karmaScoresFromDB.length > 1) {
                        LOGGER.debug("More than one score Object found for the user " + karmaUserDao.getUserKey());
                        for (int i = 1; i < karmaScoresFromDB.length; ++i) {
                            LOGGER.debug("Deleting score entry " + karmaScoresFromDB[i].getID());
                            this.ao.delete(new RawEntity[]{karmaScoresFromDB[i]});
                            LOGGER.debug("Deleting done");
                        }
                    }
                }
            }
            return scoreResult;
        }
        catch (Exception e) {
            LOGGER.debug("Someone is trying to create a score entry that already existed... skipping", (Throwable)e);
            return null;
        }
    }

    private long getTimeFrameFromstamp(TimeFrame timeFrame) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        switch (timeFrame) {
            case DAY: {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                break;
            }
            case WEEK: {
                calendar.set(7, calendar.getFirstDayOfWeek());
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                break;
            }
            case MONTH: {
                calendar.set(5, 1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                break;
            }
            case YEAR: {
                calendar.set(6, 1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                break;
            }
            default: {
                calendar.add(1, -99);
            }
        }
        return calendar.getTimeInMillis();
    }

    private KarmaScore internalDaoToTransferObject(KarmaScoreDao dao, TimeFrame timeFrame) {
        if (dao != null) {
            KarmaScore karmaScore;
            KarmaUser karmaUser = dao.getKarmaUser();
            KarmaUserProfile karmaDaoUserToKarmaUserProfile = KarmaUserProfile.createKarmaUserProfile(karmaUser);
            switch (timeFrame) {
                case YEAR: {
                    karmaScore = new KarmaScore(karmaDaoUserToKarmaUserProfile, dao.getYearScore());
                    break;
                }
                case MONTH: {
                    karmaScore = new KarmaScore(karmaDaoUserToKarmaUserProfile, dao.getMonthScore());
                    break;
                }
                case WEEK: {
                    karmaScore = new KarmaScore(karmaDaoUserToKarmaUserProfile, dao.getWeekScore());
                    break;
                }
                case DAY: {
                    karmaScore = new KarmaScore(karmaDaoUserToKarmaUserProfile, dao.getDayScore());
                    break;
                }
                default: {
                    karmaScore = new KarmaScore(karmaDaoUserToKarmaUserProfile, dao.getOverallScore());
                }
            }
            return karmaScore;
        }
        return null;
    }

    public Pager<KarmaScore> getKarmaUserRanking(int pageNumber, int usersPerPage, List<KarmaUserProfile> karmaUsersFilter, TimeFrame timeframe) {
        Pager<KarmaScore> returnPager = new Pager<KarmaScore>();
        returnPager.setElementsPerPage(usersPerPage);
        List<KarmaScore> filteredAndConvertedKarmaUserprofiles = this.internalGetKarmaUsersSortedByKarma(karmaUsersFilter, timeframe);
        int to = Math.min(pageNumber * usersPerPage, filteredAndConvertedKarmaUserprofiles.size());
        int from = Math.max(to - usersPerPage, 0);
        List<KarmaScore> subarray = filteredAndConvertedKarmaUserprofiles.subList(from, to);
        returnPager.setPageElements(subarray);
        returnPager.setCurrentPage(pageNumber);
        int modPage = filteredAndConvertedKarmaUserprofiles.size() % usersPerPage > 0 ? 1 : 0;
        returnPager.setPageCount(filteredAndConvertedKarmaUserprofiles.size() / usersPerPage + modPage);
        return returnPager;
    }

    private List<KarmaScore> internalGetKarmaUsersSortedByKarma(List<KarmaUserProfile> usersFilter, TimeFrame timeframe) {
        KarmaScoreDao[] karmaScoresFromDB;
        if (usersFilter != null && usersFilter.size() > 0) {
            ArrayList<Integer> userIdsToJoin = new ArrayList<Integer>();
            for (KarmaUserProfile userProfile : usersFilter) {
                userIdsToJoin.add(userProfile.getKarmaUserDao().getID());
            }
            karmaScoresFromDB = (KarmaScoreDao[])this.ao.find(KarmaScoreDao.class, Query.select().from(KarmaScoreDao.class).alias(KarmaScoreDao.class, "SC").join(KarmaUser.class, "KARMA_USER_ID=KU.ID").alias(KarmaUser.class, "KU").where("ACTIVE = ? AND PARTICIPANT = ? AND LAST_UPDATED >= ? AND " + (Object)((Object)timeframe) + "_SCORE > 0 AND KARMA_USER_ID IN (" + StringUtils.join(userIdsToJoin, (String)",") + ")", new Object[]{Boolean.TRUE, Boolean.TRUE, this.getTimeFrameFromstamp(timeframe)}).order((Object)((Object)timeframe) + "_SCORE DESC"));
        } else {
            karmaScoresFromDB = (KarmaScoreDao[])this.ao.find(KarmaScoreDao.class, Query.select().from(KarmaScoreDao.class).alias(KarmaScoreDao.class, "SC").join(KarmaUser.class, "KARMA_USER_ID=KU.ID").alias(KarmaUser.class, "KU").where("ACTIVE = ? AND PARTICIPANT = ? AND LAST_UPDATED >= ? AND " + (Object)((Object)timeframe) + "_SCORE > 0 ", new Object[]{Boolean.TRUE, Boolean.TRUE, this.getTimeFrameFromstamp(timeframe)}).order((Object)((Object)timeframe) + "_SCORE DESC"));
        }
        return this.internalDaoToTransferObject(timeframe, karmaScoresFromDB);
    }

    private List<KarmaScore> internalDaoToTransferObject(TimeFrame time, KarmaScoreDao[] karmaScoresFromDB) {
        ArrayList<KarmaScore> convertedList = new ArrayList<KarmaScore>();
        for (KarmaScoreDao karmaScoreDao : karmaScoresFromDB) {
            convertedList.add(this.internalDaoToTransferObject(karmaScoreDao, time));
        }
        return convertedList;
    }

    public Pager<KarmaScore> getKarmaUserRanking(KarmaUserProfile userProfile, int usersPerPage, List<KarmaUserProfile> karmaUsersFilter, TimeFrame timeframe) {
        Pager<KarmaScore> returnPager = new Pager<KarmaScore>();
        returnPager.setElementsPerPage(usersPerPage);
        List<KarmaScore> filteredAndConvertedKarmaUserprofiles = this.internalGetKarmaUsersSortedByKarma(karmaUsersFilter, timeframe);
        for (int i = 0; i < filteredAndConvertedKarmaUserprofiles.size(); ++i) {
            KarmaScore karmaScore = filteredAndConvertedKarmaUserprofiles.get(i);
            KarmaUserProfile karmaUserProfile = karmaScore.getKarmaUserProfile();
            String currentKarmaUserKey = karmaUserProfile.getUserKey();
            if (currentKarmaUserKey == null || userProfile == null || !currentKarmaUserKey.equals(userProfile.getUserKey())) continue;
            int pageNumber = i / usersPerPage + 1;
            int to = Math.min(pageNumber * usersPerPage, filteredAndConvertedKarmaUserprofiles.size());
            int from = Math.max(to - usersPerPage, 0);
            List<KarmaScore> subarray = filteredAndConvertedKarmaUserprofiles.subList(from, to);
            returnPager.setPageElements(subarray);
            returnPager.setCurrentPage(pageNumber);
            int modPage = filteredAndConvertedKarmaUserprofiles.size() % usersPerPage > 0 ? 1 : 0;
            returnPager.setPageCount(filteredAndConvertedKarmaUserprofiles.size() / usersPerPage + modPage);
            break;
        }
        return returnPager;
    }

    public Pager<KarmaScore> getKarmaUserRanking(int pageNumber, int usersPerPage, TimeFrame timeframe) {
        return this.getKarmaUserRanking(pageNumber, usersPerPage, null, timeframe);
    }

    public Pager<KarmaScore> getKarmaUserRanking(KarmaUserProfile userProfile, int usersPerPage, TimeFrame timeframe) {
        return this.getKarmaUserRanking(userProfile, usersPerPage, null, timeframe);
    }

    public KarmaScore getScore(KarmaUserProfile karmaUserProfile, TimeFrame timeFrame) {
        KarmaScoreDao karmaScoreDao = this.getOrCreateKarmaScoreDao(karmaUserProfile.getKarmaUserDao());
        return this.internalDaoToTransferObject(karmaScoreDao, timeFrame);
    }
}

