/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.moewe.confluence.addons.awards.ao.KarmaProperty;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;

@Named
public class KarmaPropertyManager {
    private final ActiveObjects ao;

    @Inject
    public KarmaPropertyManager(@ComponentImport ActiveObjects ao) {
        this.ao = ao;
    }

    public String getKarmaProperty(String key) {
        return (String)this.ao.executeInTransaction(() -> {
            KarmaProperty[] karmaProperties = (KarmaProperty[])this.ao.find(KarmaProperty.class, Query.select().where("KEY = ?", new Object[]{key}));
            return karmaProperties.length > 0 ? karmaProperties[0].getValue() : null;
        });
    }

    private KarmaProperty getInternalKarmaProperty(String key) {
        KarmaProperty[] karmaProperties = (KarmaProperty[])this.ao.find(KarmaProperty.class, Query.select().where("KEY = ?", new Object[]{key}));
        return karmaProperties.length > 0 ? karmaProperties[0] : null;
    }

    public void setKarmaProperty(String key, String value) {
        this.ao.executeInTransaction(() -> {
            KarmaProperty karmaProperty = this.getInternalKarmaProperty(key);
            if (karmaProperty == null) {
                karmaProperty = (KarmaProperty)this.ao.create(KarmaProperty.class, new DBParam[0]);
            }
            karmaProperty.setKey(key);
            karmaProperty.setValue(value);
            karmaProperty.save();
            return null;
        });
    }
}

