/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.services;

import com.atlassian.confluence.api.impl.pagination.PaginationQueryImpl;
import com.atlassian.confluence.internal.follow.FollowManagerInternal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.user.User;
import io.moewe.atlassian.sdk.auiforms.FormService;
import io.moewe.atlassian.sdk.auiforms.exceptions.FormException;
import io.moewe.confluence.addons.awards.forms.GeneralConfiguration;
import io.moewe.confluence.addons.awards.notifications.AchievementNotification;
import io.moewe.confluence.addons.awards.notifications.MedalNotification;
import io.moewe.confluence.addons.awards.util.AwardsApplicationManager;
import io.moewe.confluence.addons.awards.util.AwardsHelper;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.collections.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
public class KarmaNotificationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(KarmaNotificationManager.class);
    private final List<AchievementNotification> notificationQueue;
    private final AwardsApplicationManager awardsApplicationManager;
    private final I18nResolver i18nResolver;
    private final TemplateRenderer templateRenderer;
    private final UserAccessor userAccessor;
    private final FormService formService;
    private final FollowManagerInternal followManagerInternal;

    @Inject
    public KarmaNotificationManager(AwardsApplicationManager awardsApplicationManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport TemplateRenderer templateRenderer, @ComponentImport UserAccessor userAccessor, FormService formService, @ComponentImport(value="followManagerInternal") @Qualifier(value="followManagerInternal") FollowManagerInternal followManagerInternal) {
        this.awardsApplicationManager = awardsApplicationManager;
        this.i18nResolver = i18nResolver;
        this.templateRenderer = templateRenderer;
        this.userAccessor = userAccessor;
        this.formService = formService;
        this.followManagerInternal = followManagerInternal;
        this.notificationQueue = new ArrayList<AchievementNotification>();
    }

    public void flushKarmaNotifications() {
        if (this.notificationQueue.isEmpty()) {
            return;
        }
        Iterator<AchievementNotification> notifications = this.notificationQueue.iterator();
        while (notifications.hasNext()) {
            AchievementNotification karmaNotification = notifications.next();
            if (karmaNotification == null) continue;
            if (karmaNotification instanceof MedalNotification) {
                this.sendNotification((MedalNotification)karmaNotification);
            } else {
                this.sendNotification(karmaNotification);
            }
            notifications.remove();
        }
    }

    private void sendNotification(AchievementNotification achievementNotification) {
        if (achievementNotification != null) {
            HashMap<String, AchievementNotification> context = new HashMap<String, AchievementNotification>();
            StringWriter stringWriter = new StringWriter();
            context.put("notification", achievementNotification);
            try {
                this.templateRenderer.render("vm/notification.vm", context, (Writer)stringWriter);
                String parsedVmString = stringWriter.getBuffer().toString();
                stringWriter.close();
                ConfluenceUser user = achievementNotification.getReceiver();
                if (user != null) {
                    String fullName = AwardsHelper.getUsername((User)user);
                    String uniqueId = UUID.randomUUID().toString();
                    this.awardsApplicationManager.sendNotification(user, (User)user, uniqueId, this.i18nResolver.getText("communardo.karma.notification.badge.title", new Serializable[]{fullName}), this.i18nResolver.getText("communardo.karma.notification.badge.user", new Serializable[]{achievementNotification.getTitle()}), parsedVmString);
                    if (GeneralConfiguration.NotificationRecipient.FOLLOWER.equals((Object)this.getGeneralConfigurationNotificationRecipient())) {
                        List users = IteratorUtils.toList((Iterator)this.followManagerInternal.getFollowing(this.userAccessor.getUserByName(user.getName()), PaginationQueryImpl.newIdentityQuery(ConfluenceUser.class)).pagingIterator());
                        for (ConfluenceUser followerUser : users) {
                            this.awardsApplicationManager.sendNotification(followerUser, (User)user, uniqueId, this.i18nResolver.getText("communardo.karma.notification.badge.title", new Serializable[]{fullName}), this.i18nResolver.getText("communardo.karma.notification.badge.follower", new Serializable[]{fullName, achievementNotification.getTitle()}), parsedVmString);
                        }
                    } else if (GeneralConfiguration.NotificationRecipient.ALL.equals((Object)this.getGeneralConfigurationNotificationRecipient())) {
                        List usernamesWithConfluenceAccess = this.userAccessor.getUserNamesWithConfluenceAccess();
                        for (String currentUsername : usernamesWithConfluenceAccess) {
                            ConfluenceUser currentUser = this.userAccessor.getUserByName(currentUsername);
                            if (currentUser == null || currentUser.getName().equals(user.getName())) continue;
                            this.awardsApplicationManager.sendNotification(currentUser, (User)user, uniqueId, this.i18nResolver.getText("communardo.karma.notification.badge.title", new Serializable[]{fullName}), this.i18nResolver.getText("communardo.karma.notification.badge.follower", new Serializable[]{fullName, achievementNotification.getTitle()}), parsedVmString);
                        }
                    }
                } else {
                    LOGGER.error("Unable to send Badgemessage because null user was given");
                }
            }
            catch (Exception e) {
                LOGGER.error("Error during badge notification because: " + e.getMessage());
            }
        }
    }

    private GeneralConfiguration.NotificationRecipient getGeneralConfigurationNotificationRecipient() throws FormException {
        return this.formService.getForm(GeneralConfiguration.class).getNotificationRecipient();
    }

    private void sendNotification(MedalNotification medalNotification) {
        if (medalNotification != null) {
            HashMap<String, MedalNotification> context = new HashMap<String, MedalNotification>();
            StringWriter stringWriter = new StringWriter();
            context.put("notification", medalNotification);
            try {
                this.templateRenderer.render("vm/notification.vm", context, (Writer)stringWriter);
                String parsedVmString = stringWriter.getBuffer().toString();
                stringWriter.close();
                ConfluenceUser receiver = medalNotification.getReceiver();
                ConfluenceUser giver = medalNotification.getGiver();
                if (receiver != null && giver != null) {
                    String receiverFullname = AwardsHelper.getUsername((User)receiver);
                    String giverFullname = AwardsHelper.getUsername((User)giver);
                    String uniqueId = UUID.randomUUID().toString();
                    this.awardsApplicationManager.sendNotification(receiver, (User)receiver, uniqueId, this.i18nResolver.getText("communardo.karma.notification.medal.title", new Serializable[]{receiverFullname, giverFullname}), this.i18nResolver.getText("communardo.karma.notification.medal.user", new Serializable[]{medalNotification.getTitle(), giverFullname}), parsedVmString);
                    if (this.getGeneralConfigurationNotificationRecipient().equals((Object)GeneralConfiguration.NotificationRecipient.FOLLOWER)) {
                        List users = IteratorUtils.toList((Iterator)this.followManagerInternal.getFollowing(this.userAccessor.getUserByName(receiver.getName()), PaginationQueryImpl.newIdentityQuery(ConfluenceUser.class)).pagingIterator());
                        for (ConfluenceUser followerUser : users) {
                            this.awardsApplicationManager.sendNotification(followerUser, (User)receiver, uniqueId, this.i18nResolver.getText("communardo.karma.notification.medal.title", new Serializable[]{receiverFullname, giverFullname}), this.i18nResolver.getText("communardo.karma.notification.medal.follower", new Serializable[]{receiverFullname, medalNotification.getTitle(), giverFullname}), parsedVmString);
                        }
                    } else if (this.getGeneralConfigurationNotificationRecipient().equals((Object)GeneralConfiguration.NotificationRecipient.ALL)) {
                        List usernamesWithConfluenceAccess = this.userAccessor.getUserNamesWithConfluenceAccess();
                        for (String currentUsername : usernamesWithConfluenceAccess) {
                            ConfluenceUser currentUser = this.userAccessor.getUserByName(currentUsername);
                            if (currentUser == null || currentUser.getName().equals(receiver.getName()) || currentUser.getName().equals(giver.getName())) continue;
                            this.awardsApplicationManager.sendNotification(currentUser, (User)receiver, uniqueId, this.i18nResolver.getText("communardo.karma.notification.medal.title", new Serializable[]{receiverFullname, giverFullname}), this.i18nResolver.getText("communardo.karma.notification.medal.follower", new Serializable[]{receiverFullname, medalNotification.getTitle(), giverFullname}), parsedVmString);
                        }
                    }
                } else {
                    LOGGER.error("Unable to send Badgemessage because of null user");
                }
            }
            catch (Exception e) {
                LOGGER.error("Error during badge notification because: " + e.getMessage());
            }
        }
    }

    public synchronized void addAchievementNotification(AchievementNotification achievementNotification) {
        for (AchievementNotification notification : this.notificationQueue) {
            if (!notification.equals(achievementNotification)) continue;
            return;
        }
        this.notificationQueue.add(achievementNotification);
    }
}

