/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.moewe.atlassian.sdk.internal.license.MoeweLicenseService;
import io.moewe.confluence.addons.awards.KarmaUserProfile;
import io.moewe.confluence.addons.awards.ao.AchievementEntity;
import io.moewe.confluence.addons.awards.ao.BadgeEntry;
import io.moewe.confluence.addons.awards.ao.KarmaUser;
import io.moewe.confluence.addons.awards.notifications.AchievementNotification;
import io.moewe.confluence.addons.awards.rest.pojo.Achievement;
import io.moewe.confluence.addons.awards.rest.pojo.parameter.ProcessorParameter;
import io.moewe.confluence.addons.awards.services.KarmaNotificationManager;
import io.moewe.confluence.addons.awards.services.KarmaUserManager;
import io.moewe.confluence.addons.awards.services.UserAwardsService;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class BadgeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BadgeManager.class);
    private final UserAwardsService userAwardsService;
    private final MoeweLicenseService licenseService;
    private final ActiveObjects activeObjects;
    private final KarmaUserManager karmaUserManager;
    private final KarmaNotificationManager karmaNotificationManager;

    @Inject
    public BadgeManager(@ComponentImport ActiveObjects activeObjects, KarmaUserManager karmaUserManager, KarmaNotificationManager karmaNotificationManager, UserAwardsService userAwardsService, MoeweLicenseService moeweLicenseService) {
        this.userAwardsService = userAwardsService;
        this.licenseService = moeweLicenseService;
        this.activeObjects = activeObjects;
        this.karmaUserManager = karmaUserManager;
        this.karmaNotificationManager = karmaNotificationManager;
    }

    public boolean awardBadge(KarmaUserProfile karmaUserProfile, Achievement achievement, ProcessorParameter processorParameter) {
        if (!this.licenseService.isValid()) {
            LOGGER.warn("License is invalid.");
            return false;
        }
        if (achievement == null) {
            LOGGER.warn("Achievement is not available");
            return false;
        }
        if (karmaUserProfile == null) {
            LOGGER.warn("Unable to award achievement uuid " + achievement.getUuid() + " because of null user");
            return false;
        }
        return (Boolean)this.activeObjects.executeInTransaction(() -> {
            if (!this.karmaUserManager.isKarmaParticipant(karmaUserProfile)) {
                LOGGER.warn("User is no awards participant.");
                return false;
            }
            Query query = Query.select().where("UUID = ? ", new Object[]{achievement.getUuid()});
            AchievementEntity[] achievementEntities = (AchievementEntity[])this.activeObjects.find(AchievementEntity.class, query);
            if (achievementEntities.length == 0) {
                LOGGER.warn("Achievement was not found");
                return false;
            }
            if (!achievementEntities[0].isEnabled()) {
                LOGGER.debug("Achievement is not active");
                return false;
            }
            BadgeEntry badgeEntry = this.getBadgeEntry(karmaUserProfile, achievementEntities[0], achievement.getMetaData().isUnique());
            if (achievement.getMetaData().isUnique() && badgeEntry.getKarmaUser() != null && badgeEntry.getKarmaUser().getID() == karmaUserProfile.getKarmaUserDao().getID()) {
                LOGGER.debug("Achievement is already assigned to the user.");
                return false;
            }
            badgeEntry.setKarmaUser(karmaUserProfile.getKarmaUserDao());
            double progressPercentage = badgeEntry.getProgressPercentage();
            int maximalSteps = achievement.getMetaData().getSteps();
            long lastStep = Math.round((double)maximalSteps * (progressPercentage / 100.0));
            int currentStep = Math.toIntExact(lastStep) + 1;
            progressPercentage = achievement.getMetaData().getSteps() != null && maximalSteps > 1 && currentStep < maximalSteps ? (progressPercentage += 100.0 / (double)maximalSteps) : 100.0;
            if (badgeEntry.getProgressPercentage() == progressPercentage) {
                LOGGER.debug("Progress to award achievement has not changed.");
                return false;
            }
            boolean awarded = false;
            if (progressPercentage >= 100.0) {
                badgeEntry.setProgressPercentage(100.0);
                badgeEntry.setAwardTime(System.currentTimeMillis());
                this.karmaNotificationManager.addAchievementNotification(new AchievementNotification(this.userAwardsService.getUser(karmaUserProfile.getKarmaUserDao()), achievement.getName(), achievement.getMetaData().getIconUrl(), achievement.getDescription()));
                awarded = true;
            } else {
                badgeEntry.setProgressPercentage(progressPercentage);
            }
            badgeEntry.save();
            return awarded;
        });
    }

    private BadgeEntry getBadgeEntry(KarmaUserProfile karmaUserProfile, AchievementEntity achievementEntity, boolean isUnique) {
        BadgeEntry[] badgesFromDB = this.getUserBadgeEntries(isUnique ? null : karmaUserProfile, achievementEntity);
        if (badgesFromDB.length > 0) {
            return badgesFromDB[0];
        }
        BadgeEntry badgeEntry = (BadgeEntry)this.activeObjects.create(BadgeEntry.class, new DBParam[0]);
        badgeEntry.setAchievement(achievementEntity);
        return badgeEntry;
    }

    private BadgeEntry[] getUserBadgeEntries(KarmaUserProfile karmaUser, AchievementEntity achievementEntity) {
        Query query = Query.select().from(BadgeEntry.class).alias(BadgeEntry.class, "BE");
        query = karmaUser != null ? query.join(KarmaUser.class, "KARMA_USER_ID=KU.ID").alias(KarmaUser.class, "KU").where("BE.KARMA_USER_ID = ? AND BE.ACHIEVEMENT_ID = ?", new Object[]{karmaUser.getKarmaUserDao().getID(), achievementEntity.getID()}) : query.where("BE.ACHIEVEMENT_ID = ?", new Object[]{achievementEntity.getID()});
        return (BadgeEntry[])this.activeObjects.find(BadgeEntry.class, query);
    }

    public BadgeEntry[] getUserBadges(KarmaUserProfile user) {
        Query query = Query.select().from(BadgeEntry.class).join(KarmaUser.class, "KARMA_USER_ID=KU.ID").alias(BadgeEntry.class, "BE").alias(KarmaUser.class, "KU").where("USER_KEY = ?", new Object[]{user.getUserKey()});
        return (BadgeEntry[])this.activeObjects.find(BadgeEntry.class, query);
    }
}

