/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.rest.pojo.input.events.confluence;

import com.atlassian.confluence.event.events.security.SecurityEvent;
import io.moewe.atlassian.sdk.auiforms.annotation.SchemeConfig;
import io.moewe.confluence.addons.awards.AwardsEvent;
import io.moewe.confluence.addons.awards.rest.pojo.input.events.confluence.ConfluenceEventInput;
import io.moewe.confluence.addons.awards.rest.pojo.parameter.ProcessorParameter;
import java.text.SimpleDateFormat;
import java.time.LocalTime;

public class SecurityEventInput
extends ConfluenceEventInput {
    @SchemeConfig(variant=SchemeConfig.Variant.TIME, width=SchemeConfig.Width.MEDIUM)
    private String minTime;
    @SchemeConfig(variant=SchemeConfig.Variant.TIME, width=SchemeConfig.Width.MEDIUM)
    private String maxTime;

    public SecurityEventInput() {
        super(new AwardsEvent[]{AwardsEvent.LOGIN, AwardsEvent.LOGOUT});
    }

    @Override
    public boolean isValid(ProcessorParameter processorParameter) {
        if (super.isValid(processorParameter) && processorParameter.getConfluenceEvent() instanceof SecurityEvent) {
            LocalTime min = null;
            LocalTime max = null;
            if (this.minTime != null && !this.minTime.isEmpty()) {
                min = LocalTime.parse(this.minTime + ":00");
            }
            if (this.maxTime != null && !this.maxTime.isEmpty()) {
                max = LocalTime.parse(this.maxTime + ":59");
            }
            if (min == null && max == null) {
                return true;
            }
            if (min == null) {
                return this.getCurrentLocalTime(processorParameter).isBefore(max);
            }
            if (max == null) {
                return this.getCurrentLocalTime(processorParameter).isAfter(min);
            }
            LocalTime currentTime = this.getCurrentLocalTime(processorParameter);
            if (min.isAfter(max)) {
                return currentTime.compareTo(min) >= 0 || currentTime.compareTo(max) < 0;
            }
            return min.compareTo(currentTime) <= 0 && currentTime.compareTo(max) < 0;
        }
        return false;
    }

    private LocalTime getCurrentLocalTime(ProcessorParameter processorParameter) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        simpleDateFormat.setLenient(false);
        simpleDateFormat.setTimeZone(processorParameter.getKarmaUserTimezone().getWrappedTimeZone());
        return LocalTime.parse(simpleDateFormat.format(System.currentTimeMillis()));
    }

    public String getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(String maxTime) {
        this.maxTime = maxTime;
    }

    public String getMinTime() {
        return this.minTime;
    }

    public void setMinTime(String minTime) {
        this.minTime = minTime;
    }
}

