/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.rest;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import io.moewe.atlassian.sdk.auiforms.Form;
import io.moewe.atlassian.sdk.auiforms.rest.entities.controller.FormController;
import io.moewe.atlassian.sdk.auiforms.rest.entities.fields.select2.AutocompleteOption;
import io.moewe.atlassian.sdk.auiforms.rest.entities.fields.select2.AutocompleteResults;
import io.moewe.confluence.addons.awards.AchievementType;
import io.moewe.confluence.addons.awards.rest.pojo.Achievement;
import io.moewe.confluence.addons.awards.services.AchievementService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/achievements")
@Produces(value={"application/json"})
public class AchievementResource
extends FormController {
    private final AchievementService achievementService;

    public AchievementResource(AchievementService achievementService, @ComponentImport I18nResolver i18nResolver, @ComponentImport UserManager userManager) {
        super(i18nResolver, userManager, Achievement.class);
        this.achievementService = achievementService;
    }

    @GET
    @Path(value="/autocomplete/{uuid}")
    public Response getAutocompleteOption(@PathParam(value="uuid") String uuid) {
        Achievement achievement = this.achievementService.getAchievement(uuid, true);
        if (achievement == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(null).build();
        }
        try {
            return Response.ok((Object)MAPPER.writeValueAsString(this.getAutocompleteOption(achievement))).build();
        }
        catch (JsonProcessingException e) {
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/autocomplete/")
    public Response getAutocompleteAchievements(@QueryParam(value="term") String term) {
        List<Achievement> achievements = this.achievementService.getAchievements(true, AchievementType.BADGE, term);
        if (achievements != null) {
            ArrayList<AutocompleteOption> autocompleteOptions = new ArrayList<AutocompleteOption>();
            achievements.forEach(achievement -> autocompleteOptions.add(this.getAutocompleteOption((Achievement)achievement)));
            try {
                return Response.ok((Object)MAPPER.writeValueAsString(new AutocompleteResults(autocompleteOptions))).build();
            }
            catch (Exception e) {
                return Response.serverError().build();
            }
        }
        return Response.ok().build();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response addAchievement(Achievement achievement) {
        Achievement newAchievement = this.achievementService.addAchievement(achievement);
        return this.buildAchievementResponse(newAchievement);
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response updateAchievement(Achievement achievement) {
        Achievement updatedAchievement = this.achievementService.updateAchievement(achievement);
        return this.buildAchievementResponse(updatedAchievement);
    }

    @DELETE
    @Path(value="/{uuid}")
    public Response deleteAchievement(@PathParam(value="uuid") String uuid) {
        this.achievementService.deleteAchievement(uuid);
        return Response.ok(null).build();
    }

    @GET
    public Response getAchievements(@QueryParam(value="includeDisabled") Boolean includeDisabled, @QueryParam(value="type") String type) {
        List<Achievement> achievements = this.achievementService.getAchievements(includeDisabled != null && includeDisabled != false, AchievementType.MEDAL.name().equals(type) ? AchievementType.MEDAL : AchievementType.BADGE, null);
        if (achievements != null) {
            try {
                return Response.ok((Object)MAPPER.writerFor(new TypeReference<List<Achievement>>(){}).writeValueAsString(achievements)).build();
            }
            catch (Exception e) {
                return Response.serverError().build();
            }
        }
        return Response.serverError().build();
    }

    private Response buildAchievementResponse(Achievement achievement) {
        if (achievement.getUuid() == null) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity(null).build();
        }
        try {
            String responseBody = MAPPER.writeValueAsString(achievement);
            return Response.ok((Object)responseBody).build();
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
    }

    @Override
    public Form getForm(String id) {
        return this.achievementService.getAchievement(id, true);
    }

    @Override
    public Form saveForm(Form form) {
        if (form instanceof Achievement) {
            Achievement achievement = (Achievement)form;
            if (achievement.getUuid() == null || "".equals(achievement.getUuid().trim())) {
                return this.achievementService.addAchievement((Achievement)form);
            }
            return this.achievementService.updateAchievement((Achievement)form);
        }
        return null;
    }

    private AutocompleteOption getAutocompleteOption(Achievement achievement) {
        String titlePrefix = "";
        if (achievement.getMetaData() != null) {
            String iconUrl;
            if (!achievement.isEnabled()) {
                titlePrefix = titlePrefix + "<span class=\"aui-lozenge aui-lozenge-subtle\">Disabled</span> ";
            }
            if ((iconUrl = achievement.getMetaData().getIconUrl()) != null && !iconUrl.trim().isEmpty()) {
                titlePrefix = titlePrefix + "<img src=\"" + iconUrl.trim() + "\" width=\"15px;\" >";
            }
        }
        return new AutocompleteOption(achievement.getUuid(), titlePrefix + ' ' + achievement.getName(), true, !achievement.isEnabled());
    }
}

