/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.migration;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.sal.api.user.UserManager;
import io.moewe.confluence.addons.awards.KarmaUserProfile;
import io.moewe.confluence.addons.awards.ao.KarmaProperty;
import io.moewe.confluence.addons.awards.ao.KarmaUser;
import io.moewe.confluence.addons.awards.services.UserAwardsService;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.log4j.Logger;

@Named
@ExportAsService
public class UserActiveStateMigrationTask
implements PluginUpgradeTask {
    private static final Logger LOGGER = Logger.getLogger(UserActiveStateMigrationTask.class);
    private final ActiveObjects ao;
    private final UserManager userManager;
    private static final String KARMAPROPERTY_KARMA_PARTICIPATION = "karma.participation.";
    private final UserAwardsService userAwardsService;

    @Inject
    public UserActiveStateMigrationTask(@ComponentImport ActiveObjects ao, @ComponentImport UserManager userManager, UserAwardsService userAwardsService) {
        this.ao = ao;
        this.userManager = userManager;
        this.userAwardsService = userAwardsService;
    }

    public Collection<Message> doUpgrade() {
        this.ao.executeInTransaction(() -> {
            KarmaProperty[] karmaProperties = (KarmaProperty[])this.ao.find(KarmaProperty.class, Query.select().where("KEY = ?", new Object[]{"usermigration.activestate.migration"}));
            boolean migrationDone = false;
            if (karmaProperties != null && karmaProperties.length > 0 && "true".equals(karmaProperties[0].getValue())) {
                migrationDone = true;
            }
            if (!migrationDone) {
                KarmaUser[] allKarmaUsers;
                LOGGER.warn((Object)"Running user active state migration..");
                for (KarmaUser karmaUser : allKarmaUsers = (KarmaUser[])this.ao.find(KarmaUser.class)) {
                    KarmaUserProfile karmaDaoUserToKarmaUserProfile = KarmaUserProfile.createKarmaUserProfile(karmaUser);
                    boolean activeUser = karmaDaoUserToKarmaUserProfile != null && this.userAwardsService.getUser(karmaDaoUserToKarmaUserProfile.getKarmaUserDao()) != null;
                    karmaUser.setActive(activeUser);
                    boolean karmaParticipant = this.isKarmaParticipant(karmaUser);
                    karmaUser.setParticipant(karmaParticipant);
                    karmaUser.save();
                    LOGGER.warn((Object)("User with id " + karmaUser.getID() + " migrated: activestate - " + activeUser + " is paticipant - " + karmaParticipant));
                }
                LOGGER.warn((Object)"User active state migration done.");
                assert (karmaProperties != null);
                KarmaProperty karmaProperty = karmaProperties.length > 0 ? karmaProperties[0] : (KarmaProperty)this.ao.create(KarmaProperty.class, new DBParam[0]);
                karmaProperty.setKey("usermigration.activestate.migration");
                karmaProperty.setValue("true");
                karmaProperty.save();
            }
            return null;
        });
        return new ArrayList<Message>();
    }

    private boolean isKarmaParticipant(KarmaUser karmaUser) {
        KarmaProperty[] karmaProperties = (KarmaProperty[])this.ao.find(KarmaProperty.class, Query.select().where("KEY = ?", new Object[]{KARMAPROPERTY_KARMA_PARTICIPATION + karmaUser.getID()}));
        boolean participant = true;
        if (karmaProperties != null && karmaProperties.length > 0 && "false".equals(karmaProperties[0].getValue())) {
            participant = false;
        }
        return participant;
    }

    public int getBuildNumber() {
        return 5983;
    }

    public String getPluginKey() {
        return "de.communardo.confluence.plugins.karma";
    }

    public String getShortDescription() {
        return "Initially create the ranking for each user.";
    }

    public ActiveObjects getAo() {
        return this.ao;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }
}

