/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.migration;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.usercompatibility.UserCompatibilityHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.sal.usercompatibility.UserKey;
import io.moewe.confluence.addons.awards.ao.KarmaProperty;
import io.moewe.confluence.addons.awards.ao.KarmaUser;
import io.moewe.confluence.addons.awards.util.AwardsApplicationManager;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.log4j.Logger;

@Named
@ExportAsService
public class MigrateUsernameToUserIdTask
implements PluginUpgradeTask {
    private static final Logger LOGGER = Logger.getLogger(MigrateUsernameToUserIdTask.class);
    private final ActiveObjects ao;
    private final AwardsApplicationManager karmaApplicationService;

    @Inject
    public MigrateUsernameToUserIdTask(@ComponentImport ActiveObjects ao, AwardsApplicationManager karmaApplicationService) {
        this.ao = ao;
        this.karmaApplicationService = karmaApplicationService;
    }

    public Collection<Message> doUpgrade() {
        this.ao.executeInTransaction(() -> {
            KarmaProperty[] karmaProperties = (KarmaProperty[])this.ao.find(KarmaProperty.class, Query.select().where("KEY = ?", new Object[]{"usermigration.username.to.userid"}));
            boolean userMigrationDone = false;
            if (karmaProperties != null && karmaProperties.length > 0 && "true".equals(karmaProperties[0].getValue())) {
                userMigrationDone = true;
            }
            if (!userMigrationDone) {
                KarmaUser[] allKarmaUsers;
                LOGGER.warn((Object)"Running username to userid migration...");
                for (KarmaUser karmaUser : allKarmaUsers = (KarmaUser[])this.ao.find(KarmaUser.class)) {
                    UserKey keyForUsername = UserCompatibilityHelper.getKeyForUsername(karmaUser.getUsername());
                    if (keyForUsername == null) continue;
                    karmaUser.setUserKey(keyForUsername.getStringValue());
                    karmaUser.setUsername(null);
                    karmaUser.save();
                }
                assert (karmaProperties != null);
                KarmaProperty karmaProperty = karmaProperties.length > 0 ? karmaProperties[0] : (KarmaProperty)this.ao.create(KarmaProperty.class, new DBParam[0]);
                karmaProperty.setKey("usermigration.username.to.userid");
                karmaProperty.setValue("true");
                karmaProperty.save();
                LOGGER.warn((Object)"Username to userid migration done.");
            }
            return null;
        });
        return new ArrayList<Message>();
    }

    public int getBuildNumber() {
        return this.karmaApplicationService.isAfterAtlassianUserkeyChange() ? 4527 : 0;
    }

    public String getPluginKey() {
        return "de.communardo.confluence.plugins.karma";
    }

    public String getShortDescription() {
        return "Migrate all usernames to userids";
    }
}

