/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.migration;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import io.moewe.confluence.addons.awards.ao.KarmaProperty;
import io.moewe.confluence.addons.awards.ao.KarmaUser;
import io.moewe.confluence.addons.awards.util.AwardsApplicationManager;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@Named
@ExportAsService
public class MigrateUsernameToUserIdColumnTask
implements PluginUpgradeTask {
    private static final Logger LOGGER = Logger.getLogger(MigrateUsernameToUserIdColumnTask.class);
    private final ActiveObjects ao;
    private final AwardsApplicationManager karmaApplicationService;

    @Inject
    public MigrateUsernameToUserIdColumnTask(@ComponentImport ActiveObjects ao, AwardsApplicationManager karmaApplicationService) {
        this.ao = ao;
        this.karmaApplicationService = karmaApplicationService;
    }

    public Collection<Message> doUpgrade() {
        this.ao.executeInTransaction(() -> {
            KarmaProperty[] karmaProperties = (KarmaProperty[])this.ao.find(KarmaProperty.class, Query.select().where("KEY = ?", new Object[]{"usermigration.username.to.userid.column"}));
            boolean userMigrationDone = false;
            if (karmaProperties != null && karmaProperties.length > 0 && "true".equals(karmaProperties[0].getValue())) {
                userMigrationDone = true;
            }
            if (!userMigrationDone) {
                KarmaUser[] allKarmaUsers;
                LOGGER.warn((Object)"Running username to userid column migration...");
                KarmaProperty[] karmaParticipationProperties = (KarmaProperty[])this.ao.find(KarmaProperty.class, Query.select().where("KEY LIKE (?)", new Object[]{"karma.participation.%"}));
                LOGGER.warn((Object)("Runnig participation migration for " + karmaParticipationProperties.length + " users."));
                for (KarmaProperty karmaParticipationProperty : karmaParticipationProperties) {
                    String participationPropertyKey = karmaParticipationProperty.getKey();
                    Object[] participationSplit = participationPropertyKey.split("\\.");
                    if (participationSplit.length != 3) continue;
                    String userName = participationSplit[2];
                    KarmaUser[] participators = (KarmaUser[])this.ao.find(KarmaUser.class, Query.select().where("USERNAME = ?", new Object[]{userName}));
                    if (participators.length <= 0) continue;
                    participationSplit[2] = participators[0].getID() + "";
                    karmaParticipationProperty.setKey(StringUtils.join((Object[])participationSplit, (String)"."));
                    karmaParticipationProperty.save();
                }
                LOGGER.warn((Object)"Participation migration done");
                for (KarmaUser karmaUser : allKarmaUsers = (KarmaUser[])this.ao.find(KarmaUser.class)) {
                    karmaUser.setUserKey(karmaUser.getUsername());
                    karmaUser.save();
                }
                assert (karmaProperties != null);
                KarmaProperty karmaProperty = karmaProperties.length > 0 ? karmaProperties[0] : (KarmaProperty)this.ao.create(KarmaProperty.class, new DBParam[0]);
                karmaProperty.setKey("usermigration.username.to.userid.column");
                karmaProperty.setValue("true");
                karmaProperty.save();
                LOGGER.warn((Object)"Username to userid column migration done.");
            }
            return null;
        });
        return new ArrayList<Message>();
    }

    public int getBuildNumber() {
        return !this.karmaApplicationService.isAfterAtlassianUserkeyChange() ? 4396 : 0;
    }

    public String getPluginKey() {
        return "de.communardo.confluence.plugins.karma";
    }

    public String getShortDescription() {
        return "Migrate all usernames to the new column userkey. This is a preperation for the upcoming userid change from atlassian";
    }
}

