/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.migration;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import io.moewe.confluence.addons.awards.ao.KarmaEntry;
import io.moewe.confluence.addons.awards.ao.KarmaEntryMetadata;
import io.moewe.confluence.addons.awards.ao.KarmaProperty;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.log4j.Logger;

@Named
@ExportAsService
public class MedalKarmaEntryUpgradeTask
implements PluginUpgradeTask {
    private final ActiveObjects ao;
    private static final Logger LOGGER = Logger.getLogger(MedalKarmaEntryUpgradeTask.class);

    @Inject
    public MedalKarmaEntryUpgradeTask(@ComponentImport ActiveObjects ao) {
        this.ao = ao;
    }

    public Collection<Message> doUpgrade() {
        this.ao.executeInTransaction(() -> {
            KarmaProperty[] karmaProperties = (KarmaProperty[])this.ao.find(KarmaProperty.class, Query.select().where("KEY = ?", new Object[]{"medalkarmaentry.empty.message.migration"}));
            boolean migrationDone = false;
            if (karmaProperties != null && karmaProperties.length > 0 && "true".equals(karmaProperties[0].getValue())) {
                migrationDone = true;
            }
            if (!migrationDone) {
                KarmaEntry[] entries;
                LOGGER.warn((Object)"Running Medalkarmaentry migration...");
                int stepWidth = 10000;
                int offset = 0;
                while ((entries = (KarmaEntry[])this.ao.find(KarmaEntry.class, Query.select().where("EVENT_KEY = ?", new Object[]{"recieve-medal-karma-event"}).order("ID ASC").limit(stepWidth).offset(offset))).length > 0) {
                    for (KarmaEntry karmaEntry : entries) {
                        KarmaEntryMetadata[] karmaEntryMetadata = karmaEntry.getKarmaEntryMetadata();
                        if (karmaEntryMetadata == null || karmaEntryMetadata.length != 2) continue;
                        KarmaEntryMetadata newKarmaEntryMetadata = (KarmaEntryMetadata)this.ao.create(KarmaEntryMetadata.class, new DBParam[0]);
                        newKarmaEntryMetadata.setMetadata("");
                        newKarmaEntryMetadata.setKarmaEntry(karmaEntry);
                        newKarmaEntryMetadata.save();
                    }
                    offset += stepWidth;
                }
                assert (karmaProperties != null);
                KarmaProperty karmaProperty = karmaProperties.length > 0 ? karmaProperties[0] : (KarmaProperty)this.ao.create(KarmaProperty.class, new DBParam[0]);
                karmaProperty.setKey("medalkarmaentry.empty.message.migration");
                karmaProperty.setValue("true");
                karmaProperty.save();
                LOGGER.warn((Object)"Medalkarmaentry migration done.");
            }
            return null;
        });
        return Collections.emptySet();
    }

    public int getBuildNumber() {
        return 15;
    }

    public String getPluginKey() {
        return "de.communardo.confluence.plugins.karma";
    }

    public String getShortDescription() {
        return "Migrates old medal karmaevents without messages.";
    }
}

