/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.migration;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import io.moewe.atlassian.sdk.auiforms.FormService;
import io.moewe.atlassian.sdk.auiforms.exceptions.FormException;
import io.moewe.confluence.addons.awards.AchievementType;
import io.moewe.confluence.addons.awards.ao.AchievementEntity;
import io.moewe.confluence.addons.awards.ao.KarmaEntry;
import io.moewe.confluence.addons.awards.ao.KarmaEntryMetadata;
import io.moewe.confluence.addons.awards.ao.MedalDao;
import io.moewe.confluence.addons.awards.events.MedalDescription;
import io.moewe.confluence.addons.awards.events.MedalModuleDescriptor;
import io.moewe.confluence.addons.awards.forms.AchievementSettings;
import io.moewe.confluence.addons.awards.rest.pojo.Achievement;
import io.moewe.confluence.addons.awards.rest.pojo.AchievementMetaData;
import io.moewe.confluence.addons.awards.services.AchievementService;
import io.moewe.confluence.addons.awards.services.KarmaPropertyManager;
import io.moewe.confluence.addons.awards.util.AwardsApplicationManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@ExportAsService
public class AwardsMedalToAchievementUpgradeTask
implements PluginUpgradeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AwardsMedalToAchievementUpgradeTask.class);
    private static final String KARMAPROPERTY_NUMBER_OF_MEDALS_PER_DAY = "karma.settings.medals.per.day";
    private static final int KARMAPROPERTY_NUMBER_OF_MEDALS_PER_DAY_DEFAULT_VALUE = 2;
    private final PluginAccessor pluginAccessor;
    private final ActiveObjects activeObjects;
    private final FormService formService;
    private final AchievementService achievementService;
    private final KarmaPropertyManager karmaPropertyManager;
    private final AwardsApplicationManager awardsApplicationService;

    @Inject
    public AwardsMedalToAchievementUpgradeTask(FormService formService, AchievementService achievementService, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport ActiveObjects activeObjects, KarmaPropertyManager karmaPropertyManager, AwardsApplicationManager awardsApplicationService) {
        this.formService = formService;
        this.achievementService = achievementService;
        this.pluginAccessor = pluginAccessor;
        this.activeObjects = activeObjects;
        this.karmaPropertyManager = karmaPropertyManager;
        this.awardsApplicationService = awardsApplicationService;
    }

    public int getBuildNumber() {
        return 2020061500;
    }

    public String getShortDescription() {
        return "Migrates general configuration properties to general configuration form.";
    }

    public Collection<Message> doUpgrade() throws Exception {
        AchievementSettings achievementSettings = this.formService.getForm(AchievementSettings.class);
        achievementSettings.setMedalQuotaPerDay(this.getNumberOfMedalsPerDay());
        try {
            this.formService.saveForm(achievementSettings, true);
        }
        catch (FormException e) {
            LOGGER.error("Exception while saving general configuration form", (Throwable)e);
        }
        List<MedalDescription> medalDescriptionList = this.getAllAvailableMedals();
        HashMap<String, String> medalNameToAchievementUuid = new HashMap<String, String>();
        for (MedalDescription medalDescription : medalDescriptionList) {
            Achievement achievement = new Achievement();
            achievement.setName(this.getMedalTitle(medalDescription));
            achievement.setType(AchievementType.MEDAL);
            achievement.setEnabled(medalDescription.isActive());
            AchievementMetaData metaData = new AchievementMetaData();
            metaData.setIconUrl(this.getMedalIcon(medalDescription));
            achievement.setMetaData(metaData);
            Achievement newAchievement = this.achievementService.addAchievement(achievement);
            medalNameToAchievementUuid.put(this.getMedalTitle(medalDescription), newAchievement.getUuid());
            AchievementEntity achievementEntity = this.achievementService.getAchievementEntity(newAchievement.getUuid());
            if (achievementEntity != null) {
                Query medalDaoQuery = Query.select().from(MedalDao.class).where("KEY = ?", new Object[]{medalDescription.getKey()});
                for (MedalDao medalDao : (MedalDao[])this.activeObjects.find(MedalDao.class, medalDaoQuery)) {
                    medalDao.setAchievement(achievementEntity);
                    medalDao.save();
                }
                continue;
            }
            LOGGER.warn("There was no achievement for uuid {}", (Object)newAchievement.getUuid());
        }
        Query query = Query.select().from(KarmaEntry.class).where("EVENT_KEY = ? AND CONTEXT_ID IS NULL", new Object[]{"recieve-medal-karma-event"});
        for (KarmaEntry karmaEntry : (KarmaEntry[])this.activeObjects.find(KarmaEntry.class, query)) {
            String metadata;
            KarmaEntryMetadata[] karmaEntryMetadata = karmaEntry.getKarmaEntryMetadata();
            if (karmaEntryMetadata == null || karmaEntryMetadata.length < 2 || !medalNameToAchievementUuid.containsKey(metadata = karmaEntryMetadata[1].getMetadata())) continue;
            karmaEntry.setContextId((String)medalNameToAchievementUuid.get(metadata));
            karmaEntry.save();
        }
        return Collections.emptySet();
    }

    public String getMedalTitle(MedalDescription medalDescription) {
        String medalTitleProperty = this.karmaPropertyManager.getKarmaProperty(medalDescription.getCustomMedalTitleKey());
        return !StringUtils.isBlank((String)medalTitleProperty) ? medalTitleProperty : this.getDefaultMedalTitle(medalDescription);
    }

    public String getDefaultMedalTitle(MedalDescription medalDescription) {
        return GeneralUtil.getI18n().getText(medalDescription.getMedalTitleKey());
    }

    public String getMedalIcon(MedalDescription medalDescription) {
        String badgeIcon = this.karmaPropertyManager.getKarmaProperty(medalDescription.getCustomMedalIconKey());
        return !StringUtils.isBlank((String)badgeIcon) ? badgeIcon : this.getDefaultMedalIcon(medalDescription);
    }

    public String getDefaultMedalIcon(MedalDescription medalDescription) {
        return this.awardsApplicationService.getContextPath() + "/download/resources/de.communardo.confluence.plugins.karma:karma-overview-ressources/images/" + medalDescription.getKey() + ".png";
    }

    public Integer getNumberOfMedalsPerDay() {
        String karmaProperty = this.karmaPropertyManager.getKarmaProperty(KARMAPROPERTY_NUMBER_OF_MEDALS_PER_DAY);
        return karmaProperty != null ? Integer.parseInt(karmaProperty) : 2;
    }

    public List<MedalDescription> getAllAvailableMedals() {
        ArrayList<MedalDescription> result = new ArrayList<MedalDescription>();
        Collection plugins = this.pluginAccessor.getPlugins();
        for (Plugin plugin : plugins) {
            Collection moduleDescriptors = plugin.getModuleDescriptors();
            for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
                if (moduleDescriptor.getClass() != MedalModuleDescriptor.class) continue;
                MedalDescription karmaEventDescription = (MedalDescription)moduleDescriptor.getModule();
                karmaEventDescription.setActive(moduleDescriptor.isEnabled());
                result.add(karmaEventDescription);
            }
        }
        return result;
    }

    public String getPluginKey() {
        return "de.communardo.confluence.plugins.karma";
    }
}

