/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.migration;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import io.moewe.confluence.addons.awards.AchievementType;
import io.moewe.confluence.addons.awards.AwardsEvent;
import io.moewe.confluence.addons.awards.ao.AchievementEntity;
import io.moewe.confluence.addons.awards.ao.BadgeEntry;
import io.moewe.confluence.addons.awards.ao.KarmaEntry;
import io.moewe.confluence.addons.awards.events.BadgeDescription;
import io.moewe.confluence.addons.awards.events.BadgeModuleDescriptor;
import io.moewe.confluence.addons.awards.events.KarmaEventDescription;
import io.moewe.confluence.addons.awards.events.KarmaEventModuleDescriptor;
import io.moewe.confluence.addons.awards.rest.pojo.Achievement;
import io.moewe.confluence.addons.awards.rest.pojo.AchievementMetaData;
import io.moewe.confluence.addons.awards.rest.pojo.Processor;
import io.moewe.confluence.addons.awards.rest.pojo.ProcessorMetaData;
import io.moewe.confluence.addons.awards.rest.pojo.input.AwardsEventInput;
import io.moewe.confluence.addons.awards.rest.pojo.input.Input;
import io.moewe.confluence.addons.awards.rest.pojo.input.events.AchievementEventInput;
import io.moewe.confluence.addons.awards.rest.pojo.input.events.DecreaseEventInput;
import io.moewe.confluence.addons.awards.rest.pojo.input.events.ScoreLeaderEventInput;
import io.moewe.confluence.addons.awards.rest.pojo.input.events.UserEventInput;
import io.moewe.confluence.addons.awards.rest.pojo.input.events.confluence.BlogPostEventInput;
import io.moewe.confluence.addons.awards.rest.pojo.input.events.confluence.CommentEventInput;
import io.moewe.confluence.addons.awards.rest.pojo.input.events.confluence.LabelEventInput;
import io.moewe.confluence.addons.awards.rest.pojo.input.events.confluence.LikeEventInput;
import io.moewe.confluence.addons.awards.rest.pojo.input.events.confluence.PageEventInput;
import io.moewe.confluence.addons.awards.rest.pojo.input.events.confluence.PageLinksEventInput;
import io.moewe.confluence.addons.awards.rest.pojo.input.events.confluence.SearchedEventInput;
import io.moewe.confluence.addons.awards.rest.pojo.input.events.confluence.SecurityEventInput;
import io.moewe.confluence.addons.awards.rest.pojo.input.events.confluence.SpaceEventInput;
import io.moewe.confluence.addons.awards.rest.pojo.output.AchievementOutput;
import io.moewe.confluence.addons.awards.rest.pojo.output.Output;
import io.moewe.confluence.addons.awards.rest.pojo.output.PointOutput;
import io.moewe.confluence.addons.awards.services.AchievementService;
import io.moewe.confluence.addons.awards.services.KarmaPropertyManager;
import io.moewe.confluence.addons.awards.services.ProcessorService;
import io.moewe.confluence.addons.awards.util.AwardsApplicationManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@ExportAsService
public class AwardsBadgeToAchievementAndEventsToProcessorUpgradeTask
implements PluginUpgradeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AwardsBadgeToAchievementAndEventsToProcessorUpgradeTask.class);
    private static final String KARMAPROPERTY_CUSTOMKARMA_PREFIX = "customkarma.";
    private final ActiveObjects activeObjects;
    private final ProcessorService processorService;
    private final AchievementService achievementService;
    private final PluginAccessor pluginAccessor;
    private final KarmaPropertyManager karmaPropertyManager;
    private final AwardsApplicationManager awardsApplicationService;

    @Inject
    public AwardsBadgeToAchievementAndEventsToProcessorUpgradeTask(@ComponentImport ActiveObjects activeObjects, ProcessorService processorService, AchievementService achievementService, @ComponentImport PluginAccessor pluginAccessor, KarmaPropertyManager karmaPropertyManager, AwardsApplicationManager awardsApplicationService) {
        this.activeObjects = activeObjects;
        this.processorService = processorService;
        this.achievementService = achievementService;
        this.pluginAccessor = pluginAccessor;
        this.karmaPropertyManager = karmaPropertyManager;
        this.awardsApplicationService = awardsApplicationService;
    }

    public int getBuildNumber() {
        return 2020112401;
    }

    public String getShortDescription() {
        return "Migrates general configuration properties to general configuration form.";
    }

    public Collection<Message> doUpgrade() {
        this.activeObjects.executeInTransaction(() -> {
            Map<String, Achievement> mappedBadgeKeyToAchievements = this.doUpgradeBadges();
            try {
                this.doUpgradeEvents(mappedBadgeKeyToAchievements);
            }
            catch (Exception e) {
                LOGGER.error("Exception while migrating awards", (Throwable)e);
            }
            return null;
        });
        return Collections.emptySet();
    }

    private Map<String, Achievement> doUpgradeBadges() {
        LinkedHashMap<String, Achievement> mappedBadgeKeyToAchievements = new LinkedHashMap<String, Achievement>();
        List<BadgeDescription> badgeDescriptionList = this.getAllAvailableBadges();
        ArrayList<String> uniqueBadges = new ArrayList<String>();
        uniqueBadges.add("badge-karmaleader-DAY");
        uniqueBadges.add("badge-karmaleader-WEEK");
        uniqueBadges.add("badge-karmaleader-MONTH");
        uniqueBadges.add("badge-karmaleader-YEAR");
        uniqueBadges.add("badge-karmaleader-OVERALL");
        HashMap<String, String> iterateBadges = new HashMap<String, String>();
        iterateBadges.put("loveletter", "likecount");
        iterateBadges.put("badge-follower-30", "follower");
        iterateBadges.put("badge-comment-100", "commentcount");
        iterateBadges.put("badge-1000-labels", "labelcount");
        iterateBadges.put("badge-content-1000", "contentcount");
        iterateBadges.put("badge-100-pagelinks", "linkcount");
        for (BadgeDescription badgeDescription : badgeDescriptionList) {
            Achievement achievement = new Achievement();
            achievement.setName(this.getBadgeTitle(badgeDescription));
            achievement.setType(AchievementType.BADGE);
            achievement.setEnabled(badgeDescription.isActive());
            achievement.setDescription(this.getBadgeDetailMessage(badgeDescription, true));
            AchievementMetaData metaData = new AchievementMetaData();
            metaData.setIconUrl(this.getBadgeIcon(badgeDescription));
            if (uniqueBadges.contains(badgeDescription.getKey())) {
                metaData.setUnique(true);
            }
            if (iterateBadges.containsKey(badgeDescription.getKey())) {
                String count = this.getBadgeParameter(badgeDescription, (String)iterateBadges.get(badgeDescription.getKey()));
                metaData.setSteps(Integer.valueOf(count));
            } else {
                metaData.setSteps(1);
            }
            achievement.setMetaData(metaData);
            Achievement newAchievement = this.achievementService.addAchievement(achievement);
            if (newAchievement == null) continue;
            mappedBadgeKeyToAchievements.put(badgeDescription.getKey(), newAchievement);
            AchievementEntity achievementEntity = this.achievementService.getAchievementEntity(newAchievement.getUuid());
            if (achievementEntity != null) {
                Query medalDaoQuery = Query.select().from(BadgeEntry.class).where("BADGEKEY = ?", new Object[]{badgeDescription.getKey()});
                for (BadgeEntry badgeEntry : (BadgeEntry[])this.activeObjects.find(BadgeEntry.class, medalDaoQuery)) {
                    badgeEntry.setAchievement(achievementEntity);
                    badgeEntry.save();
                }
                continue;
            }
            LOGGER.warn("There was no achievement for uuid {}", (Object)newAchievement.getUuid());
        }
        return mappedBadgeKeyToAchievements;
    }

    private void doUpgradeEvents(Map<String, Achievement> mappedBadgeKeyToAchievements) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        List<KarmaEventDescription> karmaEventDescriptions = this.getAllAvailableKarmaEvents();
        HashMap<String, String[]> eventDescriptorKeyBadgeKeyMapping = new HashMap<String, String[]>();
        eventDescriptorKeyBadgeKeyMapping.put("karma-leader-DAY-event", new String[]{"badge-karmaleader-DAY"});
        eventDescriptorKeyBadgeKeyMapping.put("karma-leader-WEEK-event", new String[]{"badge-karmaleader-WEEK"});
        eventDescriptorKeyBadgeKeyMapping.put("karma-leader-MONTH-event", new String[]{"badge-karmaleader-MONTH"});
        eventDescriptorKeyBadgeKeyMapping.put("karma-leader-YEAR-event", new String[]{"badge-karmaleader-YEAR"});
        eventDescriptorKeyBadgeKeyMapping.put("karma-leader-OVERALL-event", new String[]{"badge-karmaleader-OVERALL"});
        eventDescriptorKeyBadgeKeyMapping.put("blogpost-add-karma-event", new String[]{"badge-first-blogpost", "badge-content-1000"});
        eventDescriptorKeyBadgeKeyMapping.put("page-add-karma-event", new String[]{"badge-first-page", "badge-content-1000"});
        eventDescriptorKeyBadgeKeyMapping.put("comment-add-karma-event", new String[]{"badge-first-comment", "badge-comment-100"});
        eventDescriptorKeyBadgeKeyMapping.put("addlabel-karma-event", new String[]{"badge-first-label", "badge-1000-labels"});
        eventDescriptorKeyBadgeKeyMapping.put("content-like-karma-event", new String[]{"loveletter"});
        eventDescriptorKeyBadgeKeyMapping.put("follow-karma-event", new String[]{"badge-first-follow"});
        eventDescriptorKeyBadgeKeyMapping.put("be-followed-karma-event", new String[]{"badge-first-follow", "badge-follower-30"});
        eventDescriptorKeyBadgeKeyMapping.put("upload-profile-picture-event", new String[]{"badge-profile-picture"});
        eventDescriptorKeyBadgeKeyMapping.put("update-profile-information-event", new String[]{"badge-profile-update"});
        eventDescriptorKeyBadgeKeyMapping.put("add-internal-link-karma-event", new String[]{"badge-100-pagelinks"});
        HashMap<String, AwardsEvent> eventDescriptorKeyAwardsEventMapping = new HashMap<String, AwardsEvent>();
        eventDescriptorKeyAwardsEventMapping.put("karma-leader-DAY-event", AwardsEvent.SCORE_LEADER_DAY_CHANGED);
        eventDescriptorKeyAwardsEventMapping.put("karma-leader-WEEK-event", AwardsEvent.SCORE_LEADER_WEEK_CHANGED);
        eventDescriptorKeyAwardsEventMapping.put("karma-leader-MONTH-event", AwardsEvent.SCORE_LEADER_MONTH_CHANGED);
        eventDescriptorKeyAwardsEventMapping.put("karma-leader-YEAR-event", AwardsEvent.SCORE_LEADER_YEAR_CHANGED);
        eventDescriptorKeyAwardsEventMapping.put("karma-leader-OVERALL-event", AwardsEvent.SCORE_LEADER_OVERALL_CHANGED);
        eventDescriptorKeyAwardsEventMapping.put("blogpost-add-karma-event", AwardsEvent.BLOG_CREATED);
        eventDescriptorKeyAwardsEventMapping.put("page-add-karma-event", AwardsEvent.PAGE_CREATED);
        eventDescriptorKeyAwardsEventMapping.put("comment-add-karma-event", AwardsEvent.COMMENT_CREATED);
        eventDescriptorKeyAwardsEventMapping.put("addlabel-karma-event", AwardsEvent.LABEL_ADDED);
        eventDescriptorKeyAwardsEventMapping.put("content-like-karma-event", AwardsEvent.USER_CONTENT_IS_LIKED);
        eventDescriptorKeyAwardsEventMapping.put("follow-karma-event", AwardsEvent.USER_FOLLOWED);
        eventDescriptorKeyAwardsEventMapping.put("be-followed-karma-event", AwardsEvent.USER_BE_FOLLOWED);
        eventDescriptorKeyAwardsEventMapping.put("create-personal-space-karma-event", AwardsEvent.PERSONAL_SPACE_CREATED);
        eventDescriptorKeyAwardsEventMapping.put("edit-blogpost-karma-event", AwardsEvent.BLOG_UPDATED);
        eventDescriptorKeyAwardsEventMapping.put("edit-page-karma-event", AwardsEvent.PAGE_UPDATED);
        eventDescriptorKeyAwardsEventMapping.put("follow-space-karma-event", AwardsEvent.SPACE_FOLLOWED);
        eventDescriptorKeyAwardsEventMapping.put("follow-page-karma-event", AwardsEvent.PAGE_FOLLOWED);
        eventDescriptorKeyAwardsEventMapping.put("follow-blogpost-karma-event", AwardsEvent.BLOG_FOLLOWED);
        eventDescriptorKeyAwardsEventMapping.put("search-content-karma-event", AwardsEvent.SEARCHED);
        eventDescriptorKeyAwardsEventMapping.put("recieve-medal-karma-event", AwardsEvent.ACHIEVEMENT_ADDED);
        eventDescriptorKeyAwardsEventMapping.put("decrease-karma-event", AwardsEvent.DECREASE);
        eventDescriptorKeyAwardsEventMapping.put("upload-profile-picture-event", AwardsEvent.USER_PROFILE_PICTURE_UPDATED);
        eventDescriptorKeyAwardsEventMapping.put("update-profile-information-event", AwardsEvent.USER_PROFILE_UPDATED);
        eventDescriptorKeyAwardsEventMapping.put("add-internal-link-karma-event", AwardsEvent.PAGE_INTERNAL_LINK_ADDED);
        HashMap<AwardsEvent, Class<? extends Input>> awardsEventInputMapping = new HashMap<AwardsEvent, Class<? extends Input>>();
        awardsEventInputMapping.put(AwardsEvent.SCORE_LEADER_DAY_CHANGED, ScoreLeaderEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.SCORE_LEADER_WEEK_CHANGED, ScoreLeaderEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.SCORE_LEADER_MONTH_CHANGED, ScoreLeaderEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.SCORE_LEADER_YEAR_CHANGED, ScoreLeaderEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.SCORE_LEADER_OVERALL_CHANGED, ScoreLeaderEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.BLOG_CREATED, BlogPostEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.PAGE_CREATED, PageEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.COMMENT_CREATED, CommentEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.LABEL_ADDED, LabelEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.USER_FOLLOWED, UserEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.USER_BE_FOLLOWED, UserEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.PERSONAL_SPACE_CREATED, SpaceEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.BLOG_UPDATED, BlogPostEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.PAGE_UPDATED, PageEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.SPACE_FOLLOWED, SpaceEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.PAGE_FOLLOWED, PageEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.BLOG_FOLLOWED, BlogPostEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.SEARCHED, SearchedEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.ACHIEVEMENT_ADDED, AchievementEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.DECREASE, DecreaseEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.USER_CONTENT_IS_LIKED, LikeEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.USER_PROFILE_PICTURE_UPDATED, UserEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.USER_PROFILE_UPDATED, UserEventInput.class);
        awardsEventInputMapping.put(AwardsEvent.PAGE_INTERNAL_LINK_ADDED, PageLinksEventInput.class);
        for (KarmaEventDescription karmaEventDescription : karmaEventDescriptions) {
            AwardsEvent awardsEvent = (AwardsEvent)((Object)eventDescriptorKeyAwardsEventMapping.get(karmaEventDescription.getKey()));
            if (awardsEvent == null) continue;
            Processor processor = new Processor();
            processor.setName(karmaEventDescription.getKey());
            processor.setEnabled(karmaEventDescription.isActive());
            ProcessorMetaData processorMetaData = new ProcessorMetaData();
            this.setInput(awardsEventInputMapping, awardsEvent, processorMetaData);
            this.setPointOutputs(karmaEventDescription, processorMetaData);
            this.setAchievementOutputs(mappedBadgeKeyToAchievements, eventDescriptorKeyBadgeKeyMapping, karmaEventDescription, processorMetaData);
            processor.setMetaData(processorMetaData);
            this.processorService.addProcessor(processor);
            Query query = Query.select().from(KarmaEntry.class).where("EVENT_KEY = ?", new Object[]{karmaEventDescription.getKey()});
            for (KarmaEntry karmaEntry : (KarmaEntry[])this.activeObjects.find(KarmaEntry.class, query)) {
                karmaEntry.setEventKey(awardsEvent.name());
                karmaEntry.setDescription("");
                karmaEntry.save();
            }
        }
        this.addLoginEventProcessor(mappedBadgeKeyToAchievements.get("badge-nightowl"), "login-event-night", "21:00", "03:59");
        this.addLoginEventProcessor(mappedBadgeKeyToAchievements.get("badge-morningbird"), "login-event-morning", "04:00", "08:00");
    }

    private void addLoginEventProcessor(Achievement achievement, String processorName, String minTime, String maxTime) {
        if (achievement != null) {
            Processor processor = new Processor();
            processor.setName(processorName);
            processor.setEnabled(Boolean.TRUE);
            ProcessorMetaData processorMetaData = new ProcessorMetaData();
            SecurityEventInput loginEventInput = new SecurityEventInput();
            loginEventInput.setEvents(new AwardsEvent[]{AwardsEvent.LOGIN});
            loginEventInput.setMinTime(minTime);
            loginEventInput.setMaxTime(maxTime);
            ArrayList<Input> inputs = new ArrayList<Input>();
            inputs.add(loginEventInput);
            processorMetaData.setInputs(inputs);
            AchievementOutput achievementOutput = new AchievementOutput();
            achievementOutput.setAchievementUuid(achievement.getUuid());
            ArrayList<Output> outputs = new ArrayList<Output>();
            outputs.add(achievementOutput);
            processorMetaData.setOutputs(outputs);
            processor.setMetaData(processorMetaData);
            this.processorService.addProcessor(processor);
        }
    }

    private void setAchievementOutputs(Map<String, Achievement> mappedBadgeKeyToAchievements, Map<String, String[]> eventDescriptorKeyBadgeKeyMapping, KarmaEventDescription karmaEventDescription, ProcessorMetaData processorMetaData) {
        if (eventDescriptorKeyBadgeKeyMapping.containsKey(karmaEventDescription.getKey())) {
            String[] badgeKeys = eventDescriptorKeyBadgeKeyMapping.get(karmaEventDescription.getKey());
            Arrays.stream(badgeKeys).forEach(badgeKey -> {
                if (mappedBadgeKeyToAchievements.containsKey(badgeKey)) {
                    Achievement achievement = (Achievement)mappedBadgeKeyToAchievements.get(badgeKey);
                    AchievementOutput achievementOutput = new AchievementOutput();
                    achievementOutput.setAchievementUuid(achievement.getUuid());
                    List<Output> outputs = processorMetaData.getOutputs();
                    outputs.add(achievementOutput);
                    processorMetaData.setOutputs(outputs);
                }
            });
        }
    }

    private void setInput(Map<AwardsEvent, Class<? extends Input>> awardsEventInputMapping, AwardsEvent awardsEvent, ProcessorMetaData processorMetaData) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (awardsEventInputMapping.containsKey((Object)awardsEvent)) {
            Class<? extends Input> inputClass = awardsEventInputMapping.get((Object)awardsEvent);
            AwardsEventInput awardsEventInput = (AwardsEventInput)inputClass.getDeclaredConstructors()[0].newInstance(new Object[0]);
            awardsEventInput.setEvents(new AwardsEvent[]{awardsEvent});
            if (awardsEventInput instanceof AchievementEventInput) {
                ((AchievementEventInput)awardsEventInput).setTypes(new AchievementType[]{AchievementType.MEDAL});
            }
            ArrayList<Input> inputs = new ArrayList<Input>();
            inputs.add(awardsEventInput);
            processorMetaData.setInputs(inputs);
        }
    }

    private void setPointOutputs(KarmaEventDescription karmaEventDescription, ProcessorMetaData processorMetaData) {
        PointOutput pointOutput = new PointOutput();
        pointOutput.setPoints(karmaEventDescription.getKarma());
        ArrayList<Output> outputs = new ArrayList<Output>();
        outputs.add(pointOutput);
        processorMetaData.setOutputs(outputs);
    }

    public List<KarmaEventDescription> getAllAvailableKarmaEvents() {
        ArrayList<KarmaEventDescription> result = new ArrayList<KarmaEventDescription>();
        Collection plugins = this.pluginAccessor.getPlugins();
        for (Plugin plugin : plugins) {
            Collection moduleDescriptors = plugin.getModuleDescriptors();
            for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
                if (moduleDescriptor.getClass() != KarmaEventModuleDescriptor.class) continue;
                KarmaEventDescription karmaEventDescription = (KarmaEventDescription)moduleDescriptor.getModule();
                karmaEventDescription.setActive(moduleDescriptor.isEnabled());
                result.add(karmaEventDescription);
            }
        }
        return result;
    }

    public Integer getKarmaEventKarma(KarmaEventDescription karmaEventDescription) {
        String karmaProperty = this.karmaPropertyManager.getKarmaProperty(KARMAPROPERTY_CUSTOMKARMA_PREFIX + karmaEventDescription.getKey());
        if (karmaProperty != null) {
            return Integer.parseInt(karmaProperty);
        }
        return karmaEventDescription.getKarma();
    }

    public String getBadgeTitle(BadgeDescription badgeDescription) {
        return this.getBadgeTitle(badgeDescription, true);
    }

    public String getBadgeTitle(BadgeDescription badgeDescription, boolean replace) {
        String badgeTitleProperty = this.karmaPropertyManager.getKarmaProperty(badgeDescription.getCustomBadgeTitleKey());
        String unreplacedResult = !StringUtils.isBlank((String)badgeTitleProperty) ? badgeTitleProperty : this.getDefaultBadgeTitle(badgeDescription);
        return replace ? this.replaceParameterPlaceholders(badgeDescription, unreplacedResult) : unreplacedResult;
    }

    public String getDefaultBadgeTitle(BadgeDescription badgeDescription) {
        return GeneralUtil.getI18n().getText(badgeDescription.getBadgeTitleKey());
    }

    public String getBadgeDetailMessage(BadgeDescription badgeDescription, boolean replace) {
        String badgeMessageProperty = this.karmaPropertyManager.getKarmaProperty(badgeDescription.getCustomBadgeDetailMessageKey());
        String unreplacedText = !StringUtils.isBlank((String)badgeMessageProperty) && !badgeMessageProperty.startsWith("communardo.badge.") ? badgeMessageProperty : this.getDefaultBadgeDetailMessage(badgeDescription);
        return replace ? this.replaceParameterPlaceholders(badgeDescription, unreplacedText) : unreplacedText;
    }

    public String getDefaultBadgeDetailMessage(BadgeDescription badgeDescription) {
        Object[] myStringArray = new String[]{"points"};
        String badgeDetailMessage = GeneralUtil.getI18n().getText(badgeDescription.getBadgeDetailMessageKey(), myStringArray);
        if (badgeDetailMessage.equals(badgeDescription.getBadgeDetailMessageKey())) {
            badgeDetailMessage = GeneralUtil.getI18n().getText(badgeDescription.getBadgeDetailMessageKey());
        }
        return badgeDetailMessage;
    }

    public String getBadgeIcon(BadgeDescription badgeDescription) {
        String badgeIcon = this.karmaPropertyManager.getKarmaProperty(badgeDescription.getCustomBadgeIconKey());
        return !StringUtils.isBlank((String)badgeIcon) ? badgeIcon : this.getDefaultBadgeIcon(badgeDescription);
    }

    public String getDefaultBadgeIcon(BadgeDescription badgeDescription) {
        return this.awardsApplicationService.getContextPath() + "/download/resources/de.communardo.confluence.plugins.karma:karma-overview-ressources/images/" + badgeDescription.getKey() + ".png";
    }

    private String replaceParameterPlaceholders(BadgeDescription badgeDescription, String text) {
        for (Map.Entry<String, String> parameterEntry : badgeDescription.getParameters().entrySet()) {
            text = text.replaceAll("\\$\\{" + parameterEntry.getKey() + "\\}", this.getBadgeParameter(badgeDescription, parameterEntry.getKey()));
        }
        return text;
    }

    public String getBadgeParameter(BadgeDescription badgeDescription, String parameter) {
        String customProperty = this.karmaPropertyManager.getKarmaProperty(badgeDescription.getCustomParameterKey(parameter));
        String defaultParameter = this.getDefaultBadgeParameter(badgeDescription, parameter);
        return !StringUtils.isBlank((String)customProperty) && !customProperty.startsWith("communardo.badge.") ? customProperty : (!StringUtils.isBlank((String)defaultParameter) ? defaultParameter : null);
    }

    public String getDefaultBadgeParameter(BadgeDescription badgeDescription, String parameter) {
        return badgeDescription.getParameter(parameter);
    }

    public List<BadgeDescription> getAllAvailableBadges() {
        ArrayList<BadgeDescription> result = new ArrayList<BadgeDescription>();
        Collection plugins = this.pluginAccessor.getPlugins();
        for (Plugin plugin : plugins) {
            Collection moduleDescriptors = plugin.getModuleDescriptors();
            for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
                if (moduleDescriptor.getClass() != BadgeModuleDescriptor.class) continue;
                BadgeDescription badgeDescription = (BadgeDescription)moduleDescriptor.getModule();
                badgeDescription.setActive(moduleDescriptor.isEnabled());
                result.add(badgeDescription);
            }
        }
        return result;
    }

    public String getPluginKey() {
        return "de.communardo.confluence.plugins.karma";
    }
}

