/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.macros;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import io.moewe.confluence.addons.awards.AchievementType;
import io.moewe.confluence.addons.awards.KarmaUserProfile;
import io.moewe.confluence.addons.awards.services.AchievementService;
import io.moewe.confluence.addons.awards.services.KarmaUserManager;
import io.moewe.confluence.addons.awards.services.MedalManager;
import io.moewe.confluence.addons.awards.services.UserAwardsService;
import io.moewe.confluence.addons.awards.util.AwardsApplicationManager;
import io.moewe.confluence.addons.awards.util.AwardsHelper;
import java.util.Map;

public class AwardsMedalsMacro
extends BaseMacro {
    private static final String MACRO_TEMPLATE = "/vm/karmamedals.vm";
    private final MedalManager medalManager;
    private final KarmaUserManager karmaUserManager;
    private final PageBuilderService pageBuilderService;
    private final AwardsApplicationManager karmaApplicationService;
    private final UserManager userManager;
    private final UserAwardsService userAwardsService;
    private final AchievementService achievementService;

    public AwardsMedalsMacro(MedalManager medalManager, KarmaUserManager karmaUserManager, @ComponentImport PageBuilderService pageBuilderService, AwardsApplicationManager karmaApplicationService, @ComponentImport UserManager userManager, UserAwardsService userAwardsService, AchievementService achievementService) {
        this.medalManager = medalManager;
        this.karmaUserManager = karmaUserManager;
        this.pageBuilderService = pageBuilderService;
        this.karmaApplicationService = karmaApplicationService;
        this.userManager = userManager;
        this.userAwardsService = userAwardsService;
        this.achievementService = achievementService;
    }

    public String execute(Map parameters, String body, RenderContext context) {
        Map velocityContext = MacroUtils.defaultVelocityContext();
        boolean medalGrouping = parameters.get("showgroupedmedals") == null || Boolean.parseBoolean(parameters.get("showgroupedmedals").toString());
        boolean medalStream = parameters.get("showmedalstream") == null || Boolean.parseBoolean(parameters.get("showmedalstream").toString());
        String medalUser = String.valueOf(parameters.get("medaluser"));
        KarmaUserProfile karmaUserFromUsername = this.karmaUserManager.getKarmaUserFromUsername(medalUser);
        velocityContext.put("medalAchievements", this.achievementService.getActiveAchievements(AchievementType.MEDAL));
        velocityContext.put("userAwardsService", this.userAwardsService);
        if (medalGrouping) {
            velocityContext.put("userMedalGroups", this.medalManager.getGroupedUserMedals(karmaUserFromUsername));
        }
        if (medalStream) {
            velocityContext.put("userMedals", this.medalManager.getUserMedals(20, karmaUserFromUsername));
        }
        velocityContext.put("karmaHelper", new AwardsHelper());
        velocityContext.put("dateFormatter", this.karmaApplicationService.getDateFormatter());
        velocityContext.put("karmaUserManager", this.karmaUserManager);
        velocityContext.put("userManager", this.userManager);
        velocityContext.put("medalGrouping", medalGrouping);
        velocityContext.put("medalStream", medalStream);
        this.pageBuilderService.assembler().resources().requireContext("karma.macro.karmamedals");
        return VelocityUtils.getRenderedTemplate((String)MACRO_TEMPLATE, (Map)velocityContext);
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public boolean hasBody() {
        return false;
    }
}

