/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.events;

import com.atlassian.confluence.content.render.xhtml.links.OutgoingLinksExtractor;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentCreateEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentRemoveEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentTrashedEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentUpdateEvent;
import com.atlassian.confluence.event.events.content.attachment.GeneralAttachmentRestoreEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRestoreEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostTrashedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.mail.notification.ContentNotificationAddedEvent;
import com.atlassian.confluence.event.events.content.mail.notification.SpaceNotificationAddedEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.follow.FollowEvent;
import com.atlassian.confluence.event.events.label.LabelAddEvent;
import com.atlassian.confluence.event.events.label.LabelCreateEvent;
import com.atlassian.confluence.event.events.label.LabelDeleteEvent;
import com.atlassian.confluence.event.events.label.LabelEvent;
import com.atlassian.confluence.event.events.label.LabelRemoveEvent;
import com.atlassian.confluence.event.events.like.AbstractLikeEvent;
import com.atlassian.confluence.event.events.like.LikeCreatedEvent;
import com.atlassian.confluence.event.events.like.LikeRemovedEvent;
import com.atlassian.confluence.event.events.search.SearchPerformedEvent;
import com.atlassian.confluence.event.events.security.LoginEvent;
import com.atlassian.confluence.event.events.security.LogoutEvent;
import com.atlassian.confluence.event.events.space.SpaceCreateEvent;
import com.atlassian.confluence.event.events.space.SpaceEvent;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.event.events.space.SpaceUpdateEvent;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Labelling;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import io.moewe.confluence.addons.awards.AwardsEvent;
import io.moewe.confluence.addons.awards.KarmaUserProfile;
import io.moewe.confluence.addons.awards.rest.pojo.parameter.ProcessorParameter;
import io.moewe.confluence.addons.awards.services.KarmaUserManager;
import io.moewe.confluence.addons.awards.services.ProcessorRunner;
import io.moewe.confluence.addons.awards.util.AwardsApplicationManager;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class AwardsEventPublisher {
    private final EventPublisher eventPublisher;
    private final ProcessorRunner processorRunner;
    private final AwardsApplicationManager awardsApplicationManager;
    private final KarmaUserManager karmaUserManager;

    @Inject
    public AwardsEventPublisher(@ComponentImport EventPublisher eventPublisher, ProcessorRunner processorRunner, AwardsApplicationManager awardsApplicationManager, KarmaUserManager karmaUserManager) {
        this.eventPublisher = eventPublisher;
        this.processorRunner = processorRunner;
        this.awardsApplicationManager = awardsApplicationManager;
        this.karmaUserManager = karmaUserManager;
    }

    @PreDestroy
    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @PostConstruct
    public void init() {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onAttachmentCreated(AttachmentCreateEvent event) {
        this.processContentEvent(AwardsEvent.ATTACHMENT_CREATED, (ContentEvent)event);
        this.processUserProfilePictureUpdated((AttachmentEvent)event);
    }

    @EventListener
    public void onAttachmentRemoved(AttachmentRemoveEvent event) {
        this.processContentEvent(AwardsEvent.ATTACHMENT_REMOVED, (ContentEvent)event);
    }

    @EventListener
    public void onAttachmentRestored(GeneralAttachmentRestoreEvent event) {
        this.processContentEvent(AwardsEvent.ATTACHMENT_RESTORED, (ContentEvent)event);
    }

    @EventListener
    public void onAttachmentTrashed(AttachmentTrashedEvent event) {
        this.processContentEvent(AwardsEvent.ATTACHMENT_TRASHED, (ContentEvent)event);
    }

    @EventListener
    public void onAttachmentUpdated(AttachmentUpdateEvent event) {
        this.processContentEvent(AwardsEvent.ATTACHMENT_UPDATED, (ContentEvent)event);
        this.processUserProfilePictureUpdated((AttachmentEvent)event);
    }

    @EventListener
    public void onBlogCreated(BlogPostCreateEvent event) {
        this.processContentEvent(AwardsEvent.BLOG_CREATED, (ContentEvent)event);
    }

    @EventListener
    public void onBlogRemoved(BlogPostRemoveEvent event) {
        this.processContentEvent(AwardsEvent.BLOG_REMOVED, (ContentEvent)event);
    }

    @EventListener
    public void onBlogRestored(BlogPostRestoreEvent event) {
        this.processContentEvent(AwardsEvent.BLOG_RESTORED, (ContentEvent)event);
    }

    @EventListener
    public void onBlogTrashed(BlogPostTrashedEvent event) {
        this.processContentEvent(AwardsEvent.BLOG_TRASHED, (ContentEvent)event);
    }

    @EventListener
    public void onBlogUpdated(BlogPostUpdateEvent event) {
        this.processContentEvent(AwardsEvent.BLOG_UPDATED, (ContentEvent)event);
    }

    @EventListener
    public void onCommentCreated(CommentCreateEvent event) {
        this.processContentEvent(AwardsEvent.COMMENT_CREATED, (ContentEvent)event);
    }

    @EventListener
    public void onCommentRemoved(CommentRemoveEvent event) {
        this.processContentEvent(AwardsEvent.COMMENT_REMOVED, (ContentEvent)event);
    }

    @EventListener
    public void onCommentUpdated(CommentUpdateEvent event) {
        this.processContentEvent(AwardsEvent.COMMENT_UPDATED, (ContentEvent)event);
    }

    @EventListener
    public void onLabelAdded(LabelAddEvent event) {
        this.processLabelEvent(AwardsEvent.LABEL_ADDED, (LabelEvent)event);
    }

    @EventListener
    public void onLabelCreated(LabelCreateEvent event) {
        this.processLabelEvent(AwardsEvent.LABEL_CREATED, (LabelEvent)event);
    }

    @EventListener
    public void onLabelDeleted(LabelDeleteEvent event) {
        this.processLabelEvent(AwardsEvent.LABEL_DELETED, (LabelEvent)event);
    }

    @EventListener
    public void onLabelRemoved(LabelRemoveEvent event) {
        this.processLabelEvent(AwardsEvent.LABEL_REMOVED, (LabelEvent)event);
    }

    @EventListener
    public void onLikeCreated(LikeCreatedEvent event) {
        this.processLikeEvent(AwardsEvent.LIKE_CREATED, (AbstractLikeEvent)event);
    }

    @EventListener
    public void onLikeRemoved(LikeRemovedEvent event) {
        this.processLikeEvent(AwardsEvent.LIKE_REMOVED, (AbstractLikeEvent)event);
    }

    @EventListener
    public void onPageCreated(PageCreateEvent event) {
        this.processContentEvent(AwardsEvent.PAGE_CREATED, (ContentEvent)event);
        Page page = event.getPage();
        if (page != null) {
            List outgoingLinks = page.getOutgoingLinks();
            for (OutgoingLink outgoingLink : outgoingLinks) {
                if (outgoingLink.isUrlLink() || outgoingLink.getDestinationPageTitle().equals(page.getDisplayTitle()) && outgoingLink.getDestinationSpaceKey().equals(page.getSpaceKey())) continue;
                this.process(new ProcessorParameter(AwardsEvent.PAGE_INTERNAL_LINK_ADDED, (ConfluenceEvent)event, 0, event.getContent().getIdAsString(), this.awardsApplicationManager.getContextPath() + event.getContent().getUrlPath(), event.getContent().getDisplayTitle()));
                break;
            }
        }
    }

    @EventListener
    public void onPageRemoved(PageRemoveEvent event) {
        this.processContentEvent(AwardsEvent.PAGE_REMOVED, (ContentEvent)event);
    }

    @EventListener
    public void onPageRemoved(PageRestoreEvent event) {
        this.processContentEvent(AwardsEvent.PAGE_RESTORED, (ContentEvent)event);
    }

    @EventListener
    public void onPageTrashed(PageTrashedEvent event) {
        this.processContentEvent(AwardsEvent.PAGE_RESTORED, (ContentEvent)event);
    }

    @EventListener
    public void onPageUpdated(PageUpdateEvent event) {
        this.processContentEvent(AwardsEvent.PAGE_UPDATED, (ContentEvent)event);
        OutgoingLinksExtractor outgoingLinksExtractor = (OutgoingLinksExtractor)ComponentLocator.getComponent(OutgoingLinksExtractor.class);
        Page page = event.getPage();
        if (page != null && outgoingLinksExtractor != null) {
            int outgoingLinksOldSize = 0;
            if (event.getOld() != null) {
                Set outgoingLinksOld = outgoingLinksExtractor.extract((ContentEntityObject)event.getOld());
                this.removeExternalLinksFromSet(outgoingLinksOld, (AbstractPage)page);
                outgoingLinksOldSize = outgoingLinksOld.size();
            }
            int outgoingLinksNewSize = 0;
            if (event.getNew() != null) {
                Set outgoingLinksNew = outgoingLinksExtractor.extract((ContentEntityObject)event.getNew());
                this.removeExternalLinksFromSet(outgoingLinksNew, (AbstractPage)page);
                outgoingLinksNewSize = outgoingLinksNew.size();
            }
            if (outgoingLinksNewSize > outgoingLinksOldSize) {
                this.process(new ProcessorParameter(AwardsEvent.PAGE_INTERNAL_LINK_ADDED, (ConfluenceEvent)event, 0, event.getContent().getIdAsString(), this.awardsApplicationManager.getContextPath() + event.getContent().getUrlPath(), event.getContent().getDisplayTitle()));
            }
        }
    }

    @EventListener
    public void onSpaceCreated(SpaceCreateEvent event) {
        this.processSpaceEvent(AwardsEvent.SPACE_CREATED, (SpaceEvent)event);
    }

    @EventListener
    public void onSpaceRemoved(SpaceRemoveEvent event) {
        this.processSpaceEvent(AwardsEvent.SPACE_REMOVED, (SpaceEvent)event);
    }

    @EventListener
    public void onSpaceUpdated(SpaceUpdateEvent event) {
        this.processSpaceEvent(AwardsEvent.SPACE_UPDATED, (SpaceEvent)event);
    }

    @EventListener
    public void onSearchPerformedEvent(SearchPerformedEvent event) {
        this.process(new ProcessorParameter(AwardsEvent.SEARCHED, (ConfluenceEvent)event, Long.valueOf(System.currentTimeMillis() / 1000L / 60L).hashCode()));
    }

    @EventListener
    public void onLoginEvent(LoginEvent event) {
        String username;
        KarmaUserProfile karmaUserProfile;
        if (event != null && (karmaUserProfile = this.karmaUserManager.getKarmaUserFromUsername(username = event.getUsername())) != null) {
            this.processorRunner.run(new ProcessorParameter(AwardsEvent.LOGIN, (ConfluenceEvent)event), karmaUserProfile);
        }
    }

    @EventListener
    public void onLogoutEvent(LogoutEvent event) {
        String username;
        KarmaUserProfile karmaUserProfile;
        if (event != null && (karmaUserProfile = this.karmaUserManager.getKarmaUserFromUsername(username = event.getUsername())) != null) {
            this.processorRunner.run(new ProcessorParameter(AwardsEvent.LOGOUT, (ConfluenceEvent)event), karmaUserProfile);
        }
    }

    @EventListener
    public void onSpaceNotificationAddedEvent(SpaceNotificationAddedEvent event) {
        Space space = event.getSpace();
        if (space != null) {
            this.process(new ProcessorParameter(AwardsEvent.SPACE_FOLLOWED, (ConfluenceEvent)event, (event.getNotification().getCreator().getName() + "-follow-space-" + space.getId()).hashCode(), space.getId() + "", this.awardsApplicationManager.getContextPath() + space.getUrlPath(), space.getDisplayTitle()));
        }
    }

    @EventListener
    public void onContentNotificationAddedEvent(ContentNotificationAddedEvent event) {
        ContentEntityObject contentEntityObject = event.getNotification().getContent();
        if (contentEntityObject != null) {
            if (contentEntityObject.getType().equals("page")) {
                this.process(new ProcessorParameter(AwardsEvent.PAGE_FOLLOWED, (ConfluenceEvent)event, (event.getNotification().getCreator().getName() + "-follow-page-" + contentEntityObject.getId()).hashCode(), contentEntityObject.getId() + "", this.awardsApplicationManager.getContextPath() + contentEntityObject.getUrlPath(), contentEntityObject.getDisplayTitle()));
            } else if (contentEntityObject.getType().equals("blogpost")) {
                this.process(new ProcessorParameter(AwardsEvent.BLOG_FOLLOWED, (ConfluenceEvent)event, (event.getNotification().getCreator().getName() + "-follow-blogpost-" + contentEntityObject.getId()).hashCode(), contentEntityObject.getId() + "", this.awardsApplicationManager.getContextPath() + contentEntityObject.getUrlPath(), contentEntityObject.getDisplayTitle()));
            }
        }
    }

    @EventListener
    public void onFollowEvent(FollowEvent followEvent) {
        ConfluenceUser follower = followEvent.getFollowerUser();
        ConfluenceUser followedUser = followEvent.getFolloweeUser();
        if (follower != null && followedUser != null) {
            int uniqueEventHash = (follower.getName() + " follows " + followedUser.getName()).hashCode();
            this.processorRunner.run(new ProcessorParameter(AwardsEvent.USER_FOLLOWED, (ConfluenceEvent)followEvent, uniqueEventHash, follower.getName(), followEvent.getFolloweeUser().getFullName()), follower);
            this.processorRunner.run(new ProcessorParameter(AwardsEvent.USER_BE_FOLLOWED, (ConfluenceEvent)followEvent, uniqueEventHash, null, followedUser.getFullName()), followedUser);
        }
    }

    private void processContentEvent(AwardsEvent awardsEvent, ContentEvent contentEvent) {
        this.process(new ProcessorParameter(awardsEvent, (ConfluenceEvent)contentEvent, 0, contentEvent.getContent().getIdAsString(), this.awardsApplicationManager.getContextPath() + contentEvent.getContent().getUrlPath(), contentEvent.getContent().getDisplayTitle()));
    }

    private void processSpaceEvent(AwardsEvent awardsEvent, SpaceEvent spaceEvent) {
        Space space = spaceEvent.getSpace();
        if (space != null) {
            this.process(new ProcessorParameter(awardsEvent, (ConfluenceEvent)spaceEvent, 0, space.getId() + "", this.awardsApplicationManager.getContextPath() + space.getUrlPath()));
            if (AwardsEvent.SPACE_CREATED.equals((Object)awardsEvent) && space.isPersonal()) {
                int eventHash = (spaceEvent.getSpace().getCreator().getName() + "-created-personal-space").hashCode();
                this.processorRunner.run(new ProcessorParameter(AwardsEvent.PERSONAL_SPACE_CREATED, (ConfluenceEvent)spaceEvent, eventHash, space.getId() + "", this.awardsApplicationManager.getContextPath() + space.getUrlPath()), space.getCreator());
            }
        }
    }

    private void processLabelEvent(AwardsEvent awardsEvent, LabelEvent labelEvent) {
        Labelable labelled = labelEvent.getLabelled();
        Label label = labelEvent.getLabel();
        Namespace labelNamespace = label.getNamespace();
        if (!(!(labelled instanceof ContentEntityObject) || "favourite".equals(label.getName()) && "my".equals(labelNamespace.getPrefix()))) {
            ContentEntityObject contentEntityObject = (ContentEntityObject)labelled;
            int uniqueEventHash = (contentEntityObject.getId() + "-" + contentEntityObject.getVersion()).hashCode();
            ConfluenceUser confluenceUser = null;
            for (Labelling labelling : contentEntityObject.getLabellings()) {
                if (labelling.getLabel().getId() != label.getId()) continue;
                confluenceUser = labelling.getOwningUser();
            }
            this.processorRunner.run(new ProcessorParameter(awardsEvent, (ConfluenceEvent)labelEvent, uniqueEventHash, contentEntityObject.getIdAsString(), this.awardsApplicationManager.getContextPath() + contentEntityObject.getUrlPath(), contentEntityObject.getDisplayTitle()), confluenceUser);
        }
    }

    private void processLikeEvent(AwardsEvent event, AbstractLikeEvent likeEvent) {
        ContentEntityObject contentEntityObject = likeEvent.getContent();
        if (contentEntityObject != null) {
            int uniqueEventHash = (contentEntityObject.getId() + "-" + contentEntityObject.getVersion()).hashCode();
            this.process(new ProcessorParameter(event, (ConfluenceEvent)likeEvent, uniqueEventHash, contentEntityObject.getIdAsString(), this.awardsApplicationManager.getContextPath() + contentEntityObject.getUrlPath(), contentEntityObject.getDisplayTitle()));
            if (contentEntityObject.getCreator() != null && likeEvent.getOriginatingUser() != null && !contentEntityObject.getCreator().getName().equals(likeEvent.getOriginatingUser().getName())) {
                this.processorRunner.run(new ProcessorParameter(AwardsEvent.USER_CONTENT_IS_LIKED, (ConfluenceEvent)likeEvent, uniqueEventHash, contentEntityObject.getIdAsString(), this.awardsApplicationManager.getContextPath() + contentEntityObject.getUrlPath(), contentEntityObject.getDisplayTitle()), contentEntityObject.getCreator());
            }
        }
    }

    private void process(ProcessorParameter processorParameter) {
        this.processorRunner.run(processorParameter, AuthenticatedUserThreadLocal.get());
    }

    private void processUserProfilePictureUpdated(AttachmentEvent attachmentEvent) {
        ContentEntityObject content = attachmentEvent.getContent();
        if (content instanceof PersonalInformation) {
            this.processorRunner.run(new ProcessorParameter(AwardsEvent.USER_PROFILE_PICTURE_UPDATED, (ConfluenceEvent)attachmentEvent, Long.valueOf(System.currentTimeMillis() / 1000L / 60L).hashCode(), String.valueOf(content.getId()), new String[0]), ((PersonalInformation)content).getUser());
        }
    }

    private void removeExternalLinksFromSet(Set<OutgoingLink> outgoingLinks, AbstractPage ceo) {
        Iterator<OutgoingLink> outIterator = outgoingLinks.iterator();
        while (outIterator.hasNext()) {
            OutgoingLink next = outIterator.next();
            boolean remove = false;
            if (next.isUrlLink()) {
                remove = true;
            }
            if (next.getDestinationPageTitle().equals(ceo.getDisplayTitle()) && next.getDestinationSpaceKey().equals(ceo.getSpaceKey())) {
                remove = true;
            }
            if (!remove) continue;
            outIterator.remove();
        }
    }
}

