/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.atlassian.sdk.internal.license;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class MoeweLicenseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoeweLicenseService.class);
    private final PluginLicenseManager pluginLicenseManager;

    @Inject
    public MoeweLicenseService(@ComponentImport PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValid() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            Option error = pluginLicense.getError();
            if (!error.isDefined()) return true;
            LOGGER.debug("The license is invalid: {}", error.get());
            return false;
        } else {
            LOGGER.debug("No valid license found.");
        }
        return false;
    }

    public boolean isInvalid() {
        return !this.isValid();
    }

    public String getLicenseError() {
        if (!this.pluginLicenseManager.getLicense().isDefined()) {
            return "No installed license found.";
        }
        String returnMessage = "";
        PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
        Option error = pluginLicense.getError();
        if (!error.isDefined()) {
            return "";
        }
        block7: for (LicenseError licenseError : error) {
            switch (licenseError) {
                case USER_MISMATCH: {
                    returnMessage = "Invalid license: The current installed license supports fewer users than the application.";
                    continue block7;
                }
                case EDITION_MISMATCH: {
                    returnMessage = "Invalid license: The current installed license is of a lesser edition than the application license.";
                    continue block7;
                }
                case EXPIRED: {
                    returnMessage = "Invalid license: The current installed license is time-limited and its expiration date has passed.";
                    continue block7;
                }
                case TYPE_MISMATCH: {
                    returnMessage = "Invalid license: The type of the current installed plugin license is incompatible with the license type of the application.";
                    continue block7;
                }
                case VERSION_MISMATCH: {
                    returnMessage = "Invalid license: The current installed license is not valid for the current version of the plugin.";
                    continue block7;
                }
            }
            returnMessage = "Invalid license: License found but invalid.";
        }
        return returnMessage;
    }
}

