/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.atlassian.sdk.auiforms.rest.entities.controller;

import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.moewe.atlassian.sdk.auiforms.Form;
import io.moewe.atlassian.sdk.auiforms.annotation.AuthenticatedUser;
import io.moewe.atlassian.sdk.auiforms.exceptions.FormException;
import io.moewe.atlassian.sdk.auiforms.rest.entities.EntityScheme;
import io.moewe.atlassian.sdk.auiforms.rest.entities.Scheme;
import io.moewe.atlassian.sdk.auiforms.rest.entities.SchemeFactory;
import io.moewe.atlassian.sdk.auiforms.rest.entities.response.FormResponse;
import io.moewe.atlassian.sdk.auiforms.rest.entities.response.ValidationFailureResponse;
import io.moewe.atlassian.sdk.auiforms.util.ValidatorFactory;
import io.moewe.atlassian.sdk.internal.rest.response.ErrorResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FormController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormController.class);
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    protected I18nResolver i18nResolver;
    protected UserManager userManager;
    private final Validator validator;
    private final Class<? extends Form> formClass;

    public FormController(I18nResolver i18nResolver, UserManager userManager) {
        this(i18nResolver, userManager, null);
    }

    public FormController(I18nResolver i18nResolver, UserManager userManager, Class<? extends Form> formClass) {
        this.i18nResolver = i18nResolver;
        this.userManager = userManager;
        this.validator = ValidatorFactory.getValidatior(i18nResolver);
        this.formClass = formClass;
    }

    @GET
    @Path(value="/form")
    public Response get(@QueryParam(value="id") String id) {
        try {
            if (!this.isAuthorized(this.getFormClass(id))) {
                LOGGER.warn("User is not authorized to retrieve form identifier " + id);
                return Response.status((int)401).build();
            }
            Form form = this.getForm(id);
            if (form == null) {
                LOGGER.warn("Form with identifier " + id + " not exist");
                return Response.status((int)404).build();
            }
            String responseBody = MAPPER.writeValueAsString(form);
            return Response.ok((Object)responseBody).build();
        }
        catch (Exception e) {
            LOGGER.error("Exception form with identifier " + id, (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="/form-validate")
    public Response getFormValidation(@FormParam(value="id") String id, @FormParam(value="content") String content) {
        try {
            Class<? extends Form> formClass = this.getFormClass(id);
            if (!this.isAuthorized(formClass)) {
                return Response.status((int)401).build();
            }
            Form form = this.getFormFromJson(formClass, content);
            Map<String, String> errors = this.validate(form);
            if (errors.size() > 0) {
                return new ValidationFailureResponse(errors).build();
            }
        }
        catch (FormException e) {
            LOGGER.error("Exception form with identifier " + id + " and content " + content, (Throwable)e);
            return new ErrorResponse().build();
        }
        return Response.ok(new FormResponse()).build();
    }

    @GET
    @Path(value="/form-response")
    public Response getFormResponse(@QueryParam(value="id") String id) {
        try {
            Class<? extends Form> formClass = this.getFormClass(id);
            if (!this.isAuthorized(formClass)) {
                LOGGER.warn("User is not authorized to retrieve form identifier " + id);
                return Response.status((int)401).build();
            }
            Form form = this.getForm(id);
            if (form == null) {
                form = formClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            FormResponse<Scheme> formResponse = new FormResponse<Scheme>();
            formResponse.setFields(this.getSchemeOfForm(form));
            formResponse.setFormClass(formClass);
            return Response.ok(formResponse).build();
        }
        catch (Exception e) {
            LOGGER.error("Exception form with identifier " + id, (Throwable)e);
            return new ErrorResponse().build();
        }
    }

    @GET
    @Path(value="/scheme")
    public Response getSchemaResponse(@QueryParam(value="className") String className, @QueryParam(value="i18nPrefix") String i18nPrefix, @QueryParam(value="namePrefix") String namePrefix) {
        try {
            Class<?> schemeClass = Class.forName(className);
            Object entity = null;
            if (SchemeFactory.isEntityType(schemeClass)) {
                entity = schemeClass.getDeclaredConstructors()[0].newInstance(new Object[0]);
            }
            return Response.ok((Object)this.getScheme(i18nPrefix, namePrefix, schemeClass, entity)).build();
        }
        catch (ClassNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOGGER.error("Exception while getting instance of " + className, (Throwable)e);
            return new ErrorResponse().build();
        }
    }

    public Scheme getScheme(String i18nPrefix, String namePrefix, Class<?> schemeClass, Object entity) {
        return SchemeFactory.getScheme(schemeClass, "", entity, this.i18nResolver, i18nPrefix, namePrefix);
    }

    public List<Scheme> getSchemeOfForm(Form form) {
        return SchemeFactory.getFormScheme(form, this.i18nResolver);
    }

    @POST
    @Path(value="/form")
    @Consumes(value={"application/json"})
    public Response saveJsonForm(@QueryParam(value="id") String id, String content) {
        return this.save(id, content);
    }

    @POST
    @Path(value="/form")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response save(@FormParam(value="id") String id, @FormParam(value="content") String content) {
        try {
            Class<? extends Form> formClass = this.getFormClass(id);
            if (!this.isAuthorized(formClass)) {
                return Response.status((int)401).build();
            }
            Form form = this.getFormFromJson(formClass, content);
            Map<String, String> errors = this.validate(form);
            if (errors.size() > 0) {
                return new ValidationFailureResponse(errors).build();
            }
            String responseBody = MAPPER.writeValueAsString(this.saveForm(form));
            return Response.ok((Object)responseBody).build();
        }
        catch (Exception e) {
            LOGGER.error("Exception form with identifier " + id + " and content " + content, (Throwable)e);
            return new ErrorResponse().build();
        }
    }

    public Class<? extends Form> getFormClass(String id) throws FormException {
        if (this.formClass == null) {
            try {
                return Class.forName(id);
            }
            catch (Exception e) {
                throw new FormException("Invalid form", e);
            }
        }
        return this.formClass;
    }

    public abstract Form getForm(String var1) throws FormException;

    public abstract Form saveForm(Form var1) throws FormException;

    protected boolean isAuthorized(Class<? extends Form> formClass) {
        UserKey user = this.userManager.getRemoteUserKey();
        return user != null && (formClass.getAnnotation(AuthenticatedUser.class) != null || this.userManager.isSystemAdmin(user));
    }

    private Form getFormFromJson(Class<? extends Form> formClass, String formData) throws FormException {
        Form form;
        try {
            form = MAPPER.readValue(formData, formClass);
        }
        catch (IOException e) {
            throw new FormException(e);
        }
        return form;
    }

    private Map<String, String> validate(Form form) {
        HashMap<String, String> fieldErrors = new HashMap<String, String>();
        try {
            Set constraintViolations = this.validator.validate((Object)form, new Class[0]);
            Iterator iterator2 = constraintViolations.iterator();
            List<Scheme> schemes = SchemeFactory.getFormScheme(form, this.i18nResolver);
            while (iterator2.hasNext()) {
                this.addFieldError(fieldErrors, schemes, (ConstraintViolation<Form>)((ConstraintViolation)iterator2.next()));
            }
        }
        catch (NoClassDefFoundError e) {
            if (GeneralUtil.getBuildNumber().compareTo("8101") < 0) {
                LOGGER.warn("Please upgrade Confluence to > 7.x. Form validation is not fully implemented for older versions of Confluence: {}", (Object)e.getMessage());
            }
            throw e;
        }
        return fieldErrors;
    }

    private void addFieldError(Map<String, String> fieldErrors, List<Scheme> schemes, ConstraintViolation<Form> constraintViolation) {
        for (Scheme scheme : schemes) {
            String fieldName = scheme.getName();
            if (scheme instanceof EntityScheme && ((EntityScheme)scheme).getSchemes().size() > 0) {
                this.addFieldError(fieldErrors, ((EntityScheme)scheme).getSchemes(), constraintViolation);
                continue;
            }
            if (!fieldName.equals(constraintViolation.getPropertyPath().toString())) continue;
            String errorKey = constraintViolation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName();
            String customMessageKey = "io.moewe.atlassian.sdk.auiforms.response.field.error." + errorKey;
            String customMessage = this.i18nResolver.getText(customMessageKey);
            if (customMessage.equals(customMessageKey)) {
                customMessage = constraintViolation.getMessage();
            }
            fieldErrors.put(scheme.getName(), customMessage);
        }
    }
}

