/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.atlassian.sdk.auiforms.rest.entities;

import com.atlassian.sal.api.message.I18nResolver;
import io.moewe.atlassian.sdk.auiforms.Form;
import io.moewe.atlassian.sdk.auiforms.annotation.RepeatableSchemeConfig;
import io.moewe.atlassian.sdk.auiforms.annotation.SchemeConfig;
import io.moewe.atlassian.sdk.auiforms.rest.entities.EntityScheme;
import io.moewe.atlassian.sdk.auiforms.rest.entities.FieldOptionScheme;
import io.moewe.atlassian.sdk.auiforms.rest.entities.FieldScheme;
import io.moewe.atlassian.sdk.auiforms.rest.entities.RepeatableScheme;
import io.moewe.atlassian.sdk.auiforms.rest.entities.Scheme;
import io.moewe.atlassian.sdk.auiforms.rest.entities.filters.AutocompleteFieldSchemeFilter;
import io.moewe.atlassian.sdk.auiforms.rest.entities.filters.BooleanFieldSchemeFilter;
import io.moewe.atlassian.sdk.auiforms.rest.entities.filters.EnumFieldSchemeFilter;
import io.moewe.atlassian.sdk.auiforms.rest.entities.filters.FieldSchemeFilter;
import io.moewe.atlassian.sdk.auiforms.rest.entities.filters.StringArrayFieldSchemeFilter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemeFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemeFactory.class);
    private static final Map<String, SchemeConfig.Variant> FIELD_TYPE_VARIANTS = new HashMap<String, SchemeConfig.Variant>(){
        {
            this.put("boolean", SchemeConfig.Variant.CHECKBOX);
            this.put(Boolean.class.toString(), SchemeConfig.Variant.CHECKBOX);
        }
    };
    private static final Set<Class<?>> FIELD_TYPES = new HashSet<Class<?>>(){
        {
            this.add(Boolean.class);
            this.add(Character.class);
            this.add(Byte.class);
            this.add(Short.class);
            this.add(Integer.class);
            this.add(Long.class);
            this.add(Float.class);
            this.add(Double.class);
            this.add(Void.class);
            this.add(String.class);
        }
    };
    private static final Set<Class<?>> REPEATABLE_TYPES = new HashSet<Class<?>>(){
        {
            this.add(List.class);
            this.add(Set.class);
            this.add(Queue.class);
            this.add(Collection.class);
            this.add(Iterable.class);
        }
    };
    private static final FieldSchemeFilter[] FILTERS = new FieldSchemeFilter[]{new BooleanFieldSchemeFilter(), new StringArrayFieldSchemeFilter(), new EnumFieldSchemeFilter(), new AutocompleteFieldSchemeFilter()};

    private SchemeFactory() {
    }

    public static List<Scheme> getFormScheme(Form form, I18nResolver i18nResolver) {
        LOGGER.debug("Processing fields for form: {} ({})", form.getClass(), (Object)form.getKey());
        return SchemeFactory.getFormScheme(form.getClass(), form, i18nResolver, form.getKey(), "");
    }

    public static List<Scheme> getFormScheme(Class<?> clazz, Object entity, I18nResolver i18nResolver, String i18nPrefix, String namePrefix) {
        ArrayList<Scheme> fields = new ArrayList<Scheme>();
        Field[] allFields = FieldUtils.getFieldsWithAnnotation(clazz, SchemeConfig.class);
        if (allFields.length > 0) {
            for (Field field : allFields) {
                fields.add(SchemeFactory.getSchemeOfField(field, entity, i18nResolver, i18nPrefix, namePrefix));
            }
            fields.sort(Comparator.comparingInt(Scheme::getOrder));
        }
        return fields;
    }

    public static Scheme getScheme(Class<?> clazz, String name, Object entity, I18nResolver i18nResolver, String i18nPrefix, String namePrefix) {
        return SchemeFactory.buildDescription(clazz, name, i18nResolver, i18nPrefix, namePrefix, entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Scheme getSchemeOfField(Field field, Object entity, I18nResolver i18nResolver, String i18nPrefix, String namePrefix) {
        Scheme scheme = null;
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            scheme = SchemeFactory.buildDescription(field.getType(), field.getName(), i18nResolver, i18nPrefix, namePrefix, SchemeFactory.getFieldObject(field, entity));
            SchemeConfig fieldConfiguration = field.getAnnotation(SchemeConfig.class);
            scheme.setReadonly(fieldConfiguration.readonly());
            block12: for (Annotation annotation : field.getAnnotations()) {
                switch (annotation.annotationType().getSimpleName()) {
                    case "NotEmpty": 
                    case "NotNull": {
                        scheme.setRequired(true);
                        break block12;
                    }
                    default: {
                        continue block12;
                    }
                }
            }
            scheme.setOrder(fieldConfiguration.order());
            scheme.setFieldCSSClasses(fieldConfiguration.width().getCSSClass());
            if (scheme instanceof RepeatableScheme) {
                RepeatableSchemeConfig repeatableScheme = field.getAnnotation(RepeatableSchemeConfig.class);
                ArrayList<FieldOptionScheme> repeatableClasses = new ArrayList<FieldOptionScheme>();
                if (repeatableScheme != null) {
                    Class[] repeatableSchemeClasses = repeatableScheme.classes();
                    if (repeatableSchemeClasses == null || repeatableSchemeClasses.length == 0) {
                        repeatableClasses.add(new FieldOptionScheme(i18nResolver.getText(i18nPrefix + ".fields." + scheme.getName() + ".option." + String.class.getSimpleName() + ".label"), String.class.getName()));
                    } else {
                        String fieldName = scheme.getName();
                        Arrays.stream(repeatableSchemeClasses).forEach(repeatableSchemeClass -> repeatableClasses.add(new FieldOptionScheme(i18nResolver.getText(i18nPrefix + ".fields." + fieldName + ".option." + repeatableSchemeClass.getSimpleName() + ".label"), repeatableSchemeClass.getName())));
                    }
                }
                ((RepeatableScheme)scheme).setRepeatableClasses(repeatableClasses);
                ((RepeatableScheme)scheme).setI18nPrefix(i18nPrefix);
            } else if (scheme instanceof FieldScheme) {
                SchemeFactory.overwriteFieldSchemeVariant((FieldScheme)scheme, fieldConfiguration);
                for (FieldSchemeFilter filter : FILTERS) {
                    filter.filter((FieldScheme)scheme, field, entity, i18nResolver, i18nPrefix);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            field.setAccessible(accessible);
        }
        return scheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFieldObject(Field field, Object entity) {
        boolean accessible = field.isAccessible();
        Object fieldEntity = null;
        if (entity != null) {
            field.setAccessible(true);
            try {
                fieldEntity = field.get(entity);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            finally {
                field.setAccessible(accessible);
            }
        }
        return fieldEntity;
    }

    private static Scheme buildDescription(Class<?> type, String fieldName, I18nResolver i18nResolver, String i18nPrefix, String namePrefix, Object entity) {
        Scheme scheme;
        if (!(namePrefix == null || namePrefix.isEmpty() || namePrefix.endsWith("]") || namePrefix.endsWith("."))) {
            namePrefix = namePrefix + "[";
        }
        if (fieldName != null && !fieldName.isEmpty() && !namePrefix.isEmpty() && namePrefix.endsWith("[")) {
            fieldName = fieldName + "]";
        }
        if (fieldName != null && !fieldName.isEmpty() && !namePrefix.isEmpty() && namePrefix.endsWith("[]")) {
            fieldName = "[" + fieldName + "]";
        }
        if (type.isArray()) {
            fieldName = fieldName + "[]";
        }
        String name = namePrefix + fieldName;
        String label = i18nResolver.getText(i18nPrefix + ".fields." + name + ".label");
        String desc = i18nResolver.getText(i18nPrefix + ".fields." + name + ".description");
        if (SchemeFactory.isRepeatableType(type)) {
            Collection collection;
            scheme = new RepeatableScheme(name, label, desc);
            if (entity != null && !(collection = (Collection)entity).isEmpty()) {
                for (Object item : collection) {
                    ((RepeatableScheme)scheme).addScheme(SchemeFactory.buildDescription(item.getClass(), namePrefix + fieldName + "[]", i18nResolver, i18nPrefix, "", item));
                }
            }
        } else if (SchemeFactory.isEntityType(type)) {
            scheme = new EntityScheme(name, label, desc);
            ((EntityScheme)scheme).setEntityClass(type);
            ((EntityScheme)scheme).setSchemes(SchemeFactory.getFormScheme(type, entity, i18nResolver, i18nPrefix, namePrefix + fieldName));
        } else {
            scheme = new FieldScheme(name, label, desc);
            String fieldType = type.getName();
            if (type.isArray() && type.getComponentType() != null) {
                fieldType = type.getComponentType().getName();
            }
            if (FIELD_TYPE_VARIANTS.containsKey(fieldType)) {
                ((FieldScheme)scheme).setVariant(FIELD_TYPE_VARIANTS.get(fieldType).name().toLowerCase());
            }
            if (entity != null) {
                ((FieldScheme)scheme).setValue(entity);
            }
        }
        return scheme;
    }

    public static boolean isEntityType(Class<?> type) {
        return !type.isPrimitive() && !FIELD_TYPES.contains(type) && !type.isEnum() && (!type.isArray() || SchemeFactory.isEntityType(type.getComponentType()));
    }

    public static boolean isRepeatableType(Class<?> type) {
        return !Collections.disjoint(REPEATABLE_TYPES, Arrays.asList(type.getInterfaces()));
    }

    private static void overwriteFieldSchemeVariant(FieldScheme fieldScheme, SchemeConfig scheme) {
        switch (scheme.variant()) {
            case RADIO: {
                fieldScheme.setVariant(SchemeConfig.Variant.RADIO.name().toLowerCase());
                break;
            }
            case CHECKBOX: 
            case PASSWORD: 
            case TIME: 
            case HIDDEN: 
            case SELECT: 
            case TEXTAREA: {
                fieldScheme.setVariant(scheme.variant().name().toLowerCase());
            }
        }
    }
}

