/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jtype;

import com.googlecode.jtype.AbstractTypeVisitor;
import com.googlecode.jtype.ClassSerializer;
import com.googlecode.jtype.Utils;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SerializingTypeVisitor
extends AbstractTypeVisitor {
    private final ClassSerializer serializer;
    private final StringBuilder builder;

    public SerializingTypeVisitor(ClassSerializer serializer) {
        Utils.checkNotNull(serializer, "serializer");
        this.serializer = serializer;
        this.builder = new StringBuilder();
    }

    @Override
    public void visit(Class<?> type) {
        if (type.isArray()) {
            this.visit(type.getComponentType());
            this.builder.append("[]");
        } else {
            this.builder.append(this.serializer.toString(type));
        }
    }

    @Override
    public <D extends GenericDeclaration> boolean beginVisit(TypeVariable<D> type) {
        this.builder.append(type.getName());
        return true;
    }

    @Override
    public void visitTypeVariableBound(Type bound, int index) {
        if (bound != Object.class || index != 0) {
            this.builder.append(index == 0 ? " extends " : " & ");
            this.visit(bound);
        }
    }

    @Override
    public void visit(GenericArrayType type) {
        this.visit(type.getGenericComponentType());
        this.builder.append("[]");
    }

    @Override
    public boolean beginVisit(ParameterizedType type) {
        Type ownerType = type.getOwnerType();
        if (ownerType != null) {
            this.visit(ownerType);
            this.builder.append(".");
        }
        this.visit(type.getRawType());
        if (type.getActualTypeArguments().length > 0) {
            this.builder.append("<");
        }
        return true;
    }

    @Override
    public void visitActualTypeArgument(Type type, int index) {
        if (index > 0) {
            this.builder.append(", ");
        }
        this.visit(type);
    }

    @Override
    public void endVisit(ParameterizedType type) {
        if (type.getActualTypeArguments().length > 0) {
            this.builder.append(">");
        }
    }

    @Override
    public boolean beginVisit(WildcardType type) {
        this.builder.append("?");
        return true;
    }

    @Override
    public void visitUpperBound(Type bound, int index) {
        if (bound != Object.class || index != 0) {
            this.builder.append(index == 0 ? " extends " : " & ");
            this.visit(bound);
        }
    }

    @Override
    public void visitLowerBound(Type bound, int index) {
        this.builder.append(index == 0 ? " super " : " & ");
        this.visit(bound);
    }

    public String toString() {
        return this.builder.toString();
    }
}

