/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jtype;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClassUtils {
    private static final Map<String, String> PRIMITIVE_DESCRIPTORS_BY_CLASS_NAME = ClassUtils.createPrimitiveDescriptorsByClassName();

    private ClassUtils() {
        throw new AssertionError();
    }

    public static String getUnqualifiedClassName(Class<?> klass) {
        return ClassUtils.getUnqualifiedClassName(klass.getName());
    }

    public static String getUnqualifiedClassName(String className) {
        int dot = className.lastIndexOf(46);
        return dot == -1 ? className : className.substring(dot + 1);
    }

    public static String getSimpleClassName(Class<?> klass) {
        return ClassUtils.getSimpleClassName(klass.getName());
    }

    public static String getSimpleClassName(String className) {
        int index = className.lastIndexOf(36);
        if (index == -1) {
            index = className.lastIndexOf(46);
        }
        return index == -1 ? className : className.substring(index + 1);
    }

    public static Class<?> getArrayType(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    public static Class<?> valueOf(String className) {
        if (ClassUtils.isPrimitiveClassName(className)) {
            return ClassUtils.valueOfPrimitive(className);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException exception) {
            return null;
        }
    }

    private static Map<String, String> createPrimitiveDescriptorsByClassName() {
        HashMap<String, String> primitiveDescriptorsByClassName = new HashMap<String, String>();
        primitiveDescriptorsByClassName.put("byte", "B");
        primitiveDescriptorsByClassName.put("char", "C");
        primitiveDescriptorsByClassName.put("double", "D");
        primitiveDescriptorsByClassName.put("float", "F");
        primitiveDescriptorsByClassName.put("int", "I");
        primitiveDescriptorsByClassName.put("long", "J");
        primitiveDescriptorsByClassName.put("short", "S");
        primitiveDescriptorsByClassName.put("boolean", "Z");
        return Collections.unmodifiableMap(primitiveDescriptorsByClassName);
    }

    private static Class<?> valueOfPrimitive(String className) {
        String descriptor = ClassUtils.getPrimitiveDescriptor(className);
        String arrayDescriptor = ClassUtils.getArrayDescriptor(descriptor);
        Class<?> arrayType = ClassUtils.valueOf(arrayDescriptor);
        return arrayType.getComponentType();
    }

    private static boolean isPrimitiveClassName(String className) {
        return PRIMITIVE_DESCRIPTORS_BY_CLASS_NAME.containsKey(className);
    }

    private static String getPrimitiveDescriptor(String className) {
        if (!ClassUtils.isPrimitiveClassName(className)) {
            throw new IllegalArgumentException("className is not a primitive class name: " + className);
        }
        return PRIMITIVE_DESCRIPTORS_BY_CLASS_NAME.get(className);
    }

    private static String getArrayDescriptor(String componentDescriptor) {
        return "[" + componentDescriptor;
    }
}

