// intentionally global
apc = {
    scriptMessages: {
        pageTitleEmpty: AJS.I18n.getText("page.title.empty"),
        editorSwitch: AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.apceditorswitch")
    },
    addRequiredMarker: function(scope) { // can be used to add required-markers (red star) to any element
        scope
        .append('<span class="aui-icon icon-required" />')
        .append('<span class="content">' + AJS.I18n.getText('required.field') + '</span>');
    },
    addInfoAboutRequiredFields: function() {
        AJS.messages.info('#editmyprofileform', {
            closeable: false, insert: "prepend",
            body: AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.required.fields')
        });
    },
    isAtLeastConfluence57: function() {
        return AJS.Meta.get('build-number') >= 5780;
    },
    isAtLeastConfluence60: function() {
        return AJS.Meta.get('build-number') >= 7101;
    },
    isAtLeastConfluence65: function() {
        return AJS.Meta.get('build-number') >= 7502;
    },
    resetTabindex: function(context) {
        AJS.$('[tabindex]', context || document).not('[tabindex="0"]').not('[tabindex^="-"]')
        .attr("tabindex", '0');
    },
    makeTabbable: function(context, options) {
        var options = options || {};
        AJS.$(context || document)
        .attr('tabindex', '0'); // make focusable
    },
    makeClickableViaKeyboard: function(context, options) { //for span or other elements that not clickable by default
        var options = options || {};
        AJS.$(context || document)
        .off('keyup.apc').on('keyup.apc', function(event) { // make activatable via keyboard
            if (event.keyCode == 13) { // enter
                $(this).click();
                if (typeof options.afterClickCallback == 'function') {
                    options.afterClickCallback.call(this);
                }
            }
        });
    },
    focusableElementsSelector: "a[href], area[href], input:not([disabled]), select:not([disabled]), textarea:not([disabled]), button:not([disabled]), iframe, object, embed, *[tabindex], *[contenteditable]"
};

AJS.toInit(function($) {
    // removing the tabindex has to come first, because for some elements we reset it later
    // we want elements whose tabindex is > 0. that is not directly possible with selectors. hence the following workaround.
    apc.resetTabindex();
});

AJS.$(document).ready(function($) {
    // Java Locales use '_' as separator, but HTML lang tags use '-'.
    var locale = AJS.Meta.get('user-locale');
    if (locale) {
        var lang = locale.replace(/_/g, '-');
        $('html').attr('lang', lang);
        AJS.Meta.set('user-lang', lang);
    }

    // intentionally global
    $.extend(apc, {
        existsAPCModeForPage: AJS.Meta.get('apc-exists-apc-mode-for-page'), // meta tags set in APCRedirectAndMetaTagFilter
        isAPCModeEnabled: AJS.Meta.get('apc-is-apc-mode-enabled'),
    });

    var body = $("body");

    function addOnboardingHiddenLink() {
        var skipOnboardingLabel = AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.welcome.skipWelcome");
        body.prepend("<a id='apcSkipOnboarding' class='apc-offscreen' href='#'>" + skipOnboardingLabel + "</a>");
        $("#apcSkipOnboarding").on("click", function() {
            try {
                require('confluence/ob/flow/controller/flow-progress-tracker').completeFlow("introWorkflow");
                window.location = AJS.contextPath();
            } catch (e) {
                // log case where AMD module is not available
                console.warn("Onboarding process not skipped. Can not access confluence module: confluence/ob/flow/controller/flow-progress-tracker.")
            }
        });
    }

    if (body.hasClass("apc")) { // we are in screen-reader views
        // adding attribute target to all tags in footer
        $("#footer a.hover-footer-link", body).attr("target", "_blank");

        //check for embedded attachments and add TITLE-tags
        $('a[data-linked-resource-type="attachment"]').find('span, img').each(function(index) {
            // regular expression to extract file extension from string
            var re = /(?:\.([^.]+))?$/;
            var fileExtension = re.exec($(this).parent().attr("data-linked-resource-default-alias"))[1];
            if (fileExtension) {
                var dataType = "";
                switch (fileExtension) {
                    case 'doc':
                    case 'docm':
                    case 'docx':
                        dataType = AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.page.attachments.word");
                        break;
                    case 'ppt':
                    case 'pptm':
                    case 'ppsx':
                    case 'ppsm':
                    case 'pps':
                    case 'pptx':
                        dataType = AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.page.attachments.powerpoint");
                        break;
                    case 'xls':
                    case 'xlsm':
                    case 'xlsb':
                    case 'xlsx':
                        dataType = AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.page.attachments.excel");
                        break;
                    case 'jpeg':
                    case 'jpg':
                    case 'png':
                        dataType = AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.page.attachments.image");
                        break;
                    case 'mp4':
                    case 'mp3':
                    case 'avi':
                    case 'flv':
                    case 'wmv':
                    case 'wav':
                    case 'mov':
                        dataType = AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.page.attachments.multimedia");
                        break;
                    default:
                        dataType = $(this).parent().attr("data-nice-type");
                }
                // data-nice-type can be 'null' if Confluence does not recognize the file type
                if (dataType === "null") {
                    var i18nFile = AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.page.attachments.file");
                    dataType = fileExtension + " " + i18nFile;
                }

                //replace '-' and '_' in filename with blanks
                var fileName;
                fileName = $(this).parent().attr("data-linked-resource-default-alias").replace(/(_|-)+/g, ' ');

                // attachments with a thumbnail have only an IMG whereas attachments w/out thumbnail have IMG and SPAN
                if ($(this).parent().attr("data-has-thumbnail") === "true" && $(this).is("img")) {
                    // attachment with thumbnail (e.g. PPT); we have to add an ALT tag
                    $(this).attr("alt", dataType + " " + fileName);
                } else if ($(this).parent().attr("data-has-thumbnail") === "false" && $(this).is("span") && $(this).hasClass("title")) {
                    // attachment w/out thumbnail (e.g. ZIP, JAR,...); we have to change TEXT of span[class=title]
                    $(this).text(dataType + " " + fileName);
                }
            }
        });

        //check for image attachments and add ALT-tags if they don't have one
        $('img[data-linked-resource-type="attachment"]').each(function(index) {
            var altText = $(this).attr("alt");
            if (typeof altText === "undefined" || altText === "") {
                $(this).attr("alt", AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.page.attachments.image") + " " + $(this).attr("data-linked-resource-default-alias"))
            }
        });

        //enabling the enter click in the "browse for files" in the "attachment" macro
        if ($('.plugin_attachments_container').length > 0) {
            $('.browse-files').on('keydown', function(event) {
                if (event.key === 'Enter' || event.keyCode === 13) {
                    event.preventDefault();
                    $(this).click();
                }
            });
        }

        // load whole page tree via REST
        var pageTree = $("#apcPageTree");
        if (pageTree.length) {
            var url = AJS.contextPath() + "/rest/apc/1.0/pageTree/" + encodeURIComponent(AJS.params.pageId);
            $.getJSON(url)
            .done(function(json) {
                function generatePageTree(page, depth) {
                    var pageTitle = $("<div>").text(page.displayTitle).html();
                    var listItem = $("<li/>");
                    var pageLink = $("<a href='" + AJS.contextPath() + page.urlPath + "' title='" + pageTitle + "'>" + pageTitle + "</a>");
                    if (page.isHomePage)
                        pageLink.text(pageLink.text() + ' (' + AJS.I18n.getText("space-homepage") + ')');
                    if (page.isCurrentPage)
                        pageLink.text(pageLink.text() + ' (' + AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.page.current") + ')');
                    listItem.append(pageLink);
                    if (!$.isEmptyObject(page.children)) {
                        var uList = $("<ul class='apc-depth-" + depth + "'>");
                        $.each(page.children, function(index, child) {
                            uList.append(generatePageTree(child, depth + 1));
                        });
                        listItem.append(uList);
                    }
                    return listItem;
                }

                pageTree.empty();
                $.each(json, function(index, page) {
                    pageTree.append(generatePageTree(page, 1));
                });
            })
            .fail(function(jqxhr, textStatus, error) {
                var err = textStatus + ", " + error;
            });
        }

        // focus elements if exists
        var focusElement = $("#apc-edit-form-content, #apc-labels-edit-form, #apc-wikiMarkupContent, #apc-reply-form-content");

        if ($("#apc-createpageform").size() == 1) {
            var firstAccessibilityTemplate = $('#apc_templates_fieldset input[name="accessibility_template"]').first();
            focusElement = firstAccessibilityTemplate.length ? firstAccessibilityTemplate : $("#apc-title");
        }

        if (focusElement.size() == 1) {
            // set focus at the end of content in textfield
            var content = focusElement.val();
            // ie11 needs a delay
            setTimeout(function() {
                focusElement.focus().val('').val(content);
            }, 200);
        } else {
            // focus by anchor tag
            var anchor = window.location.hash;
            var anchorElement = jQuery(anchor);
            if (anchorElement.size() == 1) {
                anchorElement.attr('tabindex', "0").focus();
            }
        }

        // add setFocus to onClick of quicksearch skip link
        $('#skip-links').find('a[href="#apc-skiplink-quicksearch"]').click(function() {
            var apcQuickSearchInput = $('#apc-quicksearch');
            if (apcQuickSearchInput.length > 0)
                apcQuickSearchInput.focus();
        });

        var contentError = $("#comments-text-editor .aui-message.error:first");
        if (contentError.length) {
            // IE8: focus the input, NOT the label!
            $('#' + contentError.parent("label").attr('for')).focus();
        }

        // placeholder fix for unsupported browsers
        $('input[placeholder]').closest('form:visible:first').submit(function() {
            $(this).find('input[placeholder]').each(function() {
                var input = $(this);
                if (input.val() == input.attr('placeholder')) {
                    input.val('');
                }
            });
        });

        // action error overview
        $("div.error p.title").html("<h3 id='apc-error'>" + $("div.error p.title").html() + "</h3>");

        if (apc.isAPCModeEnabled) {
            $("#disableScreenReaderMode").on("click", function() {
                $.get(contextPath + "/users/doEditScreenReaderMode.action?apcModeActive=false&atl_token=" + Confluence.getXsrfToken(), [], function() {
                    location.reload();
                });
                return false;
            });
        }

        apc.addInfoAboutRequiredFields();

        $('a.apc-skiplink').on('click', function() {
            $($(this).attr('href')).focus();
            return false;
        });

    } else { // we are in normal Confluence

        // focus "Let's go" button in onboarding dialog - BFC-681
        AJS.dialog2.on("show", function() {
            var dialog = $(this);
            var welcomeDialogId = "dashboard-onboarding-dialog";
            if (dialog.attr("id") === welcomeDialogId) {
                //observer is needed because the content is not available at the time of the show event
                MutationObserver = window.MutationObserver || window.WebKitMutationObserver;
                //define what we do on manipulation of dom element
                var observer = new MutationObserver(function(mutations, observer) {
                    var focusableElement = dialog.find(".aui-dialog2-footer").find(apc.focusableElementsSelector).first();
                    //make it usable with enter and space
                    apc.makeTabbable(focusableElement);
                    focusableElement.focus();
                });

                // define what element should be observed by the observer
                // and what types of mutations trigger the callback
                // dialog[0] because this need a js element and not a jquery element
                observer.observe(dialog[0], {
                    subtree: true,
                    childList: true
                });
            }
        });

        // login form, see also apc-login.js
        if (body.hasClass("login")) {
            $("#login-container .form-buttons").before('<div class="group"><div id="apc-mode-container" class="checkbox"></div></div>');
            $("#apc-mode-container").append('<input type="checkbox" class="checkbox" name="apc_login_mode" id="apc_login_mode" value="on">');
            $("#apc-mode-container").append('<label for="apc_login_mode">'
                + AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.login.checkbox.label") + '</label>');

            $("#login-container .icon-close").attr("title", AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.login.close"));

            var errorMessage = $("#login-container .aui-message.error");
            if (errorMessage.size() == 1) {
                $("#os_username-label").append(errorMessage.clone());
                $("#os_username-label .aui-message.error").addClass("apc-offscreen");
                $("#os_password-label").append(errorMessage.clone());
                $("#os_password-label .aui-message.error").addClass("apc-offscreen");
            }
        } else if (document.location.pathname.includes('/login.action')) {
            // since Confluence 9.1 we need to wait until the login-form appears
            const loginFormObserver = new MutationObserver(mutations => {
                var loginForm = $("#login-form");
                if (loginForm.length) {
                    loginFormObserver.disconnect();

                    // Extract classes from existing checkbox elements
                    var existingLabel = $("#rememberMe-uid3-label");
                    var existingCheckbox = existingLabel.find("input[type='checkbox']");
                    var existingSvg = existingLabel.find("svg");
                    var existingSpan = existingLabel.find("span");

                    // Get class names
                    var labelClasses = existingLabel.attr("class") || "";
                    var checkboxClasses = existingCheckbox.attr("class") || "";
                    var svgClasses = existingSvg.attr("class") || "";
                    var spanClasses = existingSpan.attr("class") || "";

                    // Get style names
                    var labelStyle = existingLabel.attr("style") || "";
                    var checkboxStyle = existingCheckbox.attr("style") || "";
                    var svgStyle = existingSvg.attr("style") || "";
                    var spanStyle = existingSpan.attr("style") || "";

                    // Create your checkbox with the same classes
                    $("#login-form footer").before('<div class="css-wwet8f" id="apc-mode-container"></div>');
                    $("#apc-mode-container").append(`<label id="apc-enable-screen-reader-label" for="apc_login_mode" class="${labelClasses}" style="${labelStyle}"></label>`);
                    var label = $("#apc-enable-screen-reader-label");
                    label.append(`<input type="checkbox" name="apc_login_mode" id="apc_login_mode" value="on" class="${checkboxClasses}" style="${checkboxStyle}">`);
                    label.append(`<svg viewBox="0 0 24 24" role="presentation" class="${svgClasses}"  style="${svgStyle}">` +
                        '<g fill-rule="evenodd"><rect fill="currentColor" x="6" y="6" width="12" height="12" rx="2"></rect>' +
                        '<path d="M9.707 11.293a1 1 0 1 0-1.414 1.414l2 2a1 1 0 0 0 1.414 0l4-4a1 1 0 1 0-1.414-1.414L11 12.586l-1.293-1.293z" fill="inherit"></path>' +
                        '</g></svg>');
                    label.append(`<span class="${spanClasses}" style="${spanStyle}">` + AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.login.checkbox.label") + '</span>');
                }
            });
            loginFormObserver.observe(document.body, {childList: true, subtree: true});

            const glyphObserver = new MutationObserver(mutations => {
                var glyph = $("#apc-enable-screen-reader-label").find("svg");
                if (glyph.length) {
                    glyphObserver.disconnect();
                    $('#apc-mode-container').show();

                    if (!document.cookie.split('; ').find(row => row.startsWith('APC_MODE='))) {
                        document.cookie = "APC_MODE=OFF; SameSite=None; Secure";
                    } else if (document.cookie.includes("APC_MODE=ON")) {
                        document.getElementById("apc_login_mode").checked = true;
                    }

                    const setAPCCookie = () => {
                        if (document.getElementById("apc_login_mode").checked) {
                            document.cookie = "APC_MODE=ON; SameSite=None; Secure";
                        } else {
                            document.cookie = "APC_MODE=OFF; SameSite=None; Secure";
                        }
                    }
                    document.getElementById("apc_login_mode").addEventListener("change", setAPCCookie)
                }
            });
            glyphObserver.observe(document.body, {childList: true, subtree: true});
        }

        var loginLink = $("#loginMessage > p > a");
        if (loginLink.size() == 1) {
            loginLink.html(AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.login.link"));
        }

        var signupLink = $("#signupMessage > p > a");
        if (signupLink.size() == 1) {
            signupLink.html(AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.signup.link"));
        }

        if (!apc.isAPCModeEnabled) {
            if (location.pathname.indexOf("/docreatepage.action") > -1 ||
                location.pathname.indexOf("/docreateblogpost.action") > -1 ||
                location.pathname.indexOf("/doeditpage.action") > -1 ||
                location.pathname.indexOf("/doeditblogpost.action") > -1) {
                var screenReaderModeLabel = AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.page.apc.switch.sr.disabled");
                body.prepend("<span class='apc-offscreen'>" + screenReaderModeLabel + "</span>");
            } else if (location.pathname.indexOf("welcome.action") > -1) {
                addOnboardingHiddenLink();
            } else {
                var screenReaderModeLabel = AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.page.apc.mode");
                body.prepend("<a id='enableScreenReaderMode' class='apc-offscreen' href='#'>" + screenReaderModeLabel + "</a>");

                $("#enableScreenReaderMode").on("click", function() {
                    $.get(contextPath + "/users/doEditScreenReaderMode.action?apcModeActive=true&atl_token=" + Confluence.getXsrfToken(), [], function() {
                        location.reload();
                    });
                    return false;
                });
            }
        } else {
            if (location.pathname.indexOf("welcome.action") > -1) {
                addOnboardingHiddenLink();
            }
        }

        // add message to head that page is not optimized for apc
        if (!apc.existsAPCModeForPage) {
            body.prepend('<div class="apc-offscreen">' + AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.page.not.optimized") + '</div>');
        }

        $('#header #user-menu-link img').attr('alt', function() {
            return $(this).closest('#user-menu-link').attr('title');
        });

        $('#page-metadata-banner #system-content-items a').each(function() {
            $('img', this).attr('alt', this.title);
        });

        $(document).on('apc-hcm-changed', function(event, isHCM) {
            $('body').toggleClass('apc-hcm', !!isHCM);

            // hide logo (and its alt text) if Confluence already shows the text
            var logo = AJS.$('.aui-header .aui-header-logo-confluence .aui-header-logo-device');
            if (logo.next('.aui-header-logo-text').length) {
                logo.toggle(!isHCM);
            }
        });

        // make certain elements focusable and activatable
        $('.navigation-pseudo-link').not('a .navigation-pseudo-link')
        .add('.expand-collapse-trigger')
        .add('#space-tools-menu-trigger')
        .attr('tabindex', '0')
        .on('keyup', function(e) {
            var code = e.keyCode || e.which;
            if (code == '13') {
                $(this).trigger('click');
            }
        });
        $(document).bind('showLayer', function(e, name, dialog) {
            if (dialog.id == 'space-tools') {
                $('#inline-dialog-space-tools :focusable:first').focus();
            }
        });
        // un-/fav buttons in main content of new dashboard in CF 5.9, because it's not possible with pure CSS
        $(document).on('focusin focusout', '.default-list-view .item .item-actions', function(event) {
            $(this).toggleClass('apc-focus', event.type == 'focusin');
        });

        // set placeholder in search field
        $('#search-form #query-string').attr('placeholder', $('#quick-search-query').attr('placeholder'));
        AJS.Confluence.Binder.placeholder(); // init for IE8

        apc.addInfoAboutRequiredFields();

        // for CF 5.1
        $("#search-results-container").after($("#search-sidebar"));

        // search - help link can be selected by tab
        var hb = $('span.search-input-wrapper span.help-button:first');
        if (hb.length) {
            hb.attr("tabindex", "0");
            hb.css("text-indent", "unset");
            hb.text("");
            hb.keyup(function(event) {
                if (event.keyCode == 13) {
                    hb.click();
                }
            });
        }

        // make "Spaces" menu button activatable by keyboard.
        // this should work out-of-the-box, but the dropdown is not shown.
        $('#space-menu-link').on('keyup', function(e) {
            var code = e.keyCode || e.which;
            if (code == '13') {
                $(this).trigger('click').trigger('aui-button-invoke');
            }
        });

        // remove unneccessary tab in attachment and edit page view
        setTimeout(function() {
            jQuery("div.plupload [id$='_html5']").attr("tabindex", "-1")
        }, 500);

        // global fix for missing alt tags for images
        // $("img:not([alt])").attr("alt", "");

        // make popups smaller if they are too wide for the viewport
        AJS.bind('show.dialog', function(event, data) {
            // setTimeout() because Confluence itself adjusts the create-dialog AFTER our event-handler and
            // I don't know how else to make sure that our code runs after Confluence's adjustments.
            setTimeout(function() {
                try {
                    if (data.dialog.width > AJS.$(window).width()) {
                        data.dialog.popup.element.css({
                            width: AJS.$(window).width(),
                            'margin-left': -(AJS.$(window).width() / 2),
                            overflow: 'auto'
                        });
                        data.dialog.popup.element.find('.dialog-panel-body').css({'overflow-x': 'auto'});
                    }
                    if (data.dialog.height > AJS.$(window).height()) {
                        data.dialog.popup.element.css({
                            height: AJS.$(window).height(),
                            'margin-top': -(AJS.$(window).height() / 2),
                            overflow: 'auto'
                        });
                    }
                } catch (e) {
                    if (console && console.error) {
                        console.error('error adjusting the dialog', data, e);
                    }
                }
            }, 500);
        });

    }
});
