AJS.toInit(function ($) {
    // # following code is for vm/comment/list.vm
    var commentLikeLinks = $("a.comment-like, a.comment-unlike"),
        commentResolveReopenLinks = $('a.comment-resolve, a.comment-reopen'),
        replyInlineCommentForms = $('form[data-comment-type="inline"]');

    replyInlineCommentForms.each(function(){
        var form = $(this);
        form.find(".submit").click(function (event) {
            event.preventDefault();

            var parentCommentId = form.attr('data-parent-comment-id');
            var encodedTextareaValue = $("<div>").text(jQuery("#apc-reply-form-content").val()).html();

            replaceLinks(encodedTextareaValue).then(
                function (commentValue) {
                    doAddInlineComment(parentCommentId, commentValue);
                }
            );
        })
    });

    /**
     * Load replacement of the given linkPattern.
     *
     * @param linkPattern
     * @returns a promise that resolve with the replacement for the given linkPattern when the request is complete
     */
    function getLinkReplacement(linkPattern){
        var deferred = $.Deferred();
        var getLinkUrl = "/rest/tinymce/1/wikixhtmlconverter";
        var converterData = {
            wiki: linkPattern,
            entityId: AJS.params.pageId,
            spaceKey: AJS.params.spaceKey,
            suppressFirstParagraph: true
        };
        var replacement = undefined;
        $.ajax({
            url: contextPath + getLinkUrl,
            type: "POST",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(converterData),
            success: function (converterReturnData) {
                replacement = converterReturnData;
            },
            complete: function () {
                //resolve with data when request is complete (error and success)
                deferred.resolve(replacement);
            }
        });
        return deferred.promise();
    }

    /**
     * Replace the all links in the given CommentValue
     *
     * @param commentValue
     * @returns a promise that resolve with the replaced commentValue when all links replaced
     */
    function replaceLinks(commentValue){
        var deferred = $.Deferred();

        var regex = /([[]).+?]/g;
        //regex pattern for an link e.g. [~admin] for user @mention
        var linkInComment = commentValue.match(regex);
        if(linkInComment) {
            var deferreds = [];
            linkInComment.forEach(function(linkPattern){
                //collect the promises for replace linkPattern in an array
                deferreds.push(
                    //replace the linkPattern with replacement after request is complete (... after promise resolved)
                    getLinkReplacement(linkPattern).then(function(replacement){
                        if(replacement){
                            //replace multiple links
                            while(commentValue.indexOf(linkPattern) > -1)
                                commentValue = commentValue.replace(linkPattern, replacement);
                        }
                    })
                );
            });
            //resolve the deferred when all links are replaced (... when all promises in the array resolved)
            $.when.apply($, deferreds).then(function () {
                deferred.resolve(commentValue);
            });
        } else {
            //resolve when no @mentions found
            deferred.resolve(commentValue);
        }
        return deferred.promise();
    }

    /**
     * Add the given commentValue as a reply to the given parentCommentId
     *
     * @param parentCommentId
     * @param commentValue
     */
    function doAddInlineComment(parentCommentId, commentValue){
        var pageId = AJS.params.pageId;
        var addCommentData = {
            authorAvatarUrl : AJS.params.currentUserAvatarUrl,
            authorDisplayName: AJS.params.currentUserFullname,
            authorUserName: AJS.params.remoteUser,
            body: "<p>"+commentValue+"</p>",
            commentId: parentCommentId
        };
        var addInlineCommentUrl = "/rest/inlinecomments/1.0/comments/"+ parentCommentId +"/replies?containerId="+pageId;
        $.ajax({
            url: contextPath + addInlineCommentUrl,
            type: "POST",
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            data: JSON.stringify(addCommentData),
            success: function (data) {
                window.location = AJS.contextPath() + '/apc/pages/viewinlinecomments.action?pageId=' + pageId + '&focusedCommentId=' + data.id + '&#comment-' + data.id;
            },
            error: function (xhr, textStatus, thrownError) {
                var errorDiv = $("<div>");
                errorDiv.text(textStatus + ": " + thrownError);
                errorDiv.insertAfter(form.find("#apc-reply-form-content"));
                errorDiv.focus();
                setTimeout(function(){errorDiv.remove();}, 5000);
            }
        });
    }

    commentLikeLinks.each(function () {
        var commentId = $(this).attr('data-commentId'),
            isLiked = $(this).hasClass("comment-unlike"),
            isInlineComment = $(this).attr('data-isinlinecomment');
        if (commentId.length) {
            $(this).click(function () {
                var likeContentUrl = "/rest/likes/1.0/content/" + commentId + "/likes",
                    likeMethod = isLiked ? "DELETE" : "POST";
                $.ajax({
                    url: contextPath + likeContentUrl,
                    type: likeMethod,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (data) {
                        // browser doesnt reload the page if it thinks it is the same url
                        // so we have to check if the focused comment is the comment we (un)like
                        if (window.location.href.indexOf("focusedCommentId=" + commentId) > -1)
                            window.location.reload(true);
                        else {
                            // the '/space/<spaceKey>/pages/<pageId>/title' url will work because of the redirect
                            // happening due to APCRedirectAndMetaTagFilter.java that translates the url to an apc url
                            var actionPath = (isInlineComment === "true") ?
                                "/apc/pages/viewinlinecomments.action?pageId=" + AJS.params.pageId :
                                "/spaces/" + AJS.params.spaceKey + "/pages/" + AJS.params.pageId + "/" + AJS.params.pageTitle;
                            window.location = AJS.contextPath() + actionPath + '&focusedCommentId=' + commentId + '&#comment-' + commentId;
                        }
                    }
                });
            })
        }
    });

    commentResolveReopenLinks.each(function () {
        var commentId = $(this).attr('data-commentId');
        var resolve = $(this).hasClass("comment-resolve");
        if (commentId.length) {
            $(this).click(function () {
                var reopenCommentUrl = "/rest/inlinecomments/1.0/comments/" + commentId + "/resolve/" + resolve + "/dangling/false";
                $.ajax({
                    url: contextPath + reopenCommentUrl,
                    type: "PUT",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (data) {
                        // browser doesnt reload the page if it thinks it is the same url
                        // so we have to check if the focused comment is the comment we resolve
                        if (window.location.href.indexOf("focusedCommentId=" + commentId) > -1)
                            window.location.reload(true);
                        else
                            window.location = AJS.contextPath() + '/apc/pages/viewinlinecomments.action?pageId=' + AJS.params.pageId + '&focusedCommentId=' + commentId + '&#comment-' + commentId;
                    }
                });
            })
        }
    });
});
