/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.shared;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import lombok.Generated;

public class LicenseState {
    private List<String> licenses;
    private Date startDate;

    public LicenseState(Collection<String> licenses) {
        this(licenses, LocalDate.now());
    }

    public LicenseState(Collection<String> licenses, LocalDate startDate) {
        this.startDate = LicenseState.toJavaDate(startDate);
        this.licenses = new ArrayList<String>(licenses);
    }

    public LicenseState(Collection<String> licenses, Date startDate) {
        this.startDate = startDate;
        this.licenses = new ArrayList<String>(licenses);
    }

    public LocalDate getLocalStartDate() {
        return LicenseState.fromJavaDate(this.startDate);
    }

    private static Date toJavaDate(LocalDate date) {
        return Date.from(date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    private static LocalDate fromJavaDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    @Generated
    public List<String> getLicenses() {
        return this.licenses;
    }

    @Generated
    public Date getStartDate() {
        return this.startDate;
    }

    @Generated
    public void setLicenses(List<String> licenses) {
        this.licenses = licenses;
    }

    @Generated
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LicenseState)) {
            return false;
        }
        LicenseState other = (LicenseState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$licenses = this.getLicenses();
        List<String> other$licenses = other.getLicenses();
        if (this$licenses == null ? other$licenses != null : !((Object)this$licenses).equals(other$licenses)) {
            return false;
        }
        Date this$startDate = this.getStartDate();
        Date other$startDate = other.getStartDate();
        return !(this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LicenseState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $licenses = this.getLicenses();
        result = result * 59 + ($licenses == null ? 43 : ((Object)$licenses).hashCode());
        Date $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LicenseState(licenses=" + this.getLicenses() + ", startDate=" + this.getStartDate() + ")";
    }

    @Generated
    public LicenseState() {
    }
}

