/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.util;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlUtil {
    private XmlUtil() {
    }

    public static List<Node> asList(NodeList n) {
        return n.getLength() == 0 ? Collections.emptyList() : new NodeListWrapper(n);
    }

    public static List<Node> asList(NamedNodeMap n) {
        return n.getLength() == 0 ? Collections.emptyList() : new NamedNodeMapWrapper(n);
    }

    static final class NodeListWrapper
    extends AbstractList<Node>
    implements RandomAccess {
        private final NodeList list;

        NodeListWrapper(NodeList l) {
            this.list = l;
        }

        @Override
        public Node get(int index) {
            return this.list.item(index);
        }

        @Override
        public int size() {
            return this.list.getLength();
        }
    }

    static final class NamedNodeMapWrapper
    extends AbstractList<Node>
    implements RandomAccess {
        private final NamedNodeMap map;

        NamedNodeMapWrapper(NamedNodeMap nnm) {
            this.map = nnm;
        }

        @Override
        public Node get(int index) {
            return this.map.item(index);
        }

        @Override
        public int size() {
            return this.map.getLength();
        }
    }
}

