/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.util;

import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapper;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapperFactory;
import jakarta.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class PlaceholderUtils {
    private final StrutsWrapper strutsWrapper;

    @Inject
    public PlaceholderUtils(StrutsWrapperFactory strutsWrapperFactory) {
        this.strutsWrapper = strutsWrapperFactory.getStrutsWrapper();
    }

    public Object getObject(Long contentId) {
        return this.strutsWrapper.getRequest().getSession().getAttribute(this.getPlaceholderKeyForContent(contentId));
    }

    public void setObject(Long contentId, Object value) {
        this.strutsWrapper.getRequest().getSession().setAttribute(this.getPlaceholderKeyForContent(contentId), value);
    }

    public void removeObject(Long contentId) {
        this.strutsWrapper.getRequest().getSession().removeAttribute(this.getPlaceholderKeyForContent(contentId));
    }

    private String getPlaceholderKeyForContent(Long contentId) {
        return "content.id" + contentId;
    }
}

