/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.rest;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.communardo.confluence.plugins.apc.entity.PageEntity;
import de.communardo.confluence.plugins.apc.util.APCHelper;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
@Path(value="/")
@Produces(value={"application/json"})
public class APCRestHelper {
    private final PageManager pageManager;
    private final APCHelper apcHelper;

    @Inject
    public APCRestHelper(@ComponentImport PageManager pageManager, APCHelper apcHelper) {
        this.pageManager = pageManager;
        this.apcHelper = apcHelper;
    }

    @GET
    @Path(value="pageTree/{pageId}")
    public Response getPageTree(@PathParam(value="pageId") String pageIdString) {
        try {
            int pageId = Integer.parseInt(pageIdString);
            Page page = this.pageManager.getPage((long)pageId);
            if (page != null) {
                List<PageEntity> pageTree = this.apcHelper.getPageTree(page);
                return Response.status((int)200).entity(pageTree).build();
            }
            return Response.status((int)404).entity((Object)("\"Could not find page with id: " + pageIdString + "\"")).build();
        }
        catch (NumberFormatException e) {
            return Response.status((int)400).entity((Object)("\"Cannot parse id. Wrong page id string provided: " + pageIdString + "\"")).build();
        }
    }
}

