/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.license;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import de.communardo.shared.LicenseAbuseDetectionService;
import jakarta.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class APCLicenseService {
    private static final Logger LOG = LoggerFactory.getLogger(APCLicenseService.class);
    private final PluginLicenseManager pluginLicenseManager;
    private final LicenseAbuseDetectionService licenseAbuseDetectionService;

    @Inject
    public APCLicenseService(@ComponentImport PluginLicenseManager pluginLicenseManager, LicenseAbuseDetectionService licenseAbuseDetectionService) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.licenseAbuseDetectionService = licenseAbuseDetectionService;
    }

    public boolean isValidLicense() {
        if (this.licenseAbuseDetectionService.isAbuseDetected()) {
            LOG.debug("License abuse detected, license is not valid.");
            return false;
        }
        return this.isValidLicenseForUrlCondition();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidLicenseForUrlCondition() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (!pluginLicense.getError().isDefined()) return true;
            LOG.debug("License found but invalid.");
            return false;
        } else {
            LOG.debug("No installed license found.");
        }
        return false;
    }
}

